/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.RouteTableAssociationDescription;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class AssociateRouteTable
extends BaseCmd {
    public static final String[] SUBNET_DESC = new String[]{"SUBNET is the subnet to which to associate this route table."};

    public AssociateRouteTable(String[] args) {
        super("ec2assocrtb", "ec2-associate-route-table");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    protected Options getOptions() {
        Options o = new Options();
        OptionBuilder.withLongOpt((String)"subnet");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"SUBNET");
        OptionBuilder.withDescription((String)AssociateRouteTable.joinDescription(SUBNET_DESC));
        o.addOption(OptionBuilder.create((String)"s"));
        return o;
    }

    @Override
    public String getOptionString() {
        return "ROUTE_TABLE -s SUBNET";
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Associate a route table with a subnet.");
        System.out.println("     ROUTE_TABLE is the route table that you wish to associate.");
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
        super.printOption("subnet");
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.assertNonOptionSet("ROUTE_TABLE");
        this.assertOptionSet("subnet");
        this.warnIfTooManyNonOptions();
        String routeTableId = this.getNonOptions()[0];
        String subnetId = this.getOptionValue("subnet");
        RequestResultPair result = jec2.associateRouteTable(routeTableId, subnetId);
        RouteTableAssociationDescription assoc = new RouteTableAssociationDescription((String)result.getResponse(), routeTableId, subnetId, Boolean.valueOf(false));
        out.output(System.out, assoc);
        out.printRequestId(System.out, (RequestResult)result);
        return true;
    }

    public static void main(String[] args) {
        new AssociateRouteTable(args).invoke();
    }
}

