/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.grants;

import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.jboss.logging.Logger;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.Profile;
import org.keycloak.events.EventBuilder;
import org.keycloak.http.HttpRequest;
import org.keycloak.http.HttpResponse;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.oidc.OIDCAdvancedConfigWrapper;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.protocol.oidc.grants.OAuth2GrantType;
import org.keycloak.protocol.oidc.utils.AuthorizeClientUtil;
import org.keycloak.rar.AuthorizationRequestContext;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.services.CorsErrorResponseException;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.cors.Cors;
import org.keycloak.services.util.AuthorizationContextUtil;
import org.keycloak.services.util.MtlsHoKTokenUtil;
import org.keycloak.util.TokenUtil;

public abstract class OAuth2GrantTypeBase
implements OAuth2GrantType {
    private static final Logger logger = Logger.getLogger(OAuth2GrantTypeBase.class);
    protected OAuth2GrantType.Context context;
    protected KeycloakSession session;
    protected RealmModel realm;
    protected ClientModel client;
    protected OIDCAdvancedConfigWrapper clientConfig;
    protected ClientConnection clientConnection;
    protected Map<String, String> clientAuthAttributes;
    protected MultivaluedMap<String, String> formParams;
    protected EventBuilder event;
    protected Cors cors;
    protected TokenManager tokenManager;
    protected HttpRequest request;
    protected HttpResponse response;
    protected HttpHeaders headers;

    protected void setContext(OAuth2GrantType.Context context) {
        this.context = context;
        this.session = context.session;
        this.realm = context.realm;
        this.client = context.client;
        this.clientConfig = (OIDCAdvancedConfigWrapper)context.clientConfig;
        this.clientConnection = context.clientConnection;
        this.clientAuthAttributes = context.clientAuthAttributes;
        this.request = context.request;
        this.response = context.response;
        this.headers = context.headers;
        this.formParams = context.formParams;
        this.event = context.event;
        this.cors = context.cors;
        this.tokenManager = (TokenManager)context.tokenManager;
    }

    protected Response createTokenResponse(UserModel user, UserSessionModel userSession, ClientSessionContext clientSessionCtx, String scopeParam, boolean code, Function<TokenManager.AccessTokenResponseBuilder, ClientPolicyContext> clientPolicyContextGenerator) {
        clientSessionCtx.setAttribute("grant_type", (Object)this.context.getGrantType());
        AccessToken token = this.tokenManager.createClientAccessToken(this.session, this.realm, this.client, user, userSession, clientSessionCtx);
        TokenManager.AccessTokenResponseBuilder responseBuilder = this.tokenManager.responseBuilder(this.realm, this.client, this.event, this.session, userSession, clientSessionCtx).accessToken(token);
        boolean useRefreshToken = this.clientConfig.isUseRefreshToken();
        if (useRefreshToken) {
            responseBuilder.generateRefreshToken();
            if ("Offline".equals(responseBuilder.getRefreshToken().getType()) && clientSessionCtx.getClientSession().getNote("first.offline.access") != null) {
                this.session.sessions().removeUserSession(this.realm, userSession);
            }
        }
        this.checkAndBindMtlsHoKToken(responseBuilder, useRefreshToken);
        if (TokenUtil.isOIDCRequest((String)scopeParam)) {
            responseBuilder.generateIDToken().generateAccessTokenHash();
        }
        if (clientPolicyContextGenerator != null) {
            try {
                this.session.clientPolicy().triggerOnEvent(clientPolicyContextGenerator.apply(responseBuilder));
            }
            catch (ClientPolicyException cpe) {
                this.event.detail("reason", "client_policy_error");
                this.event.detail("client_policy_error", cpe.getError());
                this.event.detail("client_policy_error_detail", cpe.getErrorDetail());
                this.event.error(cpe.getError());
                throw new CorsErrorResponseException(this.cors, cpe.getError(), cpe.getErrorDetail(), cpe.getErrorStatus());
            }
        }
        AccessTokenResponse res = null;
        if (code) {
            try {
                res = responseBuilder.build();
            }
            catch (RuntimeException re) {
                if ("can not get encryption KEK".equals(re.getMessage())) {
                    throw new CorsErrorResponseException(this.cors, "invalid_request", "can not get encryption KEK", Response.Status.BAD_REQUEST);
                }
                throw re;
            }
        } else {
            res = responseBuilder.build();
        }
        this.event.success();
        return this.cors.add(Response.ok((Object)res).type(MediaType.APPLICATION_JSON_TYPE));
    }

    protected void checkAndBindMtlsHoKToken(TokenManager.AccessTokenResponseBuilder responseBuilder, boolean useRefreshToken) {
        if (this.clientConfig.isUseMtlsHokToken()) {
            AccessToken.Confirmation confirmation = MtlsHoKTokenUtil.bindTokenWithClientCertificate(this.request, this.session);
            if (confirmation != null) {
                responseBuilder.getAccessToken().setConfirmation(confirmation);
                if (useRefreshToken) {
                    responseBuilder.getRefreshToken().setConfirmation(confirmation);
                }
            } else {
                String errorMessage = "Client Certification missing for MTLS HoK Token Binding";
                this.event.detail("reason", errorMessage);
                this.event.error("invalid_request");
                throw new CorsErrorResponseException(this.cors, "invalid_request", errorMessage, Response.Status.BAD_REQUEST);
            }
        }
    }

    protected void updateClientSession(AuthenticatedClientSessionModel clientSession) {
        if (clientSession == null) {
            ServicesLogger.LOGGER.clientSessionNull();
            return;
        }
        String adapterSessionId = (String)this.formParams.getFirst((Object)"client_session_state");
        if (adapterSessionId != null) {
            String oldClientSessionHost;
            String adapterSessionHost = (String)this.formParams.getFirst((Object)"client_session_host");
            logger.debugf("Adapter Session '%s' saved in ClientSession for client '%s'. Host is '%s'", (Object)adapterSessionId, (Object)this.client.getClientId(), (Object)adapterSessionHost);
            String oldClientSessionState = clientSession.getNote("client_session_state");
            if (!adapterSessionId.equals(oldClientSessionState)) {
                clientSession.setNote("client_session_state", adapterSessionId);
            }
            if (!Objects.equals(adapterSessionHost, oldClientSessionHost = clientSession.getNote("client_session_host"))) {
                clientSession.setNote("client_session_host", adapterSessionHost);
            }
        }
    }

    protected void updateUserSessionFromClientAuth(UserSessionModel userSession) {
        for (Map.Entry<String, String> attr : this.clientAuthAttributes.entrySet()) {
            userSession.setNote(attr.getKey(), attr.getValue());
        }
    }

    protected String getRequestedScopes() {
        boolean validScopes;
        String scope = (String)this.formParams.getFirst((Object)"scope");
        if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.DYNAMIC_SCOPES)) {
            AuthorizationRequestContext authorizationRequestContext = AuthorizationContextUtil.getAuthorizationRequestContextFromScopes(this.session, scope);
            validScopes = TokenManager.isValidScope(this.session, scope, authorizationRequestContext, this.client, null);
        } else {
            validScopes = TokenManager.isValidScope(this.session, scope, this.client, null);
        }
        if (!validScopes) {
            String errorMessage = "Invalid scopes: " + scope;
            this.event.detail("reason", errorMessage);
            this.event.error("invalid_request");
            throw new CorsErrorResponseException(this.cors, "invalid_scope", errorMessage, Response.Status.BAD_REQUEST);
        }
        return scope;
    }

    protected void checkClient() {
        AuthorizeClientUtil.ClientAuthResult clientAuth = AuthorizeClientUtil.authorizeClient(this.session, this.event, this.cors);
        this.client = clientAuth.getClient();
        this.clientAuthAttributes = clientAuth.getClientAuthAttributes();
        this.clientConfig = OIDCAdvancedConfigWrapper.fromClientModel(this.client);
        this.cors.allowedOrigins(this.session, this.client);
        if (this.client.isBearerOnly()) {
            throw new CorsErrorResponseException(this.cors, "invalid_client", "Bearer-only not allowed", Response.Status.BAD_REQUEST);
        }
    }

    public void close() {
    }
}

