/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.jgroups.certificates;

import java.io.File;
import java.time.Duration;
import java.util.List;
import java.util.Set;
import org.keycloak.Config;
import org.keycloak.config.CachingOptions;
import org.keycloak.config.Option;
import org.keycloak.jgroups.certificates.DatabaseJGroupsCertificateProvider;
import org.keycloak.jgroups.certificates.FileJGroupsCertificateProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.Provider;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;
import org.keycloak.spi.infinispan.JGroupsCertificateProvider;
import org.keycloak.spi.infinispan.JGroupsCertificateProviderFactory;
import org.keycloak.storage.configuration.ServerConfigStorageProvider;

public class DefaultJGroupsCertificateProviderFactory
implements JGroupsCertificateProviderFactory {
    private static final String ENABLED = "enabled";
    private static final String ROTATION = "rotation";
    private static final String KEYSTORE_PATH = "keystoreFile";
    private static final String KEYSTORE_PASSWORD = "keystorePassword";
    private static final String TRUSTSTORE_PATH = "truststoreFile";
    private static final String TRUSTSTORE_PASSWORD = "truststorePassword";
    private volatile JGroupsCertificateProvider provider;
    private volatile Config.Scope configuration;

    public JGroupsCertificateProvider create(KeycloakSession session) {
        if (this.provider == null) {
            this.postInit(session.getKeycloakSessionFactory());
        }
        return this.provider;
    }

    public void init(Config.Scope config) {
        this.configuration = config;
    }

    public synchronized void postInit(KeycloakSessionFactory factory) {
        if (this.provider != null) {
            return;
        }
        this.provider = this.createProvider(factory);
    }

    public void close() {
    }

    public String getId() {
        return "default";
    }

    public Set<Class<? extends Provider>> dependsOn() {
        return Set.of(ServerConfigStorageProvider.class);
    }

    public List<ProviderConfigProperty> getConfigMetadata() {
        ProviderConfigurationBuilder builder = ProviderConfigurationBuilder.create();
        DefaultJGroupsCertificateProviderFactory.addEnabledOption(builder);
        DefaultJGroupsCertificateProviderFactory.addRotationOption(builder);
        DefaultJGroupsCertificateProviderFactory.addPropertyForFile(builder, CachingOptions.CACHE_EMBEDDED_MTLS_KEYSTORE, KEYSTORE_PATH);
        DefaultJGroupsCertificateProviderFactory.addPropertyForFile(builder, CachingOptions.CACHE_EMBEDDED_MTLS_TRUSTSTORE, TRUSTSTORE_PATH);
        DefaultJGroupsCertificateProviderFactory.addPropertyForPassword(builder, CachingOptions.CACHE_EMBEDDED_MTLS_KEYSTORE_PASSWORD, KEYSTORE_PASSWORD);
        DefaultJGroupsCertificateProviderFactory.addPropertyForPassword(builder, CachingOptions.CACHE_EMBEDDED_MTLS_TRUSTSTORE_PASSWORD, TRUSTSTORE_PASSWORD);
        return builder.build();
    }

    private JGroupsCertificateProvider createProvider(KeycloakSessionFactory factory) {
        if (!this.configuration.getBoolean(ENABLED, Boolean.FALSE).booleanValue()) {
            return JGroupsCertificateProvider.DISABLED;
        }
        if (this.isKeystoreOrTruststoreConfigured()) {
            return FileJGroupsCertificateProvider.create(this.requireConfigurationAndFile(KEYSTORE_PATH, CachingOptions.CACHE_EMBEDDED_MTLS_KEYSTORE), this.requireConfiguration(KEYSTORE_PASSWORD, CachingOptions.CACHE_EMBEDDED_MTLS_KEYSTORE_PASSWORD), this.requireConfigurationAndFile(TRUSTSTORE_PATH, CachingOptions.CACHE_EMBEDDED_MTLS_TRUSTSTORE), this.requireConfiguration(TRUSTSTORE_PASSWORD, CachingOptions.CACHE_EMBEDDED_MTLS_TRUSTSTORE_PASSWORD));
        }
        return DatabaseJGroupsCertificateProvider.create(factory, Duration.ofDays(this.requireRotationInDays()));
    }

    private boolean isKeystoreOrTruststoreConfigured() {
        return this.configuration.get(KEYSTORE_PATH) != null || this.configuration.get(TRUSTSTORE_PATH) != null;
    }

    private long requireRotationInDays() {
        Long value = this.configuration.getLong(ROTATION);
        if (value == null) {
            throw new RuntimeException("Property '%s' required but not specified.".formatted(CachingOptions.CACHE_EMBEDDED_MTLS_ROTATION.getKey()));
        }
        return value;
    }

    private String requireConfigurationAndFile(String key, Option<?> option) {
        String value = this.requireConfiguration(key, option);
        if (!new File(value).exists()) {
            throw new RuntimeException("Property '%s' file '%s' does not exist.".formatted(key, value));
        }
        return value;
    }

    private String requireConfiguration(String key, Option<?> option) {
        String value = this.configuration.get(key);
        if (value == null) {
            throw new RuntimeException("Property '%s' required but not specified".formatted(option.getKey()));
        }
        return value;
    }

    private static void addEnabledOption(ProviderConfigurationBuilder builder) {
        DefaultJGroupsCertificateProviderFactory.propertyForOption(builder, CachingOptions.CACHE_EMBEDDED_MTLS_ENABLED).name(ENABLED).type("boolean").label(ENABLED).add();
    }

    private static void addRotationOption(ProviderConfigurationBuilder builder) {
        DefaultJGroupsCertificateProviderFactory.propertyForOption(builder, CachingOptions.CACHE_EMBEDDED_MTLS_ROTATION).name(ROTATION).type("Integer").label("days").add();
    }

    private static void addPropertyForFile(ProviderConfigurationBuilder builder, Option<?> option, String name) {
        DefaultJGroupsCertificateProviderFactory.propertyForOption(builder, option).name(name).type("String").label("file").add();
    }

    private static void addPropertyForPassword(ProviderConfigurationBuilder builder, Option<?> option, String name) {
        DefaultJGroupsCertificateProviderFactory.propertyForOption(builder, option).name(name).type("Password").label("password").secret(true).add();
    }

    private static ProviderConfigurationBuilder.ProviderConfigPropertyBuilder propertyForOption(ProviderConfigurationBuilder builder, Option<?> option) {
        ProviderConfigurationBuilder.ProviderConfigPropertyBuilder property = builder.property();
        option.getDefaultValue().ifPresent(arg_0 -> ((ProviderConfigurationBuilder.ProviderConfigPropertyBuilder)property).defaultValue(arg_0));
        property.helpText(option.getDescription());
        return property;
    }
}

