/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.nuklear;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct nk_scroll")
public class NkScroll
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;

    public NkScroll(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), NkScroll.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="nk_uint")
    public int x() {
        return NkScroll.nx(this.address());
    }

    @NativeType(value="nk_uint")
    public int y() {
        return NkScroll.ny(this.address());
    }

    public static NkScroll malloc() {
        return (NkScroll)NkScroll.wrap(NkScroll.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static NkScroll calloc() {
        return (NkScroll)NkScroll.wrap(NkScroll.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static NkScroll create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (NkScroll)NkScroll.wrap(NkScroll.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static NkScroll create(long address) {
        return (NkScroll)NkScroll.wrap(NkScroll.class, (long)address);
    }

    @Nullable
    public static NkScroll createSafe(long address) {
        return address == 0L ? null : (NkScroll)NkScroll.wrap(NkScroll.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)NkScroll.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)NkScroll.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)NkScroll.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = NkScroll.__create((int)capacity, (int)SIZEOF);
        return (Buffer)NkScroll.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)NkScroll.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)NkScroll.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static NkScroll mallocStack() {
        return NkScroll.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NkScroll callocStack() {
        return NkScroll.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NkScroll mallocStack(MemoryStack stack) {
        return NkScroll.malloc(stack);
    }

    @Deprecated
    public static NkScroll callocStack(MemoryStack stack) {
        return NkScroll.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return NkScroll.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return NkScroll.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NkScroll.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NkScroll.calloc(capacity, stack);
    }

    public static NkScroll malloc(MemoryStack stack) {
        return (NkScroll)NkScroll.wrap(NkScroll.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static NkScroll calloc(MemoryStack stack) {
        return (NkScroll)NkScroll.wrap(NkScroll.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)NkScroll.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)NkScroll.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nx(long struct) {
        return UNSAFE.getInt(null, struct + (long)X);
    }

    public static int ny(long struct) {
        return UNSAFE.getInt(null, struct + (long)Y);
    }

    static {
        Struct.Layout layout = NkScroll.__struct((Struct.Member[])new Struct.Member[]{NkScroll.__member((int)4), NkScroll.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<NkScroll, Buffer>
    implements NativeResource {
        private static final NkScroll ELEMENT_FACTORY = NkScroll.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected NkScroll getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="nk_uint")
        public int x() {
            return NkScroll.nx(this.address());
        }

        @NativeType(value="nk_uint")
        public int y() {
            return NkScroll.ny(this.address());
        }
    }
}

