/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.beaninfo.editors;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.io.IOException;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.colorchooser.DefaultColorSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.core.UIExceptions;
import org.openide.explorer.propertysheet.editors.XMLPropertyEditor;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class ColorEditor
implements PropertyEditor,
XMLPropertyEditor {
    public static final int AWT_PALETTE = 1;
    public static final int SYSTEM_PALETTE = 2;
    public static final int SWING_PALETTE = 3;
    static String[] awtColorNames;
    private static final Color[] awtColors;
    private static final String[] awtGenerate;
    private static String[] systemColorNames;
    private static final String[] systemGenerate;
    private static final Color[] systemColors;
    private static String[] swingColorNames;
    private static Color[] swingColors;
    static final boolean GTK;
    static final boolean AQUA;
    private static final boolean antialias;
    private static Boolean gtkAA;
    private static Map hintsMap;
    private SuperColor superColor;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    public static final String XML_COLOR = "Color";
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_RED = "red";
    public static final String ATTR_GREEN = "green";
    public static final String ATTR_BLUE = "blue";
    public static final String ATTR_ID = "id";
    public static final String ATTR_PALETTE = "palette";
    public static final String VALUE_PALETTE = "palette";
    public static final String VALUE_RGB = "rgb";
    public static final String VALUE_NULL = "null";

    public static JColorChooser getStaticChooser(ColorEditor colorEditor) {
        JColorChooser jColorChooser = new JColorChooser(new DefaultColorSelectionModel(Color.white){

            public void setSelectedColor(Color color) {
                if (color instanceof SuperColor) {
                    super.setSelectedColor((SuperColor)color);
                } else if (color instanceof Color) {
                    super.setSelectedColor(new SuperColor(color));
                }
            }
        }){

            public void setColor(Color color) {
                if (color == null) {
                    return;
                }
                super.setColor(color);
            }
        };
        jColorChooser.addChooserPanel(new NbColorChooserPanel(1, ColorEditor.getAWTColorNames(), awtColors, ColorEditor.getString("CTL_AWTPalette"), colorEditor));
        ColorEditor.initSwingConstants();
        jColorChooser.addChooserPanel(new NbColorChooserPanel(3, swingColorNames, swingColors, ColorEditor.getString("CTL_SwingPalette"), colorEditor));
        jColorChooser.addChooserPanel(new NbColorChooserPanel(2, ColorEditor.getSystemColorNames(), systemColors, ColorEditor.getString("CTL_SystemPalette"), colorEditor));
        return jColorChooser;
    }

    public Object getValue() {
        if (this.superColor != null) {
            if (this.superColor.getID() != null) {
                return this.superColor;
            }
            return this.superColor.getColor();
        }
        return null;
    }

    public void setValue(Object object) {
        if (object != null) {
            if (object instanceof SuperColor) {
                this.superColor = (SuperColor)object;
            } else if (object instanceof Color) {
                this.superColor = new SuperColor((Color)object);
            }
        } else {
            this.superColor = null;
        }
        this.support.firePropertyChange("", null, null);
    }

    public String getAsText() {
        if (this.superColor == null) {
            return VALUE_NULL;
        }
        return this.superColor.getAsText();
    }

    public void setAsText(String string) throws IllegalArgumentException {
        int n;
        int n2;
        if (string == null) {
            throw new IllegalArgumentException("null parameter");
        }
        if (VALUE_NULL.equals(string = string.trim())) {
            this.setValue(null);
            return;
        }
        try {
            n2 = string.length();
            if (n2 > 0) {
                n = -1;
                int n3 = -1;
                char c = string.charAt(0);
                char c2 = string.charAt(n2 - 1);
                if (c == '[' && c2 == ']') {
                    n = 1;
                    n3 = n2 - 1;
                } else if (c >= '0' && c <= '9' && c2 >= '0' && c2 <= '9') {
                    n = 0;
                    n3 = n2;
                }
                if (n >= 0) {
                    int n4;
                    int n5 = string.indexOf(44);
                    int n6 = n4 = n5 < 0 ? -1 : string.indexOf(44, n5 + 1);
                    if (n5 >= 0 && n4 >= 0) {
                        int n7 = Integer.parseInt(string.substring(n, n5).trim());
                        int n8 = Integer.parseInt(string.substring(n5 + 1, n4).trim());
                        int n9 = Integer.parseInt(string.substring(n4 + 1, n3).trim());
                        try {
                            this.setValue(new SuperColor(null, 0, new Color(n7, n8, n9)));
                            return;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            UIExceptions.annotateUser(illegalArgumentException, null, illegalArgumentException.getLocalizedMessage(), null, null);
                            throw illegalArgumentException;
                        }
                    }
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        n = 0;
        Color color = null;
        n2 = ColorEditor.getIndex(ColorEditor.getAWTColorNames(), string);
        if (n2 >= 0) {
            n = 1;
            color = awtColors[n2];
        }
        if (n2 < 0 && (n2 = ColorEditor.getIndex(ColorEditor.getSystemColorNames(), string)) >= 0) {
            n = 2;
            color = systemColors[n2];
        }
        if (n2 < 0) {
            ColorEditor.initSwingConstants();
            n2 = ColorEditor.getIndex(swingColorNames, string);
            if (n2 >= 0) {
                n = 3;
                color = swingColors[n2];
            }
        }
        if (n2 < 0) {
            String string2 = MessageFormat.format(NbBundle.getMessage(ColorEditor.class, (String)"FMT_IllegalEntry"), string);
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string);
            UIExceptions.annotateUser(illegalArgumentException, string, string2, null, null);
            throw illegalArgumentException;
        }
        this.setValue(new SuperColor(string, n, color));
    }

    public String getJavaInitializationString() {
        if (this.superColor == null) {
            return VALUE_NULL;
        }
        if (this.superColor.getID() == null) {
            return "new java.awt.Color(" + this.superColor.getRed() + ", " + this.superColor.getGreen() + ", " + this.superColor.getBlue() + ")";
        }
        switch (this.superColor.getPalette()) {
            default: {
                return "java.awt.Color." + awtGenerate[ColorEditor.getIndex(ColorEditor.getAWTColorNames(), this.superColor.getID())];
            }
            case 2: {
                return "java.awt.SystemColor." + systemGenerate[ColorEditor.getIndex(ColorEditor.getSystemColorNames(), this.superColor.getID())];
            }
            case 3: 
        }
        if (this.superColor.getID() == null) {
            return "new java.awt.Color(" + this.superColor.getRed() + ", " + this.superColor.getGreen() + ", " + this.superColor.getBlue() + ")";
        }
        return "javax.swing.UIManager.getDefaults().getColor(\"" + this.superColor.getID() + "\")";
    }

    public String[] getTags() {
        if (this.superColor == null) {
            return ColorEditor.getAWTColorNames();
        }
        switch (this.superColor.getPalette()) {
            case 1: {
                return ColorEditor.getAWTColorNames();
            }
            case 2: {
                return ColorEditor.getSystemColorNames();
            }
            case 3: {
                ColorEditor.initSwingConstants();
                return swingColorNames;
            }
        }
        return null;
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        int n;
        Serializable serializable;
        ((Graphics2D)graphics).setRenderingHints(ColorEditor.getHints());
        if (this.superColor != null) {
            serializable = graphics.getColor();
            graphics.drawRect(rectangle.x, rectangle.y + rectangle.height / 2 - 5, 10, 10);
            graphics.setColor(this.superColor);
            graphics.fillRect(rectangle.x + 1, rectangle.y + rectangle.height / 2 - 4, 9, 9);
            graphics.setColor((Color)serializable);
            n = 18;
        } else {
            n = 0;
        }
        serializable = graphics.getFontMetrics();
        graphics.drawString(this.getAsText(), rectangle.x + n, rectangle.y + (rectangle.height - ((FontMetrics)serializable).getHeight()) / 2 + ((FontMetrics)serializable).getAscent());
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        return new NbColorChooser(this, ColorEditor.getStaticChooser(this));
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    private static synchronized String[] getAWTColorNames() {
        if (awtColorNames == null) {
            awtColorNames = new String[]{ColorEditor.getString("LAB_White"), ColorEditor.getString("LAB_LightGray"), ColorEditor.getString("LAB_Gray"), ColorEditor.getString("LAB_DarkGray"), ColorEditor.getString("LAB_Black"), ColorEditor.getString("LAB_Red"), ColorEditor.getString("LAB_Pink"), ColorEditor.getString("LAB_Orange"), ColorEditor.getString("LAB_Yellow"), ColorEditor.getString("LAB_Green"), ColorEditor.getString("LAB_Magenta"), ColorEditor.getString("LAB_Cyan"), ColorEditor.getString("LAB_Blue")};
        }
        return awtColorNames;
    }

    private static synchronized String[] getSystemColorNames() {
        if (systemColorNames == null) {
            systemColorNames = new String[]{ColorEditor.getString("LAB_ActiveCaption"), ColorEditor.getString("LAB_ActiveCaptionBorder"), ColorEditor.getString("LAB_ActiveCaptionText"), ColorEditor.getString("LAB_Control"), ColorEditor.getString("LAB_ControlDkShadow"), ColorEditor.getString("LAB_ControlHighlight"), ColorEditor.getString("LAB_ControlLtHighlight"), ColorEditor.getString("LAB_ControlShadow"), ColorEditor.getString("LAB_ControlText"), ColorEditor.getString("LAB_Desktop"), ColorEditor.getString("LAB_InactiveCaption"), ColorEditor.getString("LAB_InactiveCaptionBorder"), ColorEditor.getString("LAB_InactiveCaptionText"), ColorEditor.getString("LAB_Info"), ColorEditor.getString("LAB_InfoText"), ColorEditor.getString("LAB_Menu"), ColorEditor.getString("LAB_MenuText"), ColorEditor.getString("LAB_Scrollbar"), ColorEditor.getString("LAB_Text"), ColorEditor.getString("LAB_TextHighlight"), ColorEditor.getString("LAB_TextHighlightText"), ColorEditor.getString("LAB_TextInactiveText"), ColorEditor.getString("LAB_TextText"), ColorEditor.getString("LAB_Window"), ColorEditor.getString("LAB_WindowBorder"), ColorEditor.getString("LAB_WindowText")};
        }
        return systemColorNames;
    }

    private static String getString(String string) {
        return NbBundle.getBundle(ColorEditor.class).getString(string);
    }

    private static int getIndex(Object[] objectArray, Object object) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (!object.equals(objectArray[i])) continue;
            return i;
        }
        return -1;
    }

    private static void initSwingConstants() {
        if (swingColorNames != null) {
            return;
        }
        UIDefaults uIDefaults = UIManager.getDefaults();
        Enumeration enumeration = uIDefaults.keys();
        TreeSet<String> treeSet = new TreeSet<String>();
        while (enumeration.hasMoreElements()) {
            Object object;
            Object k = enumeration.nextElement();
            if (!(k instanceof String) || !((object = uIDefaults.get(k)) instanceof Color)) continue;
            treeSet.add((String)k);
        }
        swingColorNames = new String[treeSet.size()];
        treeSet.toArray(swingColorNames);
        swingColors = new Color[swingColorNames.length];
        int n = swingColorNames.length;
        for (int i = 0; i < n; ++i) {
            ColorEditor.swingColors[i] = (Color)uIDefaults.get(swingColorNames[i]);
        }
    }

    private SuperColor getSuperColor() {
        return this.superColor;
    }

    public void readFromXML(Node node) throws IOException {
        if (!XML_COLOR.equals(node.getNodeName())) {
            throw new IOException();
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        try {
            String string = namedNodeMap.getNamedItem(ATTR_TYPE).getNodeValue();
            if (VALUE_NULL.equals(string)) {
                this.setValue(null);
            } else {
                String string2 = namedNodeMap.getNamedItem(ATTR_RED).getNodeValue();
                String string3 = namedNodeMap.getNamedItem(ATTR_GREEN).getNodeValue();
                String string4 = namedNodeMap.getNamedItem(ATTR_BLUE).getNodeValue();
                if ("palette".equals(string)) {
                    int n = Integer.parseInt(namedNodeMap.getNamedItem("palette").getNodeValue());
                    String string5 = namedNodeMap.getNamedItem(ATTR_ID).getNodeValue();
                    if (n == 1) {
                        int n2 = ColorEditor.getIndex(awtGenerate, string5);
                        string5 = n2 >= 0 ? ColorEditor.getAWTColorNames()[n2] : (ColorEditor.getIndex(ColorEditor.getAWTColorNames(), string5) >= 0 ? string5 : null);
                    }
                    this.setValue(new SuperColor(string5, n, new Color(Integer.parseInt(string2, 16), Integer.parseInt(string3, 16), Integer.parseInt(string4, 16))));
                } else {
                    this.setValue(new SuperColor(new Color(Integer.parseInt(string2, 16), Integer.parseInt(string3, 16), Integer.parseInt(string4, 16))));
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            throw new IOException();
        }
    }

    public Node storeToXML(Document document) {
        Element element = document.createElement(XML_COLOR);
        element.setAttribute(ATTR_TYPE, this.superColor == null ? VALUE_NULL : (this.superColor.getID() == null ? VALUE_RGB : "palette"));
        if (this.superColor != null) {
            element.setAttribute(ATTR_RED, Integer.toHexString(this.superColor.getRed()));
            element.setAttribute(ATTR_GREEN, Integer.toHexString(this.superColor.getGreen()));
            element.setAttribute(ATTR_BLUE, Integer.toHexString(this.superColor.getBlue()));
            if (this.superColor.getID() != null) {
                if (this.superColor.getPalette() == 1) {
                    element.setAttribute(ATTR_ID, awtGenerate[ColorEditor.getIndex(ColorEditor.getAWTColorNames(), this.superColor.getID())]);
                } else {
                    element.setAttribute(ATTR_ID, this.superColor.getID());
                }
                element.setAttribute("palette", Integer.toString(this.superColor.getPalette()));
            }
        }
        return element;
    }

    public static final boolean gtkShouldAntialias() {
        if (gtkAA == null) {
            Object object = Toolkit.getDefaultToolkit().getDesktopProperty("gnome.Xft/Antialias");
            gtkAA = Integer.valueOf(1).equals(object);
        }
        return gtkAA;
    }

    private static Map getHints() {
        if (hintsMap == null && (hintsMap = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints")) == null) {
            hintsMap = new HashMap();
            if (antialias) {
                hintsMap.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
        }
        return hintsMap;
    }

    static /* synthetic */ String[] access$002(String[] stringArray) {
        swingColorNames = stringArray;
        return stringArray;
    }

    static /* synthetic */ Color[] access$102(Color[] colorArray) {
        swingColors = colorArray;
        return colorArray;
    }

    static {
        awtColors = new Color[]{Color.white, Color.lightGray, Color.gray, Color.darkGray, Color.black, Color.red, Color.pink, Color.orange, Color.yellow, Color.green, Color.magenta, Color.cyan, Color.blue};
        awtGenerate = new String[]{"white", "lightGray", "gray", "darkGray", "black", ATTR_RED, "pink", "orange", "yellow", ATTR_GREEN, "magenta", "cyan", ATTR_BLUE};
        systemGenerate = new String[]{"activeCaption", "activeCaptionBorder", "activeCaptionText", "control", "controlDkShadow", "controlHighlight", "controlLtHighlight", "controlShadow", "controlText", "desktop", "inactiveCaption", "inactiveCaptionBorder", "inactiveCaptionText", "info", "infoText", "menu", "menuText", "scrollbar", "text", "textHighlight", "textHighlightText", "textInactiveText", "textText", "window", "windowBorder", "windowText"};
        systemColors = new Color[]{SystemColor.activeCaption, SystemColor.activeCaptionBorder, SystemColor.activeCaptionText, SystemColor.control, SystemColor.controlDkShadow, SystemColor.controlHighlight, SystemColor.controlLtHighlight, SystemColor.controlShadow, SystemColor.controlText, SystemColor.desktop, SystemColor.inactiveCaption, SystemColor.inactiveCaptionBorder, SystemColor.inactiveCaptionText, SystemColor.info, SystemColor.infoText, SystemColor.menu, SystemColor.menuText, SystemColor.scrollbar, SystemColor.text, SystemColor.textHighlight, SystemColor.textHighlightText, SystemColor.textInactiveText, SystemColor.textText, SystemColor.window, SystemColor.windowBorder, SystemColor.windowText};
        GTK = "GTK".equals(UIManager.getLookAndFeel().getID());
        AQUA = "Aqua".equals(UIManager.getLookAndFeel().getID());
        antialias = Boolean.getBoolean("nb.cellrenderer.antialiasing") || Boolean.getBoolean("swing.aatext") || GTK && ColorEditor.gtkShouldAntialias() || AQUA;
        UIManager.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ColorEditor.access$002(null);
                ColorEditor.access$102(null);
            }
        });
        swingColorNames = null;
        swingColors = null;
    }

    private static final class NbColorChooserPanel
    extends AbstractColorChooserPanel
    implements ListSelectionListener {
        static final long serialVersionUID = -2792992315444428631L;
        private JList list;
        String[] names;
        Color[] colors;
        int palette;
        ColorEditor ce;
        private String displayName;

        NbColorChooserPanel(int n, String[] stringArray, Color[] colorArray, String string, ColorEditor colorEditor) {
            this.names = stringArray;
            this.colors = colorArray;
            this.palette = n;
            this.displayName = string;
            this.ce = colorEditor;
        }

        protected void buildChooser() {
            this.setLayout(new BorderLayout());
            this.list = new JList<String>(this.names);
            this.add("Center", new JScrollPane(this.list));
            this.list.setCellRenderer(new MyListCellRenderer());
            this.list.addListSelectionListener(this);
            this.list.getAccessibleContext().setAccessibleName(this.displayName);
        }

        public void updateChooser() {
            SuperColor superColor = this.ce.getSuperColor();
            if (superColor != null && this.palette == superColor.getPalette()) {
                int n = ColorEditor.getIndex(this.names, superColor.getID());
                this.list.setSelectedIndex(n);
            } else {
                this.list.clearSelection();
            }
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public Icon getSmallDisplayIcon() {
            return null;
        }

        public Icon getLargeDisplayIcon() {
            return null;
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!this.list.isSelectionEmpty()) {
                int n = this.list.getSelectedIndex();
                this.getColorSelectionModel().setSelectedColor(new SuperColor(this.names[n], this.palette, this.colors[n]));
            }
        }

        public void setColor(Color color) {
            this.getColorSelectionModel().setSelectedColor(color);
        }

        public Color getColor() {
            return this.getColorFromModel();
        }

        private final class MyListCellRenderer
        extends JPanel
        implements ListCellRenderer {
            private boolean selected;
            private boolean hasFocus;
            private int index;
            static final long serialVersionUID = -8877709520578055594L;

            public MyListCellRenderer() {
                this.setOpaque(true);
                this.setBorder(new EmptyBorder(1, 1, 1, 1));
            }

            public Dimension getPreferredSize() {
                try {
                    FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
                    return new Dimension(fontMetrics.stringWidth(NbColorChooserPanel.this.names[this.index]) + 30, fontMetrics.getHeight() + 4);
                }
                catch (NullPointerException nullPointerException) {
                    return new Dimension(10, 10);
                }
            }

            public void paint(Graphics graphics) {
                ((Graphics2D)graphics).setRenderingHints(ColorEditor.getHints());
                Dimension dimension = this.getSize();
                Color color = graphics.getColor();
                if (this.selected) {
                    graphics.setColor(UIManager.getColor("List.selectionBackground"));
                } else {
                    graphics.setColor(UIManager.getColor("List.background"));
                }
                graphics.fillRect(0, 0, dimension.width - 1, dimension.height - 1);
                if (this.hasFocus) {
                    graphics.setColor(Color.black);
                    graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
                }
                graphics.setColor(Color.black);
                graphics.drawRect(6, dimension.height / 2 - 5, 10, 10);
                graphics.setColor(NbColorChooserPanel.this.colors[this.index]);
                graphics.fillRect(7, dimension.height / 2 - 4, 9, 9);
                if (this.selected) {
                    graphics.setColor(UIManager.getColor("List.selectionForeground"));
                } else {
                    graphics.setColor(UIManager.getColor("List.foreground"));
                }
                FontMetrics fontMetrics = graphics.getFontMetrics();
                graphics.drawString(NbColorChooserPanel.this.names[this.index], 22, (dimension.height - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent());
                graphics.setColor(color);
            }

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                this.index = n;
                this.selected = bl;
                this.hasFocus = bl2;
                this.getAccessibleContext().setAccessibleName(NbColorChooserPanel.this.names[n]);
                return this;
            }
        }
    }

    static class SuperColor
    extends Color {
        static final long serialVersionUID = 6147637669184334151L;
        private String id = null;
        private int palette = 0;
        private Color color;

        SuperColor(Color color) {
            super(color.getRed(), color.getGreen(), color.getBlue());
            this.color = color;
        }

        SuperColor(String string, int n, Color color) {
            super(color.getRed(), color.getGreen(), color.getBlue());
            this.color = color;
            this.id = string;
            this.palette = n;
        }

        public boolean equals(Object object) {
            boolean bl = super.equals(object);
            String string = null;
            int n = -1;
            if (!(object instanceof SuperColor)) {
                return bl;
            }
            string = ((SuperColor)object).getID();
            n = ((SuperColor)object).getPalette();
            if (string != null) {
                return bl && string.equals(this.getID()) && n == this.getPalette();
            }
            return bl && null == this.getID() && n == this.getPalette();
        }

        private String getID() {
            return this.id;
        }

        private int getPalette() {
            return this.palette;
        }

        private Color getColor() {
            return this.color;
        }

        private String getAsText() {
            if (this.id != null) {
                return this.id;
            }
            return "[" + this.getRed() + "," + this.getGreen() + "," + this.getBlue() + "]";
        }
    }

    private static class NbColorChooser
    extends JPanel
    implements ChangeListener {
        private final ColorEditor editor;
        private final ColorSelectionModel selectionModel;
        static final long serialVersionUID = -6230228701104365037L;

        public NbColorChooser(ColorEditor colorEditor, JColorChooser jColorChooser) {
            this.editor = colorEditor;
            this.selectionModel = jColorChooser.getSelectionModel();
            this.setLayout(new BorderLayout());
            this.add((Component)jColorChooser, "Center");
            jColorChooser.setColor((Color)colorEditor.getValue());
            this.selectionModel.addChangeListener(this);
            this.getAccessibleContext().setAccessibleDescription(ColorEditor.getString("ACSD_CustomColorEditor"));
        }

        public void removeNotify() {
            super.removeNotify();
            this.selectionModel.removeChangeListener(this);
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            return new Dimension(dimension.width + 50, dimension.height + 10);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            this.editor.setValue(this.selectionModel.getSelectedColor());
        }
    }
}

