/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util.math.intpoly;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import sun.security.util.math.intpoly.IntegerPolynomial;

public class IntegerPolynomial1305
extends IntegerPolynomial {
    protected static final int SUBTRAHEND = 5;
    protected static final int NUM_LIMBS = 5;
    private static final int POWER = 130;
    private static final int BITS_PER_LIMB = 26;
    private static final BigInteger MODULUS = TWO.pow(130).subtract(BigInteger.valueOf(5L));

    public IntegerPolynomial1305() {
        super(26, 5, 1, MODULUS);
    }

    @Override
    protected void mult(long[] lArray, long[] lArray2, long[] lArray3) {
        long l = lArray[0] * lArray2[0];
        long l2 = lArray[0] * lArray2[1] + lArray[1] * lArray2[0];
        long l3 = lArray[0] * lArray2[2] + lArray[1] * lArray2[1] + lArray[2] * lArray2[0];
        long l4 = lArray[0] * lArray2[3] + lArray[1] * lArray2[2] + lArray[2] * lArray2[1] + lArray[3] * lArray2[0];
        long l5 = lArray[0] * lArray2[4] + lArray[1] * lArray2[3] + lArray[2] * lArray2[2] + lArray[3] * lArray2[1] + lArray[4] * lArray2[0];
        long l6 = lArray[1] * lArray2[4] + lArray[2] * lArray2[3] + lArray[3] * lArray2[2] + lArray[4] * lArray2[1];
        long l7 = lArray[2] * lArray2[4] + lArray[3] * lArray2[3] + lArray[4] * lArray2[2];
        long l8 = lArray[3] * lArray2[4] + lArray[4] * lArray2[3];
        long l9 = lArray[4] * lArray2[4];
        this.carryReduce(lArray3, l, l2, l3, l4, l5, l6, l7, l8, l9);
    }

    private void carryReduce(long[] lArray, long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8, long l9) {
        lArray[2] = l3 + l8 * 5L;
        long l10 = this.carryValue(l4 += l9 * 5L);
        lArray[3] = l4 - (l10 << 26);
        long l11 = this.carryValue(l5 += l10);
        lArray[4] = l5 - (l11 << 26);
        lArray[0] = l + (l6 += l11) * 5L;
        lArray[1] = l2 + l7 * 5L;
        this.carry(lArray);
    }

    @Override
    protected void square(long[] lArray, long[] lArray2) {
        long l = lArray[0] * lArray[0];
        long l2 = 2L * (lArray[0] * lArray[1]);
        long l3 = 2L * (lArray[0] * lArray[2]) + lArray[1] * lArray[1];
        long l4 = 2L * (lArray[0] * lArray[3] + lArray[1] * lArray[2]);
        long l5 = 2L * (lArray[0] * lArray[4] + lArray[1] * lArray[3]) + lArray[2] * lArray[2];
        long l6 = 2L * (lArray[1] * lArray[4] + lArray[2] * lArray[3]);
        long l7 = 2L * (lArray[2] * lArray[4]) + lArray[3] * lArray[3];
        long l8 = 2L * (lArray[3] * lArray[4]);
        long l9 = lArray[4] * lArray[4];
        this.carryReduce(lArray2, l, l2, l3, l4, l5, l6, l7, l8, l9);
    }

    @Override
    protected void encode(ByteBuffer byteBuffer, int n, byte by, long[] lArray) {
        if (n == 16) {
            long l = byteBuffer.getLong();
            long l2 = byteBuffer.getLong();
            this.encode(l2, l, by, lArray);
        } else {
            super.encode(byteBuffer, n, by, lArray);
        }
    }

    protected void encode(long l, long l2, byte by, long[] lArray) {
        lArray[0] = l2 & 0x3FFFFFFL;
        lArray[1] = l2 >>> 26 & 0x3FFFFFFL;
        lArray[2] = (l2 >>> 52) + ((l & 0x3FFFL) << 12);
        lArray[3] = l >>> 14 & 0x3FFFFFFL;
        lArray[4] = (l >>> 40) + (long)(by << 24);
    }

    @Override
    protected void encode(byte[] byArray, int n, int n2, byte by, long[] lArray) {
        if (n2 == 16) {
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n, n2).order(ByteOrder.LITTLE_ENDIAN);
            long l = byteBuffer.getLong();
            long l2 = byteBuffer.getLong();
            this.encode(l2, l, by, lArray);
        } else {
            super.encode(byArray, n, n2, by, lArray);
        }
    }

    private void modReduceIn(long[] lArray, int n, long l) {
        long l2 = l * 5L;
        int n2 = n - 5;
        lArray[n2] = lArray[n2] + l2;
    }

    @Override
    protected void finalCarryReduceLast(long[] lArray) {
        long l = lArray[this.numLimbs - 1] >> this.bitsPerLimb;
        int n = this.numLimbs - 1;
        lArray[n] = lArray[n] - (l << this.bitsPerLimb);
        this.modReduceIn(lArray, this.numLimbs, l);
    }

    protected final void modReduce(long[] lArray, int n, int n2) {
        for (int i = n; i < n2; ++i) {
            this.modReduceIn(lArray, i, lArray[i]);
            lArray[i] = 0L;
        }
    }

    protected void modReduce(long[] lArray) {
        this.modReduce(lArray, 5, 4);
    }

    @Override
    protected long carryValue(long l) {
        return l >> 26;
    }

    @Override
    protected void postEncodeCarry(long[] lArray) {
    }

    @Override
    protected void reduce(long[] lArray) {
        long l = this.carryOut(lArray, 3);
        long l2 = l + lArray[4];
        long l3 = this.carryValue(l2);
        lArray[4] = l2 - (l3 << 26);
        this.modReduceIn(lArray, 5, l3);
        this.carry(lArray);
    }
}

