/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.digester3;

import java.util.Arrays;
import java.util.Formatter;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.digester3.Digester;
import org.apache.commons.digester3.Rule;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallMethodRule
extends Rule {
    protected String bodyText = null;
    protected int targetOffset = 0;
    protected String methodName = null;
    protected int paramCount = 0;
    protected Class<?>[] paramTypes = null;
    private String[] paramClassNames = null;
    private boolean useExactMatch = false;

    public CallMethodRule(String methodName, int paramCount) {
        this(0, methodName, paramCount);
    }

    public CallMethodRule(int targetOffset, String methodName, int paramCount) {
        this.targetOffset = targetOffset;
        this.methodName = methodName;
        this.paramCount = paramCount;
        if (paramCount == 0) {
            this.paramTypes = new Class[]{String.class};
        } else {
            this.paramTypes = new Class[paramCount];
            Arrays.fill(this.paramTypes, String.class);
        }
    }

    public CallMethodRule(String methodName) {
        this(0, methodName, 0, (Class[])null);
    }

    public CallMethodRule(int targetOffset, String methodName) {
        this(targetOffset, methodName, 0, (Class[])null);
    }

    public CallMethodRule(String methodName, int paramCount, String[] paramTypes) {
        this(0, methodName, paramCount, paramTypes);
    }

    public CallMethodRule(int targetOffset, String methodName, int paramCount, String[] paramTypes) {
        this.targetOffset = targetOffset;
        this.methodName = methodName;
        this.paramCount = paramCount;
        if (paramTypes == null) {
            this.paramTypes = new Class[paramCount];
            Arrays.fill(this.paramTypes, String.class);
        } else {
            this.paramClassNames = new String[paramTypes.length];
            System.arraycopy(paramTypes, 0, this.paramClassNames, 0, paramTypes.length);
        }
    }

    public CallMethodRule(String methodName, int paramCount, Class<?>[] paramTypes) {
        this(0, methodName, paramCount, paramTypes);
    }

    public CallMethodRule(int targetOffset, String methodName, int paramCount, Class<?>[] paramTypes) {
        this.targetOffset = targetOffset;
        this.methodName = methodName;
        this.paramCount = paramCount;
        if (paramTypes == null) {
            this.paramTypes = new Class[paramCount];
            Arrays.fill(this.paramTypes, String.class);
        } else {
            this.paramTypes = new Class[paramTypes.length];
            System.arraycopy(paramTypes, 0, this.paramTypes, 0, paramTypes.length);
        }
    }

    public boolean getUseExactMatch() {
        return this.useExactMatch;
    }

    public void setUseExactMatch(boolean useExactMatch) {
        this.useExactMatch = useExactMatch;
    }

    @Override
    public void setDigester(Digester digester) {
        super.setDigester(digester);
        if (this.paramClassNames != null) {
            this.paramTypes = new Class[this.paramClassNames.length];
            for (int i = 0; i < this.paramClassNames.length; ++i) {
                try {
                    this.paramTypes[i] = digester.getClassLoader().loadClass(this.paramClassNames[i]);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(String.format("[CallMethodRule] Cannot load class %s at position %s", this.paramClassNames[i], i), e);
                }
            }
        }
    }

    @Override
    public void begin(String namespace, String name, Attributes attributes) throws Exception {
        if (this.paramCount > 0) {
            Object[] parameters = new Object[this.paramCount];
            Arrays.fill(parameters, null);
            this.getDigester().pushParams(parameters);
        }
    }

    @Override
    public void body(String namespace, String name, String text) throws Exception {
        if (this.paramCount == 0) {
            this.bodyText = text.trim();
        }
    }

    @Override
    public void end(String namespace, String name) throws Exception {
        Object[] parameters;
        if (this.paramCount > 0) {
            parameters = this.getDigester().popParams();
            if (this.getDigester().getLogger().isTraceEnabled()) {
                int size = parameters.length;
                for (int i = 0; i < size; ++i) {
                    this.getDigester().getLogger().trace((Object)String.format("[CallMethodRule]{%s} parameters[%s]=%s", this.getDigester().getMatch(), i, parameters[i]));
                }
            }
            if (this.paramCount == 1 && parameters[0] == null) {
                return;
            }
        } else if (this.paramTypes != null && this.paramTypes.length != 0) {
            if (this.bodyText == null) {
                return;
            }
            parameters = new Object[]{this.bodyText};
            if (this.paramTypes.length == 0) {
                this.paramTypes = new Class[]{String.class};
            }
        } else {
            parameters = new Object[]{};
            this.paramTypes = new Class[0];
        }
        Object[] paramValues = new Object[this.paramTypes.length];
        for (int i = 0; i < this.paramTypes.length; ++i) {
            paramValues[i] = parameters[i] == null || parameters[i] instanceof String && !String.class.isAssignableFrom(this.paramTypes[i]) ? ConvertUtils.convert((String)((String)parameters[i]), this.paramTypes[i]) : parameters[i];
        }
        Object target = this.targetOffset >= 0 ? this.getDigester().peek(this.targetOffset) : this.getDigester().peek(this.getDigester().getCount() + this.targetOffset);
        if (target == null) {
            throw new SAXException(String.format("[CallMethodRule]{%s} Call target is null (targetOffset=%s, stackdepth=%s)", this.getDigester().getMatch(), this.targetOffset, this.getDigester().getCount()));
        }
        if (this.getDigester().getLogger().isDebugEnabled()) {
            Formatter formatter = new Formatter().format("[CallMethodRule]{%s} Call %s.%s(", this.getDigester().getMatch(), target.getClass().getName(), this.methodName);
            for (int i = 0; i < paramValues.length; ++i) {
                formatter.format("%s%s/%s", i > 0 ? ", " : "", paramValues[i], this.paramTypes[i].getName());
            }
            formatter.format(")", new Object[0]);
            this.getDigester().getLogger().debug((Object)formatter.toString());
        }
        Object result = null;
        result = this.useExactMatch ? MethodUtils.invokeExactMethod(target, (String)this.methodName, (Object[])paramValues, (Class[])this.paramTypes) : MethodUtils.invokeMethod(target, (String)this.methodName, (Object[])paramValues, (Class[])this.paramTypes);
        this.processMethodCallResult(result);
    }

    @Override
    public void finish() throws Exception {
        this.bodyText = null;
    }

    protected void processMethodCallResult(Object result) {
    }

    public String toString() {
        Formatter formatter = new Formatter().format("CallMethodRule[methodName=%s, paramCount=%s, paramTypes={", this.methodName, this.paramCount);
        if (this.paramTypes != null) {
            for (int i = 0; i < this.paramTypes.length; ++i) {
                formatter.format("%s%s", i > 0 ? ", " : "", this.paramTypes[i] != null ? this.paramTypes[i].getName() : "null");
            }
        }
        formatter.format("}]", new Object[0]);
        return formatter.toString();
    }
}

