/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.jexl3.internal.Frame;
import org.apache.commons.jexl3.internal.LexicalScope;
import org.apache.commons.jexl3.internal.ReferenceFrame;

public final class Scope {
    static final Object UNDECLARED = new Object(){

        public String toString() {
            return "??";
        }
    };
    static final Object UNDEFINED = new Object(){

        public String toString() {
            return "?";
        }
    };
    private static final String[] EMPTY_STRS = new String[0];
    private final Scope parent;
    private int parms;
    private int vars;
    private Map<String, Integer> namedVariables;
    private Map<Integer, Integer> capturedVariables;
    private LexicalScope lexicalVariables;

    public Scope(Scope scope, String ... parameters) {
        if (parameters != null) {
            this.parms = parameters.length;
            this.namedVariables = new LinkedHashMap<String, Integer>();
            for (int p = 0; p < this.parms; ++p) {
                this.namedVariables.put(parameters[p], p);
            }
        } else {
            this.parms = 0;
        }
        this.vars = 0;
        this.parent = scope;
    }

    public boolean addLexical(int s) {
        if (this.lexicalVariables == null) {
            this.lexicalVariables = new LexicalScope();
        }
        return this.lexicalVariables.addSymbol(s);
    }

    public Frame createFrame(boolean ref, Frame frame, Object ... args) {
        Frame newFrame;
        if (this.namedVariables == null) {
            return null;
        }
        Object[] arguments = new Object[this.namedVariables.size()];
        Arrays.fill(arguments, UNDECLARED);
        if (frame != null && this.capturedVariables != null && this.parent != null) {
            for (Map.Entry<Integer, Integer> capture : this.capturedVariables.entrySet()) {
                Object arg;
                Integer target = capture.getKey();
                Integer source = capture.getValue();
                arguments[target.intValue()] = arg = frame.capture(source);
            }
            newFrame = frame.newFrame(this, arguments, 0);
        } else {
            newFrame = ref ? new ReferenceFrame(this, arguments, 0) : new Frame(this, arguments, 0);
        }
        return newFrame.assign(args);
    }

    public int declareParameter(String param) {
        if (this.namedVariables == null) {
            this.namedVariables = new LinkedHashMap<String, Integer>();
        } else if (this.vars > 0) {
            throw new IllegalStateException("cant declare parameters after variables");
        }
        return this.namedVariables.computeIfAbsent(param, name -> {
            int register = this.namedVariables.size();
            ++this.parms;
            return register;
        });
    }

    public int declareVariable(String varName) {
        if (this.namedVariables == null) {
            this.namedVariables = new LinkedHashMap<String, Integer>();
        }
        return this.namedVariables.computeIfAbsent(varName, name -> {
            Integer pr;
            int register = this.namedVariables.size();
            ++this.vars;
            if (this.parent != null && (pr = this.parent.getSymbol((String)name, true)) != null) {
                if (this.capturedVariables == null) {
                    this.capturedVariables = new LinkedHashMap<Integer, Integer>();
                }
                this.capturedVariables.put(register, pr);
            }
            return register;
        });
    }

    public int getArgCount() {
        return this.parms;
    }

    public Integer getCaptured(int symbol) {
        if (this.capturedVariables != null) {
            for (Map.Entry<Integer, Integer> capture : this.capturedVariables.entrySet()) {
                Integer source = capture.getValue();
                if (source != symbol) continue;
                return capture.getKey();
            }
        }
        return null;
    }

    public int getCaptureDeclaration(int symbol) {
        Integer declared = this.capturedVariables != null ? this.capturedVariables.get(symbol) : null;
        return declared != null ? declared : -1;
    }

    public String[] getCapturedVariables() {
        if (this.capturedVariables != null) {
            ArrayList<String> captured = new ArrayList<String>(this.vars);
            for (Map.Entry<String, Integer> entry : this.namedVariables.entrySet()) {
                int symnum = entry.getValue();
                if (symnum < this.parms || !this.capturedVariables.containsKey(symnum)) continue;
                captured.add(entry.getKey());
            }
            if (!captured.isEmpty()) {
                return captured.toArray(new String[0]);
            }
        }
        return EMPTY_STRS;
    }

    public String[] getLocalVariables() {
        if (this.namedVariables == null || this.vars <= 0) {
            return EMPTY_STRS;
        }
        ArrayList<String> locals = new ArrayList<String>(this.vars);
        for (Map.Entry<String, Integer> entry : this.namedVariables.entrySet()) {
            int symnum = entry.getValue();
            if (symnum < this.parms || this.capturedVariables != null && this.capturedVariables.containsKey(symnum)) continue;
            locals.add(entry.getKey());
        }
        return locals.toArray(new String[0]);
    }

    public String[] getParameters() {
        return this.getParameters(0);
    }

    String[] getParameters(int bound) {
        int unbound = this.parms - bound;
        if (this.namedVariables == null || unbound <= 0) {
            return EMPTY_STRS;
        }
        String[] pa = new String[unbound];
        int p = 0;
        for (Map.Entry<String, Integer> entry : this.namedVariables.entrySet()) {
            int argn = entry.getValue();
            if (argn < bound || argn >= this.parms) continue;
            pa[p++] = entry.getKey();
        }
        return pa;
    }

    Scope getParent() {
        return this.parent;
    }

    public Integer getSymbol(String name) {
        return this.getSymbol(name, true);
    }

    private Integer getSymbol(String name, boolean capture) {
        Integer pr;
        Integer register;
        Integer n = register = this.namedVariables != null ? this.namedVariables.get(name) : null;
        if (register == null && capture && this.parent != null && (pr = this.parent.getSymbol(name, true)) != null) {
            if (this.capturedVariables == null) {
                this.capturedVariables = new LinkedHashMap<Integer, Integer>();
            }
            if (this.namedVariables == null) {
                this.namedVariables = new LinkedHashMap<String, Integer>();
            }
            register = this.namedVariables.size();
            this.namedVariables.put(name, register);
            this.capturedVariables.put(register, pr);
        }
        return register;
    }

    public String[] getSymbols() {
        return this.namedVariables != null ? this.namedVariables.keySet().toArray(new String[0]) : EMPTY_STRS;
    }

    public boolean isCapturedSymbol(int symbol) {
        return this.capturedVariables != null && this.capturedVariables.containsKey(symbol);
    }

    public boolean isLexical(int s) {
        return this.lexicalVariables != null && s >= 0 && this.lexicalVariables.hasSymbol(s);
    }
}

