/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dsl.dependencies;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencyConstraint;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.FileCollectionDependency;
import org.gradle.api.artifacts.MinimalExternalModuleDependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.dsl.DependencyCollector;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.artifacts.dependencies.AbstractModuleDependency;
import org.gradle.api.internal.artifacts.dependencies.DependencyConstraintInternal;
import org.gradle.api.internal.artifacts.dsl.dependencies.DependencyFactoryInternal;
import org.gradle.api.internal.provider.DefaultSetProperty;
import org.gradle.api.internal.provider.PropertyInternal;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderConvertible;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.Nested;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;

public abstract class DefaultDependencyCollector
implements DependencyCollector {
    private final DependencyFactoryInternal dependencyFactory;

    @Inject
    public DefaultDependencyCollector(DependencyFactoryInternal dependencyFactory) {
        this.dependencyFactory = dependencyFactory;
        this.getDependencies().finalizeValueOnRead();
        this.getDependencyConstraints().finalizeValueOnRead();
    }

    @Nested
    public abstract SetProperty<Dependency> getDependencies();

    @Nested
    public abstract SetProperty<DependencyConstraint> getDependencyConstraints();

    private <D extends Dependency> D ensureMutable(D dependency) {
        return (D)this.dependencyFactory.createDependency(dependency);
    }

    private <D extends Dependency> D applyConfiguration(D dependency, @Nullable Action<? super D> config) {
        D mutable = this.ensureMutable(dependency);
        if (config != null) {
            config.execute(mutable);
        }
        if (mutable instanceof AbstractModuleDependency) {
            ((AbstractModuleDependency)mutable).addMutationValidator((Action<? super ModuleDependency>)((Action)dep -> {
                if (((PropertyInternal)this.getDependencies()).isFinalized()) {
                    ((DeprecationMessageBuilder.WithDocumentation)DeprecationLogger.deprecateAction((String)("Mutating dependency " + dep + " after it has been finalized")).willBecomeAnErrorInGradle9().withUpgradeGuideSection(8, "dependency_mutate_dependency_collector_after_finalize")).nagUser();
                }
            }));
        }
        return mutable;
    }

    private <D extends Dependency> void doAddEager(D dependency, @Nullable Action<? super D> config) {
        this.getDependencies().add(this.applyConfiguration(dependency, config));
    }

    private <D extends Dependency> void doAddLazy(Provider<D> dependency, @Nullable Action<? super D> config) {
        Provider provider = dependency.map(dep -> this.applyConfiguration((Dependency)dep, config));
        DefaultSetProperty.addOptionalProvider(this.getDependencies(), (Provider)provider);
    }

    private <D extends Dependency> List<Dependency> createDependencyList(Iterable<? extends D> bundle, @Nullable Action<? super D> config) {
        ArrayList<Dependency> newList = new ArrayList<Dependency>(bundle instanceof Collection ? ((Collection)bundle).size() : 0);
        for (Dependency dep : bundle) {
            newList.add((Dependency)this.applyConfiguration(dep, config));
        }
        return newList;
    }

    private <D extends Dependency> void doAddBundleEager(Iterable<? extends D> bundle, @Nullable Action<? super D> config) {
        List<Dependency> dependencies = this.createDependencyList(bundle, config);
        this.getDependencies().addAll(dependencies);
    }

    private <D extends Dependency> void doAddBundleLazy(Provider<? extends Iterable<? extends D>> dependency, @Nullable Action<? super D> config) {
        Provider provider = dependency.map(bundle -> this.createDependencyList((Iterable)bundle, config));
        this.getDependencies().addAll(provider);
    }

    public void add(CharSequence dependencyNotation) {
        this.doAddEager((Dependency)this.dependencyFactory.create(dependencyNotation), null);
    }

    public void add(CharSequence dependencyNotation, Action<? super ExternalModuleDependency> configuration) {
        this.doAddEager((Dependency)this.dependencyFactory.create(dependencyNotation), (Action)configuration);
    }

    public void add(FileCollection files) {
        this.doAddEager((Dependency)this.dependencyFactory.create(files), null);
    }

    public void add(FileCollection files, Action<? super FileCollectionDependency> configuration) {
        this.doAddEager((Dependency)this.dependencyFactory.create(files), (Action)configuration);
    }

    public void add(ProviderConvertible<? extends MinimalExternalModuleDependency> externalModule) {
        this.doAddLazy(externalModule.asProvider(), null);
    }

    public void add(ProviderConvertible<? extends MinimalExternalModuleDependency> externalModule, Action<? super ExternalModuleDependency> configuration) {
        this.doAddLazy(externalModule.asProvider(), configuration);
    }

    public void add(Dependency dependency) {
        this.doAddEager(dependency, null);
    }

    public <D extends Dependency> void add(D dependency, Action<? super D> configuration) {
        this.doAddEager(dependency, configuration);
    }

    public void add(Provider<? extends Dependency> dependency) {
        this.doAddLazy(dependency, null);
    }

    public <D extends Dependency> void add(Provider<? extends D> dependency, Action<? super D> configuration) {
        this.doAddLazy(dependency, configuration);
    }

    private DependencyConstraint applyConstraintConfiguration(DependencyConstraint dependencyConstraint, @Nullable Action<? super DependencyConstraint> config) {
        if (config != null) {
            config.execute((Object)dependencyConstraint);
        }
        ((DependencyConstraintInternal)dependencyConstraint).addMutationValidator((Action<? super DependencyConstraint>)((Action)constraint -> {
            if (((PropertyInternal)this.getDependencyConstraints()).isFinalized()) {
                throw new InvalidUserCodeException("Cannot mutate dependency constraint " + constraint + " after it has been finalized");
            }
        }));
        return dependencyConstraint;
    }

    private void doAddConstraintEager(DependencyConstraint dependencyConstraint, @Nullable Action<? super DependencyConstraint> config) {
        this.getDependencyConstraints().add((Object)this.applyConstraintConfiguration(dependencyConstraint, config));
    }

    private void doAddConstraintLazy(Provider<? extends DependencyConstraint> dependencyConstraint, @Nullable Action<? super DependencyConstraint> config) {
        Provider provider = dependencyConstraint.map(dep -> this.applyConstraintConfiguration((DependencyConstraint)dep, config));
        DefaultSetProperty.addOptionalProvider(this.getDependencyConstraints(), (Provider)provider);
    }

    public void addConstraint(DependencyConstraint dependencyConstraint) {
        this.doAddConstraintEager(dependencyConstraint, null);
    }

    public void addConstraint(DependencyConstraint dependencyConstraint, Action<? super DependencyConstraint> configuration) {
        this.doAddConstraintEager(dependencyConstraint, configuration);
    }

    public void addConstraint(Provider<? extends DependencyConstraint> dependencyConstraint) {
        this.doAddConstraintLazy(dependencyConstraint, null);
    }

    public void addConstraint(Provider<? extends DependencyConstraint> dependencyConstraint, Action<? super DependencyConstraint> configuration) {
        this.doAddConstraintLazy(dependencyConstraint, configuration);
    }

    public <D extends Dependency> void bundle(Iterable<? extends D> bundle) {
        this.doAddBundleEager(bundle, null);
    }

    public <D extends Dependency> void bundle(Iterable<? extends D> bundle, Action<? super D> configuration) {
        this.doAddBundleEager(bundle, configuration);
    }

    public <D extends Dependency> void bundle(Provider<? extends Iterable<? extends D>> bundle) {
        this.doAddBundleLazy(bundle, null);
    }

    public <D extends Dependency> void bundle(Provider<? extends Iterable<? extends D>> bundle, Action<? super D> configuration) {
        this.doAddBundleLazy(bundle, configuration);
    }

    public <D extends Dependency> void bundle(ProviderConvertible<? extends Iterable<? extends D>> bundle) {
        this.doAddBundleLazy(bundle.asProvider(), null);
    }

    public <D extends Dependency> void bundle(ProviderConvertible<? extends Iterable<? extends D>> bundle, Action<? super D> configuration) {
        this.doAddBundleLazy(bundle.asProvider(), configuration);
    }
}

