/*
 * Decompiled with CFR 0.152.
 */
package org.tanukisoftware.wrapper;

import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import org.tanukisoftware.wrapper.WrapperManager;
import org.tanukisoftware.wrapper.WrapperPrintStream;
import org.tanukisoftware.wrapper.WrapperSystemPropertyUtil;

public final class WrapperResources {
    private static WrapperPrintStream m_outError;
    private static boolean m_validateResourceKeys;
    private static final Object[] EMPTY_OBJECT_ARRAY;
    private long m_Id;

    protected WrapperResources() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (WrapperManager.isLoggingFinalizers()) {
                System.out.println("WrapperResources.finalize Id=" + this.m_Id);
            }
            if (this.m_Id != 0L && WrapperManager.isNativeLibraryOk()) {
                this.nativeDestroyResource();
            }
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            super.finalize();
            throw throwable;
        }
        super.finalize();
    }

    private native String nativeGetLocalizedString(String var1);

    private native void nativeDestroyResource();

    private void validateResourceKey(String str, boolean localized) {
        int pos = 0;
        int len = str.length();
        while ((pos = str.indexOf(39, pos)) >= 0) {
            if (++pos >= len || str.charAt(pos) != '\'') {
                if (localized) {
                    m_outError.println(WrapperManager.getRes().getString("Localized resource string''s single quotes not escaped correctly: {0}", str));
                    break;
                }
                m_outError.println(WrapperManager.getRes().getString("Resource key''s single quotes not escaped correctly: {0}", str));
                break;
            }
            if (++pos < len) continue;
        }
    }

    private String getStringInner(String key) {
        if (m_validateResourceKeys) {
            this.validateResourceKey(key, false);
        }
        if (this.m_Id != 0L && WrapperManager.isNativeLibraryOk()) {
            String str = this.nativeGetLocalizedString(key);
            if (!str.equals(key) && m_validateResourceKeys) {
                this.validateResourceKey(str, true);
            }
            return str;
        }
        return key;
    }

    public String getString(String key) {
        return MessageFormat.format(this.getStringInner(key), EMPTY_OBJECT_ARRAY);
    }

    public String getString(String key, Object[] arguments) {
        return MessageFormat.format(this.getStringInner(key), arguments);
    }

    public String getString(String key, Object arg0) {
        return MessageFormat.format(this.getStringInner(key), arg0);
    }

    public String getString(String key, Object arg0, Object arg1) {
        return MessageFormat.format(this.getStringInner(key), arg0, arg1);
    }

    public String getString(String key, Object arg0, Object arg1, Object arg2) {
        return MessageFormat.format(this.getStringInner(key), arg0, arg1, arg2);
    }

    public String getString(String key, Object arg0, Object arg1, Object arg2, Object arg3) {
        return MessageFormat.format(this.getStringInner(key), arg0, arg1, arg2, arg3);
    }

    public String getString(String key, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4) {
        return MessageFormat.format(this.getStringInner(key), arg0, arg1, arg2, arg3, arg4);
    }

    static {
        String sunStdoutEncoding;
        EMPTY_OBJECT_ARRAY = new Object[0];
        boolean streamSet = false;
        if ("true".equals(System.getProperty("wrapper.use_sun_encoding")) && (sunStdoutEncoding = System.getProperty("sun.stdout.encoding")) != null && !sunStdoutEncoding.equals(System.getProperty("file.encoding"))) {
            try {
                m_outError = new WrapperPrintStream(System.out, false, sunStdoutEncoding, "WrapperResources Error: ");
                streamSet = true;
            }
            catch (UnsupportedEncodingException e) {
                System.out.println(WrapperManager.getRes().getString("Failed to set the encoding ''{0}'' when creating a WrapperPrintStream.\n Make sure the value of sun.stdout.encoding is correct.", sunStdoutEncoding));
            }
        }
        if (!streamSet) {
            m_outError = new WrapperPrintStream(System.out, "WrapperResources Error: ");
        }
        m_validateResourceKeys = WrapperSystemPropertyUtil.getBooleanProperty(WrapperResources.class.getName() + ".validateResourceKeys", false);
    }
}

