/*
 * Decompiled with CFR 0.152.
 */
package tr.view.project;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import net.miginfocom.swing.MigLayout;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;
import tr.model.Data;
import tr.model.DataLookup;
import tr.model.criteria.Value;
import tr.model.project.Project;
import tr.model.project.Sequencing;
import tr.model.topic.Topic;
import tr.prefs.projects.ProjectsPrefs;
import tr.runtime.Open;
import tr.swing.TRComboBox;
import tr.swing.TRLabel;
import tr.swing.TRTextField;
import tr.swing.date.field.DateField;
import tr.swing.document.LazyDocumentListener;
import tr.swing.editorpane.HyperEditorPane;
import tr.swing.mig.MTextArea;
import tr.util.Observable;
import tr.util.Observer;
import tr.util.Utils;
import tr.view.ViewUtils;
import tr.view.criteria.PriorityComboBoxModel;
import tr.view.project.SequencingModel;
import tr.view.topics.TopicsComboBox;
import tr.view.topics.TopicsComboBoxModel;

public final class ProjectPanel
extends JPanel {
    private final PropertyChangeListener descrListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (ProjectPanel.this.descriptionText.hasFocus()) {
                return;
            }
            if (!ProjectPanel.this.descriptionText.getText().equals(ProjectPanel.this.project.getDescription())) {
                ProjectPanel.this.descriptionText.setText(ProjectPanel.this.project.getDescription());
            }
        }
    };
    private final PropertyChangeListener topicListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (ProjectPanel.this.topicCombo.hasFocus()) {
                return;
            }
            if (!Utils.equal((Object)ProjectPanel.this.project.getTopic(), (Object)ProjectPanel.this.topicCombo.getSelectedItem())) {
                ProjectPanel.this.topicCombo.setSelectedItem((Object)ProjectPanel.this.project.getTopic());
            }
        }
    };
    private final PropertyChangeListener doneListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (ProjectPanel.this.doneCheckBox.isSelected() != ProjectPanel.this.project.isDone()) {
                ProjectPanel.this.doneCheckBox.setSelected(ProjectPanel.this.project.isDone());
                ProjectPanel.this.doneDateField.setDate(ProjectPanel.this.project.getDoneDate());
                ProjectPanel.this.doneDateField.setEnabled(ProjectPanel.this.project.canSetDone(true));
            }
        }
    };
    private MigLayout layoutA1 = new MigLayout(this.getMIGCons(), "2[]4[grow]4[]4[]4[]4[]2", "2[]2[]2[]2[]2[]2[]2[]2[]2[]2[]2[grow]2[]2[]2");
    private MigLayout layoutA2 = new MigLayout(this.getMIGCons(), "2[]4[grow]4[]4[]4[]4[]2", "2[]2[]2[]2[]2[]2[]2[]2[]2[grow]2[]2[]2");
    private MigLayout layoutM1 = new MigLayout(this.getMIGCons(), "2[]4[grow]4[]4[]4[]4[]2", "2[top]2[top]2[center]2[top]2[center]2[top]2[top]2[top]2[top]2[center]2[grow]2[center]2[top]2");
    private MigLayout layoutM2 = new MigLayout(this.getMIGCons(), "2[]4[grow]4[]4[]4[]4[]2", "2[top]2[top]2[center]2[top]2[top]2[top]2[top]2[center]2[grow]2[center]2[top]2");
    private static final boolean DEBUG_MIG_LAYOUT = false;
    private static final String DEFAULT_DESCRIPTION = NbBundle.getMessage(ProjectPanel.class, (String)"new.project");
    private TRLabel descriptionLabel;
    private TRTextField descriptionText;
    private TRLabel topicLabel;
    private TRComboBox topicCombo;
    private TRLabel priorityLabel;
    private TRComboBox priorityCombo;
    private JCheckBox sequencingCheckBox;
    private TRComboBox sequencingCombo;
    private TRLabel dueDateLabel;
    private DateField dueDateField;
    private TRLabel startDateLabel;
    private DateField startDateField;
    private TRLabel purposeLabel;
    private MTextArea purposeTextArea;
    private TRLabel visionLabel;
    private MTextArea visionTextArea;
    private TRLabel brainstormLabel;
    private MTextArea brainstormTextArea;
    private TRLabel organiseLabel;
    private MTextArea organiseTextArea;
    private TRLabel notesLabel;
    private HyperEditorPane notesEditorPane;
    private JCheckBox doneCheckBox;
    private DateField doneDateField;
    private TRLabel createdDateLabel;
    private DateField createdDateField;
    private Lookup.Result result;
    private Project project;
    private ComboBoxModel topicsModel;
    private boolean updating;
    private DocumentListener docListenerDescription;
    private DocumentListener docListenerPurpose;
    private DocumentListener docListenerVision;
    private DocumentListener docListenerBrainstorm;
    private DocumentListener docListenerOrganise;
    private DocumentListener docListenerNotes;
    private FocusAdapter focusAdapterDescription;
    private ActionListener actionListenerTopic;
    private ActionListener actionListenerPriorityCombo;
    private ActionListener actionListenerSequencingCombo;
    private ActionListener actionListenerSequencingCheckBox;
    private ActionListener actionListenerCompletedCheckBox;
    private PropertyChangeListener createdDatePropertyChangeListener;
    private PropertyChangeListener startDatePropertyChangeListener;
    private PropertyChangeListener dueDatePropertyChangeListener;
    private PropertyChangeListener completedDatePropertyChangeListener;
    private HyperlinkListener hyperlinkListener;
    private Observer observerCriterion;
    private PreferenceChangeListener prefsChangeListener;

    public ProjectPanel() {
        this.initComponents();
        this.initPanel();
        this.initModel(null);
        this.result = DataLookup.instance().lookup(new Lookup.Template(Data.class));
        this.result.addLookupListener(new LookupListener(){

            public void resultChanged(LookupEvent lookupEvent) {
                ProjectPanel.this.dataChanged();
            }
        });
        this.dataChanged();
    }

    private void dataChanged() {
        Data data = this.getData();
        if (data == null) {
            return;
        }
        if (this.observerCriterion == null) {
            this.observerCriterion = new Observer(){

                public void update(Observable observable, Object arguement) {
                    ProjectPanel.this.showHideCriteria();
                }
            };
        }
        this.getData().getPriorityCriterion().addObserver(this.observerCriterion);
    }

    private Data getData() {
        return (Data)DataLookup.instance().lookup(Data.class);
    }

    public void addNotify() {
        super.addNotify();
        this.addListeners();
    }

    public void removeNotify() {
        this.removeListeners();
        super.removeNotify();
    }

    public void edit() {
        this.descriptionText.requestFocusInWindow();
    }

    private ComboBoxModel getPriorityComboBoxModel() {
        return new PriorityComboBoxModel();
    }

    private void descriptionTextFocusGained(FocusEvent evt) {
        if (this.descriptionText.getText().equals(DEFAULT_DESCRIPTION)) {
            this.descriptionText.setSelectionStart(0);
            this.descriptionText.setSelectionEnd(DEFAULT_DESCRIPTION.length());
        }
    }

    private void topicComboActionPerformed(ActionEvent evt) {
        if (this.updating || this.project == null) {
            return;
        }
        TRComboBox combo = (TRComboBox)evt.getSource();
        this.project.setTopic((Topic)combo.getSelectedItem());
    }

    private void priorityComboActionPerformed(ActionEvent evt) {
        if (this.updating || this.project == null) {
            return;
        }
        this.project.setPriority((Value)this.priorityCombo.getSelectedItem());
    }

    private void sequencingComboActionPerformed(ActionEvent evt) {
        if (this.updating || this.project == null) {
            return;
        }
        this.project.setSequenceType((Sequencing)this.sequencingCombo.getSelectedItem());
    }

    private void sequencingCheckBoxActionPerformed(ActionEvent evt) {
        if (this.updating || this.project == null) {
            return;
        }
        this.project.setSequencing(this.sequencingCheckBox.isSelected());
        this.sequencingCombo.setEnabled(this.sequencingCheckBox.isSelected());
    }

    private void completedCheckBoxActionPerformed(ActionEvent evt) {
        if (this.updating || this.project == null) {
            return;
        }
        if (this.doneCheckBox.isSelected() && !this.project.canSetDone(true)) {
            this.doneCheckBox.setSelected(false);
            String t = "";
            String m = NbBundle.getMessage(ProjectPanel.class, (String)"message.can.not.set.done");
            Frame p = WindowManager.getDefault().getMainWindow();
            JOptionPane.showMessageDialog(p, m, t, 2);
        } else {
            this.project.setDone(this.doneCheckBox.isSelected());
            this.doneDateField.setDate(this.project.getDoneDate());
        }
        this.doneDateField.setEnabled(this.project.isDone());
    }

    private void changedCreatedDate() {
        if (this.updating || this.project == null) {
            return;
        }
        this.project.setCreated(this.createdDateField.getDate());
    }

    private void changedStartDate() {
        if (this.updating || this.project == null) {
            return;
        }
        this.project.setStartDate(this.startDateField.getDate());
    }

    private void changedDueDate() {
        if (this.updating || this.project == null) {
            return;
        }
        this.project.setDueDate(this.dueDateField.getDate());
    }

    private void changedCompletedDate() {
        if (this.updating || this.project == null) {
            return;
        }
        this.project.setDoneDate(this.doneDateField.getDate());
    }

    private void notesEditorPaneHyperlinkAction(HyperlinkEvent evt) {
        URL url = evt.getURL();
        if (url == null) {
            return;
        }
        if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            Open.open((URL)url);
        }
    }

    private void addListeners() {
        this.prefsChangeListener = new PreferenceChangeListener(){

            public void preferenceChange(PreferenceChangeEvent arg0) {
                ProjectPanel.this.changedPrefs();
            }
        };
        ProjectsPrefs.prefs.addPreferenceChangeListener(this.prefsChangeListener);
        this.docListenerDescription = new LazyDocumentListener(){

            public void update() {
                ProjectPanel.this.changedDescription();
            }
        };
        this.descriptionText.getDocument().addDocumentListener(this.docListenerDescription);
        this.actionListenerPriorityCombo = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProjectPanel.this.priorityComboActionPerformed(evt);
            }
        };
        this.priorityCombo.addActionListener(this.actionListenerPriorityCombo);
        this.docListenerPurpose = new LazyDocumentListener(){

            public void update() {
                ProjectPanel.this.changedPurpose();
            }
        };
        this.purposeTextArea.getDocument().addDocumentListener(this.docListenerPurpose);
        this.docListenerBrainstorm = new LazyDocumentListener(){

            public void update() {
                ProjectPanel.this.changedBrainstorm();
            }
        };
        this.brainstormTextArea.getDocument().addDocumentListener(this.docListenerBrainstorm);
        this.docListenerOrganise = new LazyDocumentListener(){

            public void update() {
                ProjectPanel.this.changedOrganise();
            }
        };
        this.organiseTextArea.getDocument().addDocumentListener(this.docListenerOrganise);
        this.docListenerVision = new LazyDocumentListener(){

            public void update() {
                ProjectPanel.this.changedVision();
            }
        };
        this.visionTextArea.getDocument().addDocumentListener(this.docListenerVision);
        this.docListenerNotes = new LazyDocumentListener(){

            public void update() {
                ProjectPanel.this.changedNotes();
            }
        };
        this.notesEditorPane.addDocumentListener(this.docListenerNotes);
        this.focusAdapterDescription = new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                ProjectPanel.this.descriptionTextFocusGained(evt);
            }
        };
        this.descriptionText.addFocusListener((FocusListener)this.focusAdapterDescription);
        this.actionListenerTopic = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProjectPanel.this.topicComboActionPerformed(evt);
            }
        };
        this.topicCombo.addActionListener(this.actionListenerTopic);
        this.actionListenerSequencingCombo = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProjectPanel.this.sequencingComboActionPerformed(evt);
            }
        };
        this.sequencingCombo.addActionListener(this.actionListenerSequencingCombo);
        this.actionListenerSequencingCheckBox = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProjectPanel.this.sequencingCheckBoxActionPerformed(evt);
            }
        };
        this.sequencingCheckBox.addActionListener(this.actionListenerSequencingCheckBox);
        this.createdDatePropertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                ProjectPanel.this.changedCreatedDate();
            }
        };
        this.createdDateField.addPropertyChangeListener("value", this.createdDatePropertyChangeListener);
        this.startDatePropertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                ProjectPanel.this.changedStartDate();
            }
        };
        this.startDateField.addPropertyChangeListener("value", this.startDatePropertyChangeListener);
        this.dueDatePropertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                ProjectPanel.this.changedDueDate();
            }
        };
        this.dueDateField.addPropertyChangeListener("value", this.dueDatePropertyChangeListener);
        this.actionListenerCompletedCheckBox = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProjectPanel.this.completedCheckBoxActionPerformed(evt);
            }
        };
        this.doneCheckBox.addActionListener(this.actionListenerCompletedCheckBox);
        this.completedDatePropertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                ProjectPanel.this.changedCompletedDate();
            }
        };
        this.doneDateField.addPropertyChangeListener("value", this.completedDatePropertyChangeListener);
        this.hyperlinkListener = new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent evt) {
                ProjectPanel.this.notesEditorPaneHyperlinkAction(evt);
            }
        };
        this.notesEditorPane.addHyperlinkListener(this.hyperlinkListener);
    }

    private void removeListeners() {
        ProjectsPrefs.prefs.removePreferenceChangeListener(this.prefsChangeListener);
        this.prefsChangeListener = null;
        this.descriptionText.getDocument().removeDocumentListener(this.docListenerDescription);
        this.purposeTextArea.getDocument().removeDocumentListener(this.docListenerPurpose);
        this.brainstormTextArea.getDocument().removeDocumentListener(this.docListenerBrainstorm);
        this.organiseTextArea.getDocument().removeDocumentListener(this.docListenerOrganise);
        this.visionTextArea.getDocument().removeDocumentListener(this.docListenerVision);
        this.notesEditorPane.removeDocumentListener(this.docListenerNotes);
        this.descriptionText.removeFocusListener((FocusListener)this.focusAdapterDescription);
        this.topicCombo.removeActionListener(this.actionListenerTopic);
        this.sequencingCombo.removeActionListener(this.actionListenerSequencingCombo);
        this.sequencingCheckBox.removeActionListener(this.actionListenerSequencingCheckBox);
        this.createdDateField.removePropertyChangeListener(this.createdDatePropertyChangeListener);
        this.createdDatePropertyChangeListener = null;
        this.startDateField.removePropertyChangeListener(this.startDatePropertyChangeListener);
        this.startDatePropertyChangeListener = null;
        this.dueDateField.removePropertyChangeListener(this.dueDatePropertyChangeListener);
        this.dueDatePropertyChangeListener = null;
        this.doneCheckBox.removeActionListener(this.actionListenerCompletedCheckBox);
        this.actionListenerSequencingCheckBox = null;
        this.doneDateField.removePropertyChangeListener(this.completedDatePropertyChangeListener);
        this.completedDatePropertyChangeListener = null;
        this.notesEditorPane.removeHyperlinkListener(this.hyperlinkListener);
        this.priorityCombo.removeActionListener(this.actionListenerPriorityCombo);
        this.docListenerDescription = null;
        this.docListenerPurpose = null;
        this.docListenerVision = null;
        this.docListenerBrainstorm = null;
        this.docListenerOrganise = null;
        this.docListenerNotes = null;
        this.focusAdapterDescription = null;
        this.actionListenerTopic = null;
        this.actionListenerSequencingCombo = null;
        this.actionListenerCompletedCheckBox = null;
        this.hyperlinkListener = null;
        this.actionListenerPriorityCombo = null;
    }

    public Project getModel() {
        return this.project;
    }

    public void initModel(Project project) {
        if (Utils.equal((Object)this.project, (Object)project)) {
            return;
        }
        if (this.project != null) {
            this.project.removePropertyChangeListenter("Done", this.doneListener);
            this.project.removePropertyChangeListenter("Descr", this.descrListener);
            this.project.removePropertyChangeListenter("Topic", this.topicListener);
        }
        this.project = project;
        if (this.project != null) {
            this.project.addPropertyChangeListenter("Done", this.doneListener);
            this.project.addPropertyChangeListenter("Descr", this.descrListener);
            this.project.addPropertyChangeListenter("Topic", this.topicListener);
        }
        this.initView();
    }

    private void initView() {
        this.updating = true;
        if (this.project == null) {
            this.descriptionText.setText("");
            this.topicCombo.setSelectedItem(null);
            this.priorityCombo.setSelectedItem(null);
            this.purposeTextArea.setText("");
            this.visionTextArea.setText("");
            this.brainstormTextArea.setText("");
            this.organiseTextArea.setText("");
            this.notesEditorPane.setText("");
            this.sequencingCheckBox.setSelected(false);
            this.sequencingCombo.setSelectedItem(null);
            this.startDateField.setDate(null);
            this.dueDateField.setDate(null);
            this.createdDateField.setDate(null);
            this.doneCheckBox.setSelected(false);
            this.doneDateField.setDate(null);
            this.setEnabled(false);
        } else {
            this.descriptionText.setText(this.project.getDescription());
            this.topicCombo.setSelectedItem((Object)this.project.getTopic());
            this.priorityCombo.setSelectedItem((Object)this.project.getPriority());
            this.purposeTextArea.setText(this.project.getPurpose());
            this.visionTextArea.setText(this.project.getVision());
            this.brainstormTextArea.setText(this.project.getBrainstorming());
            this.organiseTextArea.setText(this.project.getOrganising());
            this.notesEditorPane.setText(this.project.getNotes());
            boolean sequence = ProjectsPrefs.isSequencing();
            this.sequencingCheckBox.setVisible(sequence);
            this.sequencingCombo.setVisible(sequence);
            this.sequencingCheckBox.setSelected(this.project.isSequencing());
            this.sequencingCombo.setSelectedItem((Object)this.project.getSequenceType());
            this.startDateField.setDate(this.project.getStartDate());
            this.dueDateField.setDate(this.project.getDueDate());
            this.createdDateField.setDate(this.project.getCreated());
            this.doneCheckBox.setSelected(this.project.isDone());
            this.doneDateField.setDate(this.project.getDoneDate());
            this.setEnabled(true);
        }
        this.updating = false;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.descriptionLabel.setEnabled(enabled);
        this.descriptionText.setEnabled(enabled);
        this.topicLabel.setEnabled(enabled);
        this.topicCombo.setEnabled(enabled);
        this.purposeLabel.setEnabled(enabled);
        this.purposeTextArea.setEnabled(enabled);
        this.visionLabel.setEnabled(enabled);
        this.visionTextArea.setEnabled(enabled);
        this.brainstormLabel.setEnabled(enabled);
        this.brainstormTextArea.setEnabled(enabled);
        this.organiseLabel.setEnabled(enabled);
        this.organiseTextArea.setEnabled(enabled);
        this.notesLabel.setEnabled(enabled);
        this.notesEditorPane.setEnabled(enabled);
        this.notesEditorPane.setEditable(false);
        this.createdDateLabel.setEnabled(enabled);
        this.createdDateField.setEnabled(enabled && ProjectsPrefs.isEditCreateDate());
        this.startDateLabel.setEnabled(enabled);
        this.startDateField.setEnabled(enabled);
        this.startDateLabel.setVisible(ProjectsPrefs.isIncludeStartDate());
        this.startDateField.setVisible(ProjectsPrefs.isIncludeStartDate());
        this.dueDateLabel.setEnabled(enabled);
        this.dueDateField.setEnabled(enabled);
        this.dueDateLabel.setVisible(ProjectsPrefs.isIncludeDueDate());
        this.dueDateField.setVisible(ProjectsPrefs.isIncludeDueDate());
        this.sequencingCheckBox.setEnabled(enabled);
        this.sequencingCombo.setEnabled(enabled && this.project.isSequencing());
        this.doneCheckBox.setEnabled(enabled);
        this.doneDateField.setEnabled(enabled && this.project.canSetDone(true));
        this.priorityLabel.setEnabled(enabled);
        this.priorityCombo.setEnabled(enabled);
        this.showHideCriteria();
        this.changedPrefs();
    }

    private void showHideCriteria() {
        Data data = this.getData();
        this.priorityLabel.setVisible(data.getPriorityCriterion().isUse());
        this.priorityCombo.setVisible(data.getPriorityCriterion().isUse());
    }

    public void focus() {
        this.descriptionText.requestFocus();
    }

    private void changedPrefs() {
        this.removeAll();
        JPanel panel = this.createPanel();
        this.add((Component)panel, "Center");
        panel.revalidate();
        panel.repaint();
    }

    private void changedDescription() {
        if (this.updating || this.project == null) {
            return;
        }
        this.project.setDescription(this.descriptionText.getText());
    }

    private void changedPurpose() {
        if (this.updating || this.project == null) {
            return;
        }
        this.project.setPurpose(this.purposeTextArea.getText());
    }

    private void changedVision() {
        if (this.updating || this.project == null) {
            return;
        }
        this.project.setVision(this.visionTextArea.getText());
    }

    private void changedBrainstorm() {
        if (this.updating || this.project == null) {
            return;
        }
        this.project.setBrainstorming(this.brainstormTextArea.getText());
    }

    private void changedOrganise() {
        if (this.updating || this.project == null) {
            return;
        }
        this.project.setOrganising(this.organiseTextArea.getText());
    }

    private void changedNotes() {
        if (this.updating || this.project == null) {
            return;
        }
        this.project.setNotes(this.notesEditorPane.getText());
    }

    private void initPanel() {
        this.descriptionLabel = new TRLabel();
        this.descriptionLabel.setText(NbBundle.getMessage(ProjectPanel.class, (String)"ProjectPanel.description"));
        this.descriptionText = new TRTextField();
        this.topicLabel = new TRLabel();
        this.topicLabel.setText(NbBundle.getMessage(ProjectPanel.class, (String)"ProjectPanel.topic"));
        this.topicsModel = new TopicsComboBoxModel(false);
        this.topicCombo = new TopicsComboBox(this.topicsModel);
        this.priorityLabel = new TRLabel();
        this.priorityLabel.setText(NbBundle.getMessage(ProjectPanel.class, (String)"LBL_Priority"));
        this.priorityCombo = new TRComboBox();
        this.priorityCombo.setModel(this.getPriorityComboBoxModel());
        this.sequencingCheckBox = new JCheckBox();
        this.sequencingCheckBox.setHorizontalTextPosition(2);
        this.sequencingCheckBox.setText(NbBundle.getMessage(ProjectPanel.class, (String)"ProjectPanel.sequencing"));
        this.sequencingCombo = new TRComboBox();
        this.sequencingCombo.setModel((ComboBoxModel)new SequencingModel());
        this.dueDateLabel = new TRLabel();
        this.dueDateLabel.setText(NbBundle.getMessage(ProjectPanel.class, (String)"ProjectPanel.due"));
        this.dueDateField = new DateField();
        this.startDateLabel = new TRLabel();
        this.startDateLabel.setText(NbBundle.getMessage(ProjectPanel.class, (String)"ProjectPanel.start"));
        this.startDateField = new DateField();
        this.purposeLabel = new TRLabel();
        this.purposeLabel.setText(NbBundle.getMessage(ProjectPanel.class, (String)"ProjectPanel.purpose"));
        this.purposeTextArea = new MTextArea();
        this.visionLabel = new TRLabel();
        this.visionLabel.setText(NbBundle.getMessage(ProjectPanel.class, (String)"ProjectPanel.vision"));
        this.visionTextArea = new MTextArea();
        this.brainstormLabel = new TRLabel();
        this.brainstormLabel.setText(NbBundle.getMessage(ProjectPanel.class, (String)"ProjectPanel.brainstorming"));
        this.brainstormTextArea = new MTextArea();
        this.organiseLabel = new TRLabel();
        this.organiseLabel.setText(NbBundle.getMessage(ProjectPanel.class, (String)"ProjectPanel.organising"));
        this.organiseTextArea = new MTextArea();
        this.notesLabel = new TRLabel();
        this.notesLabel.setText(NbBundle.getMessage(ProjectPanel.class, (String)"ProjectPanel.notes"));
        this.notesEditorPane = new HyperEditorPane();
        this.notesEditorPane.setMinimumSize(new Dimension(50, 62));
        this.notesEditorPane.setPreferredSize(new Dimension(50, 62));
        this.doneCheckBox = new JCheckBox();
        this.doneCheckBox.setHorizontalTextPosition(2);
        this.doneCheckBox.setText(NbBundle.getMessage(ProjectPanel.class, (String)"ProjectPanel.completed"));
        this.doneDateField = new DateField();
        this.createdDateLabel = new TRLabel();
        this.createdDateLabel.setText(NbBundle.getMessage(ProjectPanel.class, (String)"ProjectPanel.created"));
        this.createdDateField = new DateField();
        this.add((Component)this.createPanel(), "Center");
    }

    private JPanel createPanel() {
        JComponent[][] includedOptionalComponents = new JComponent[3][2];
        int includedOptionalComponentsCount = 0;
        if (ProjectsPrefs.isIncludeDueDate()) {
            includedOptionalComponents[includedOptionalComponentsCount][0] = this.dueDateLabel;
            includedOptionalComponents[includedOptionalComponentsCount][1] = this.dueDateField;
            ++includedOptionalComponentsCount;
        }
        if (ProjectsPrefs.isIncludeStartDate()) {
            includedOptionalComponents[includedOptionalComponentsCount][0] = this.startDateLabel;
            includedOptionalComponents[includedOptionalComponentsCount][1] = this.startDateField;
            ++includedOptionalComponentsCount;
        }
        if (ProjectsPrefs.isSequencing()) {
            includedOptionalComponents[includedOptionalComponentsCount][0] = this.sequencingCheckBox;
            includedOptionalComponents[includedOptionalComponentsCount][1] = this.sequencingCombo;
            ++includedOptionalComponentsCount;
        }
        JPanel panel = includedOptionalComponentsCount > 0 ? (ViewUtils.isAquaLaF() ? new JPanel((LayoutManager)this.layoutA1) : new JPanel((LayoutManager)this.layoutM1)) : (ViewUtils.isAquaLaF() ? new JPanel((LayoutManager)this.layoutA2) : new JPanel((LayoutManager)this.layoutM2));
        panel.add((Component)this.descriptionLabel, "align right");
        panel.add((Component)this.descriptionText, "span, growx 100, wrap");
        panel.add((Component)this.topicLabel, "align right");
        panel.add((Component)this.topicCombo, "split 3, align left");
        panel.add((Component)this.priorityLabel, "align left");
        panel.add((Component)this.priorityCombo, "align left, wrap");
        ViewUtils.addSeparator((JPanel)panel);
        if (includedOptionalComponentsCount > 0) {
            for (int i = 0; i < includedOptionalComponentsCount; ++i) {
                includedOptionalComponents[i][0].setVisible(true);
                includedOptionalComponents[i][0].setEnabled(true);
                includedOptionalComponents[i][1].setVisible(true);
                includedOptionalComponents[i][1].setEnabled(true);
            }
            if (includedOptionalComponentsCount == 1) {
                panel.add((Component)includedOptionalComponents[0][0], "align right");
                panel.add((Component)includedOptionalComponents[0][1], "align left, wrap");
            } else if (includedOptionalComponentsCount == 2) {
                panel.add((Component)includedOptionalComponents[0][0], "align right");
                panel.add((Component)includedOptionalComponents[0][1], "align left, split 3");
                panel.add((Component)includedOptionalComponents[1][0], "align left");
                panel.add((Component)includedOptionalComponents[1][1], "align left, wrap");
            } else if (includedOptionalComponentsCount == 3) {
                panel.add((Component)includedOptionalComponents[0][0], "align right");
                panel.add((Component)includedOptionalComponents[0][1], "align left, split 5");
                panel.add((Component)includedOptionalComponents[1][0], "align left");
                panel.add((Component)includedOptionalComponents[1][1], "align left");
                panel.add((Component)includedOptionalComponents[2][0], "align left");
                panel.add((Component)includedOptionalComponents[2][1], "align left, wrap");
            }
            ViewUtils.addSeparator((JPanel)panel);
        }
        if (ViewUtils.isAquaLaF()) {
            panel.add((Component)this.purposeLabel, "align right");
            panel.add((Component)this.purposeTextArea, "gapleft 3, gapright 3, span, growx 100, growy 0, wrap");
            panel.add((Component)this.visionLabel, "align right");
            panel.add((Component)this.visionTextArea, "gapleft 3, gapright 3, span, growx 100, growy 0, wrap");
            panel.add((Component)this.brainstormLabel, "align right");
            panel.add((Component)this.brainstormTextArea, "gapleft 3, gapright 3, span, growx 100, growy 0, wrap");
            panel.add((Component)this.organiseLabel, "align right");
            panel.add((Component)this.organiseTextArea, "gapleft 3, gapright 3, span, growx 100, growy 0, wrap");
        } else {
            panel.add((Component)this.purposeLabel, "align right");
            panel.add((Component)this.purposeTextArea, "span, growx 100, growy 0, wrap");
            panel.add((Component)this.visionLabel, "align right");
            panel.add((Component)this.visionTextArea, "span, growx 100, growy 0, wrap");
            panel.add((Component)this.brainstormLabel, "align right");
            panel.add((Component)this.brainstormTextArea, "span, growx 100, growy 0, wrap");
            panel.add((Component)this.organiseLabel, "align right");
            panel.add((Component)this.organiseTextArea, "span, growx 100, growy 0, wrap");
        }
        ViewUtils.addSeparator((JPanel)panel);
        if (ViewUtils.isAquaLaF()) {
            panel.add((Component)this.notesLabel, "align right top, gaptop 4, growy 0");
            panel.add((Component)this.notesEditorPane, "span, gapleft 3, gapright 3, align left, grow, wrap");
        } else {
            panel.add((Component)this.notesLabel, "align right top, growy 0");
            panel.add((Component)this.notesEditorPane, "span, align left, grow, wrap");
        }
        ViewUtils.addSeparator((JPanel)panel);
        panel.add((Component)this.doneCheckBox, "align right");
        panel.add((Component)this.doneDateField, "align left, split 3");
        panel.add((Component)this.createdDateLabel, "align left");
        panel.add((Component)this.createdDateField, "align left, wrap");
        return panel;
    }

    private String getMIGCons() {
        return "";
    }

    private String getMIGCons(String c) {
        assert (c != null && c.trim().length() > 0);
        return c;
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }
}

