/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.modifiablevariable.singlebyte;

import de.rub.nds.modifiablevariable.VariableModification;
import java.util.Objects;
import java.util.Random;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement
@XmlType(propOrder={"summand", "modificationFilter", "postModification"})
public class ByteAddModification
extends VariableModification<Byte> {
    private static final int MAX_ADD_MODIFIER = 16;
    private Byte summand;

    public ByteAddModification() {
    }

    public ByteAddModification(Byte bi) {
        this.summand = bi;
    }

    @Override
    protected Byte modifyImplementationHook(Byte input) {
        if (input == null) {
            input = 0;
        }
        return (byte)(input + this.summand);
    }

    public Byte getSummand() {
        return this.summand;
    }

    public void setSummand(Byte summand) {
        this.summand = summand;
    }

    @Override
    public VariableModification<Byte> getModifiedCopy() {
        return new ByteAddModification((byte)(this.summand + new Random().nextInt(16)));
    }

    public int hashCode() {
        int hash = 5;
        hash = 17 * hash + Objects.hashCode(this.summand);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ByteAddModification other = (ByteAddModification)obj;
        return Objects.equals(this.summand, other.summand);
    }
}

