/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.aws.s3;

import org.gradle.authentication.aws.AwsImAuthentication;
import org.gradle.internal.authentication.AuthenticationSchemeRegistry;
import org.gradle.internal.authentication.DefaultAwsImAuthentication;
import org.gradle.internal.resource.connector.ResourceConnectorFactory;
import org.gradle.internal.resource.transport.aws.s3.S3ConnectorFactory;
import org.gradle.internal.service.Provides;
import org.gradle.internal.service.ServiceRegistration;
import org.gradle.internal.service.ServiceRegistrationProvider;
import org.gradle.internal.service.scopes.AbstractGradleModuleServices;

public class S3ResourcesServices
extends AbstractGradleModuleServices {
    public void registerGlobalServices(ServiceRegistration registration) {
        registration.addProvider((ServiceRegistrationProvider)new GlobalScopeServices());
    }

    public void registerBuildServices(ServiceRegistration registration) {
        registration.addProvider((ServiceRegistrationProvider)new AuthenticationSchemeAction());
    }

    private static class GlobalScopeServices
    implements ServiceRegistrationProvider {
        private GlobalScopeServices() {
        }

        @Provides
        ResourceConnectorFactory createS3ConnectorFactory() {
            return new S3ConnectorFactory();
        }
    }

    private static class AuthenticationSchemeAction
    implements ServiceRegistrationProvider {
        private AuthenticationSchemeAction() {
        }

        @Provides
        public void configure(ServiceRegistration registration, AuthenticationSchemeRegistry authenticationSchemeRegistry) {
            authenticationSchemeRegistry.registerScheme(AwsImAuthentication.class, DefaultAwsImAuthentication.class);
        }
    }
}

