/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.catalog;

import java.util.List;
import java.util.Optional;
import org.gradle.api.artifacts.ExternalModuleDependencyBundle;
import org.gradle.api.artifacts.MinimalExternalModuleDependency;
import org.gradle.api.artifacts.VersionCatalog;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.internal.artifacts.dsl.CapabilityNotationParser;
import org.gradle.api.internal.attributes.AttributesFactory;
import org.gradle.api.internal.catalog.AbstractExternalDependencyFactory;
import org.gradle.api.internal.catalog.AliasNormalizer;
import org.gradle.api.internal.catalog.DefaultExternalDependencyFactory;
import org.gradle.api.internal.catalog.DefaultVersionCatalog;
import org.gradle.api.internal.catalog.ExternalModuleDependencyFactory;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.plugin.use.PluginDependency;

public class VersionCatalogView
implements VersionCatalog {
    private final DefaultVersionCatalog config;
    private final ProviderFactory providerFactory;
    private final ExternalModuleDependencyFactory dependencyFactory;
    private final AbstractExternalDependencyFactory.BundleFactory bundleFactory;

    public VersionCatalogView(DefaultVersionCatalog config, ProviderFactory providerFactory, ObjectFactory objects, AttributesFactory attributesFactory, CapabilityNotationParser capabilityNotationParser) {
        this.config = config;
        this.providerFactory = providerFactory;
        this.dependencyFactory = new DefaultExternalDependencyFactory(config, providerFactory, objects, attributesFactory, capabilityNotationParser);
        this.bundleFactory = new AbstractExternalDependencyFactory.BundleFactory(objects, providerFactory, config, attributesFactory, capabilityNotationParser);
    }

    public final Optional<Provider<MinimalExternalModuleDependency>> findLibrary(String alias) {
        String normalizedAlias = AliasNormalizer.normalize(alias);
        if (this.config.hasDependency(normalizedAlias)) {
            return Optional.of(this.dependencyFactory.create(normalizedAlias));
        }
        return Optional.empty();
    }

    public final Optional<Provider<ExternalModuleDependencyBundle>> findBundle(String alias) {
        String normalizedBundle = AliasNormalizer.normalize(alias);
        if (this.config.hasBundle(normalizedBundle)) {
            return Optional.of(this.bundleFactory.createBundle(normalizedBundle));
        }
        return Optional.empty();
    }

    public final Optional<VersionConstraint> findVersion(String alias) {
        String normalizedName = AliasNormalizer.normalize(alias);
        if (this.config.hasVersion(normalizedName)) {
            return Optional.of(new AbstractExternalDependencyFactory.VersionFactory(this.providerFactory, this.config).findVersionConstraint(normalizedName));
        }
        return Optional.empty();
    }

    public Optional<Provider<PluginDependency>> findPlugin(String alias) {
        String normalizedAlias = AliasNormalizer.normalize(alias);
        if (this.config.hasPlugin(normalizedAlias)) {
            return Optional.of(new AbstractExternalDependencyFactory.PluginFactory(this.providerFactory, this.config).createPlugin(normalizedAlias));
        }
        return Optional.empty();
    }

    public final String getName() {
        return this.config.getName();
    }

    public List<String> getLibraryAliases() {
        return this.config.getLibraryAliases();
    }

    public List<String> getBundleAliases() {
        return this.config.getBundleAliases();
    }

    public List<String> getVersionAliases() {
        return this.config.getVersionAliases();
    }

    public List<String> getPluginAliases() {
        return this.config.getPluginAliases();
    }
}

