/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test.openal;

import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.OpenALException;
import org.lwjgl.test.openal.BasicTest;

public class SourceLimitTest
extends BasicTest {
    protected int sourcesToCreate = 64;

    protected void execute(String[] args) {
        if (args.length > 0) {
            try {
                this.sourcesToCreate = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException nfe) {
                System.out.println("Unable to parse parameter to integer. Defaulting to 64 sources.");
            }
        }
        System.out.print("Creating " + this.sourcesToCreate + " in one go...");
        try {
            this.CreateAllSources();
        }
        catch (OpenALException oale) {
            oale.printStackTrace();
        }
        System.out.print("Creating " + this.sourcesToCreate + " one at a time...");
        try {
            this.CreateSourcesStep();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.alExit();
    }

    protected void CreateAllSources() {
        IntBuffer sources = BufferUtils.createIntBuffer((int)this.sourcesToCreate);
        try {
            sources.position(0).limit(this.sourcesToCreate);
            AL10.alGenSources((IntBuffer)sources);
            sources.position(0).limit(this.sourcesToCreate);
            AL10.alDeleteSources((IntBuffer)sources);
            System.out.println("created " + this.sourcesToCreate + " sources successfully!");
        }
        catch (OpenALException oale) {
            System.out.println("Unable to create " + this.sourcesToCreate + " sources");
        }
    }

    protected void CreateSourcesStep() {
        int i;
        int sourcesCreated = 0;
        IntBuffer[] sources = new IntBuffer[this.sourcesToCreate];
        try {
            for (i = 0; i < this.sourcesToCreate; ++i) {
                sources[i] = BufferUtils.createIntBuffer((int)1);
                sources[i].position(0).limit(1);
                AL10.alGenSources((IntBuffer)sources[i]);
                int lastError = AL10.alGetError();
                if (lastError == 0) {
                    ++sourcesCreated;
                    continue;
                }
                break;
            }
        }
        catch (OpenALException oale) {
            System.out.println("failed to create source: " + (sourcesCreated + 1));
        }
        for (i = 0; i < sourcesCreated; ++i) {
            sources[i].position(0).limit(1);
            AL10.alDeleteSources((IntBuffer)sources[i]);
        }
        if (sourcesCreated != this.sourcesToCreate) {
            System.out.println("created " + sourcesCreated + " sources before failing");
        } else {
            System.out.println("created " + sourcesCreated + " sources successfully!");
        }
    }

    public static void main(String[] args) {
        SourceLimitTest sourceLimitTest = new SourceLimitTest();
        sourceLimitTest.execute(args);
        System.exit(0);
    }
}

