/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.model.yaml.internal.items.fileconverter;

import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.config.core.ConfigDescription;
import org.openhab.core.config.core.ConfigDescriptionParameter;
import org.openhab.core.config.core.ConfigDescriptionRegistry;
import org.openhab.core.config.core.ConfigUtil;
import org.openhab.core.items.GroupFunction;
import org.openhab.core.items.GroupItem;
import org.openhab.core.items.Item;
import org.openhab.core.items.ItemUtil;
import org.openhab.core.items.Metadata;
import org.openhab.core.items.fileconverter.AbstractItemFileGenerator;
import org.openhab.core.items.fileconverter.ItemFileGenerator;
import org.openhab.core.model.yaml.YamlElement;
import org.openhab.core.model.yaml.YamlModelRepository;
import org.openhab.core.model.yaml.internal.items.YamlGroupDTO;
import org.openhab.core.model.yaml.internal.items.YamlItemDTO;
import org.openhab.core.model.yaml.internal.items.YamlMetadataDTO;
import org.openhab.core.types.State;
import org.openhab.core.types.StateDescription;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@NonNullByDefault
@Component(immediate=true, service={ItemFileGenerator.class})
public class YamlItemFileConverter
extends AbstractItemFileGenerator {
    private final YamlModelRepository modelRepository;
    private final ConfigDescriptionRegistry configDescriptionRegistry;

    @Activate
    public YamlItemFileConverter(@Reference YamlModelRepository modelRepository, @Reference ConfigDescriptionRegistry configDescRegistry) {
        this.modelRepository = modelRepository;
        this.configDescriptionRegistry = configDescRegistry;
    }

    public String getFileFormatGenerator() {
        return "YAML";
    }

    public void generateFileFormat(OutputStream out, List<Item> items, Collection<Metadata> metadata, boolean hideDefaultParameters) {
        ArrayList<YamlElement> elements = new ArrayList<YamlElement>();
        items.forEach(item -> elements.add(this.buildItemDTO((Item)item, this.getChannelLinks(metadata, item.getName()), this.getMetadata(metadata, item.getName()), hideDefaultParameters)));
        this.modelRepository.generateSyntaxFromElements(out, elements);
    }

    private YamlItemDTO buildItemDTO(Item item, List<Metadata> channelLinks, List<Metadata> metadata, boolean hideDefaultParameters) {
        String category;
        GroupItem groupItem;
        Item baseItem;
        YamlItemDTO dto = new YamlItemDTO();
        dto.name = item.getName();
        String label = item.getLabel();
        boolean patternSet = false;
        String defaultPattern = this.getDefaultStatePattern(item);
        if (label != null && !label.isEmpty()) {
            String patterToSet;
            dto.label = item.getLabel();
            StateDescription stateDescr = item.getStateDescription();
            String statePattern = stateDescr == null ? null : stateDescr.getPattern();
            dto.format = patterToSet = statePattern != null && !statePattern.equals(defaultPattern) ? statePattern : null;
            patternSet = patterToSet != null;
        }
        dto.type = item.getType();
        String mainType = ItemUtil.getMainItemType((String)item.getType());
        String dimension = ItemUtil.getItemTypeExtension((String)item.getType());
        if ("Number".equals(mainType) && dimension != null) {
            dto.type = mainType;
            dto.dimension = dimension;
        }
        if (item instanceof GroupItem && (baseItem = (groupItem = (GroupItem)item).getBaseItem()) != null) {
            GroupFunction function;
            dto.group = new YamlGroupDTO();
            dto.group.type = baseItem.getType();
            mainType = ItemUtil.getMainItemType((String)baseItem.getType());
            dimension = ItemUtil.getItemTypeExtension((String)baseItem.getType());
            if ("Number".equals(mainType) && dimension != null) {
                dto.group.type = mainType;
                dto.group.dimension = dimension;
            }
            if ((function = groupItem.getFunction()) != null && !(function instanceof GroupFunction.Equality)) {
                dto.group.function = function.getClass().getSimpleName();
                ArrayList<String> params = new ArrayList<String>();
                State[] parameters = function.getParameters();
                int i = 0;
                while (i < parameters.length) {
                    params.add(parameters[i].toString());
                    ++i;
                }
                List<String> list = dto.group.parameters = params.isEmpty() ? null : params;
            }
        }
        if ((category = item.getCategory()) != null && !category.isEmpty()) {
            dto.icon = category;
        }
        if (!item.getGroupNames().isEmpty()) {
            dto.groups = new ArrayList<String>();
            item.getGroupNames().forEach(group -> yamlItemDTO.groups.add((String)group));
        }
        if (!item.getTags().isEmpty()) {
            dto.tags = new LinkedHashSet<String>();
            item.getTags().stream().sorted().collect(Collectors.toList()).forEach(tag -> yamlItemDTO.tags.add((String)tag));
        }
        if (channelLinks.size() == 1 && channelLinks.getFirst().getConfiguration().isEmpty()) {
            dto.channel = channelLinks.getFirst().getValue();
        } else if (!channelLinks.isEmpty()) {
            dto.channels = new LinkedHashMap<String, Map<String, Object>>();
            channelLinks.forEach(md -> {
                LinkedHashMap configuration = new LinkedHashMap();
                this.getConfigurationParameters((Metadata)md, hideDefaultParameters).forEach(param -> configuration.put(param.name(), param.value()));
                yamlItemDTO.channels.put(md.getValue(), configuration);
            });
        }
        LinkedHashMap<String, YamlMetadataDTO> metadataDto = new LinkedHashMap<String, YamlMetadataDTO>();
        for (Metadata md2 : metadata) {
            String namespace = md2.getUID().getNamespace();
            if ("autoupdate".equals(namespace)) {
                dto.autoupdate = Boolean.valueOf(md2.getValue());
                continue;
            }
            if ("unit".equals(namespace)) {
                dto.unit = md2.getValue();
                continue;
            }
            YamlMetadataDTO mdDto = new YamlMetadataDTO();
            mdDto.value = md2.getValue().isEmpty() ? null : md2.getValue();
            LinkedHashMap<String, Object> configuration = new LinkedHashMap<String, Object>();
            String statePattern = null;
            for (AbstractItemFileGenerator.ConfigParameter param : this.getConfigurationParameters(md2)) {
                configuration.put(param.name(), param.value());
                if (!"stateDescription".equals(namespace) || !"pattern".equals(param.name())) continue;
                statePattern = param.value().toString();
            }
            if (statePattern != null && configuration.size() == 1 && (patternSet || statePattern.equals(defaultPattern))) continue;
            mdDto.config = configuration.isEmpty() ? null : configuration;
            metadataDto.put(namespace, mdDto);
            if (!patternSet || statePattern == null) continue;
            dto.format = null;
        }
        dto.metadata = metadataDto.isEmpty() ? null : metadataDto;
        return dto;
    }

    private List<AbstractItemFileGenerator.ConfigParameter> getConfigurationParameters(Metadata metadata, boolean hideDefaultParameters) {
        ArrayList<AbstractItemFileGenerator.ConfigParameter> parameters = new ArrayList<AbstractItemFileGenerator.ConfigParameter>();
        HashSet<String> handledNames = new HashSet<String>();
        Map configParameters = metadata.getConfiguration();
        Object profile = configParameters.get("profile");
        List configDescriptionParameter = List.of();
        if (profile instanceof String) {
            String profileStr = (String)profile;
            parameters.add(new AbstractItemFileGenerator.ConfigParameter("profile", (Object)profileStr));
            handledNames.add("profile");
            try {
                ConfigDescription configDesc = this.configDescriptionRegistry.getConfigDescription(new URI("profile:" + profileStr));
                if (configDesc != null) {
                    configDescriptionParameter = configDesc.getParameters();
                }
            }
            catch (URISyntaxException configDesc) {
                // empty catch block
            }
        }
        for (ConfigDescriptionParameter param : configDescriptionParameter) {
            String paramName = param.getName();
            if (handledNames.contains(paramName)) continue;
            Object value = configParameters.get(paramName);
            Object defaultValue = ConfigUtil.getDefaultValueAsCorrectType((ConfigDescriptionParameter)param);
            if (!(value == null || hideDefaultParameters && value.equals(defaultValue))) {
                parameters.add(new AbstractItemFileGenerator.ConfigParameter(paramName, value));
            }
            handledNames.add(paramName);
        }
        for (String paramName : configParameters.keySet().stream().sorted().collect(Collectors.toList())) {
            if (handledNames.contains(paramName)) continue;
            Object value = configParameters.get(paramName);
            if (value != null) {
                parameters.add(new AbstractItemFileGenerator.ConfigParameter(paramName, value));
            }
            handledNames.add(paramName);
        }
        return parameters;
    }
}

