# pylint:disable=line-too-long
import logging

from ...sim_type import SimTypeFunction,     SimTypeShort, SimTypeInt, SimTypeLong, SimTypeLongLong, SimTypeDouble, SimTypeFloat,     SimTypePointer,     SimTypeChar,     SimStruct,     SimTypeFixedSizeArray,     SimTypeBottom,     SimUnion,     SimTypeBool
from ...calling_conventions import SimCCStdcall, SimCCMicrosoftAMD64
from .. import SIM_PROCEDURES as P
from . import SimLibrary


_l = logging.getLogger(name=__name__)


lib = SimLibrary()
lib.set_default_cc('X86', SimCCStdcall)
lib.set_default_cc('AMD64', SimCCMicrosoftAMD64)
lib.set_library_names("powrprof.dll")
prototypes = \
    {
        #
        'CallNtPowerInformation': SimTypeFunction([SimTypeInt(signed=False, label="POWER_INFORMATION_LEVEL"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["InformationLevel", "InputBuffer", "InputBufferLength", "OutputBuffer", "OutputBufferLength"]),
        #
        'GetPwrCapabilities': SimTypeFunction([SimTypePointer(SimStruct({"PowerButtonPresent": SimTypeChar(label="Byte"), "SleepButtonPresent": SimTypeChar(label="Byte"), "LidPresent": SimTypeChar(label="Byte"), "SystemS1": SimTypeChar(label="Byte"), "SystemS2": SimTypeChar(label="Byte"), "SystemS3": SimTypeChar(label="Byte"), "SystemS4": SimTypeChar(label="Byte"), "SystemS5": SimTypeChar(label="Byte"), "HiberFilePresent": SimTypeChar(label="Byte"), "FullWake": SimTypeChar(label="Byte"), "VideoDimPresent": SimTypeChar(label="Byte"), "ApmPresent": SimTypeChar(label="Byte"), "UpsPresent": SimTypeChar(label="Byte"), "ThermalControl": SimTypeChar(label="Byte"), "ProcessorThrottle": SimTypeChar(label="Byte"), "ProcessorMinThrottle": SimTypeChar(label="Byte"), "ProcessorMaxThrottle": SimTypeChar(label="Byte"), "FastSystemS4": SimTypeChar(label="Byte"), "Hiberboot": SimTypeChar(label="Byte"), "WakeAlarmPresent": SimTypeChar(label="Byte"), "AoAc": SimTypeChar(label="Byte"), "DiskSpinDown": SimTypeChar(label="Byte"), "HiberFileType": SimTypeChar(label="Byte"), "AoAcConnectivitySupported": SimTypeChar(label="Byte"), "spare3": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 6), "SystemBatteriesPresent": SimTypeChar(label="Byte"), "BatteriesAreShortTerm": SimTypeChar(label="Byte"), "BatteryScale": SimTypeFixedSizeArray(SimStruct({"Granularity": SimTypeInt(signed=False, label="UInt32"), "Capacity": SimTypeInt(signed=False, label="UInt32")}, name="BATTERY_REPORTING_SCALE", pack=False, align=None), 3), "AcOnLineWake": SimTypeInt(signed=False, label="SYSTEM_POWER_STATE"), "SoftLidWake": SimTypeInt(signed=False, label="SYSTEM_POWER_STATE"), "RtcWake": SimTypeInt(signed=False, label="SYSTEM_POWER_STATE"), "MinDeviceWakeState": SimTypeInt(signed=False, label="SYSTEM_POWER_STATE"), "DefaultLowLatencyWake": SimTypeInt(signed=False, label="SYSTEM_POWER_STATE")}, name="SYSTEM_POWER_CAPABILITIES", pack=False, align=None), offset=0)], SimTypeChar(label="Byte"), arg_names=["lpspc"]),
        #
        'PowerDeterminePlatformRoleEx': SimTypeFunction([SimTypeInt(signed=False, label="POWER_PLATFORM_ROLE_VERSION")], SimTypeInt(signed=False, label="POWER_PLATFORM_ROLE"), arg_names=["Version"]),
        #
        'PowerRegisterSuspendResumeNotification': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["Flags", "Recipient", "RegistrationHandle"]),
        #
        'PowerUnregisterSuspendResumeNotification': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RegistrationHandle"]),
        #
        'PowerReadACValue': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RootPowerKey", "SchemeGuid", "SubGroupOfPowerSettingsGuid", "PowerSettingGuid", "Type", "Buffer", "BufferSize"]),
        #
        'PowerReadDCValue': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RootPowerKey", "SchemeGuid", "SubGroupOfPowerSettingsGuid", "PowerSettingGuid", "Type", "Buffer", "BufferSize"]),
        #
        'PowerWriteACValueIndex': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["RootPowerKey", "SchemeGuid", "SubGroupOfPowerSettingsGuid", "PowerSettingGuid", "AcValueIndex"]),
        #
        'PowerWriteDCValueIndex': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["RootPowerKey", "SchemeGuid", "SubGroupOfPowerSettingsGuid", "PowerSettingGuid", "DcValueIndex"]),
        #
        'PowerGetActiveScheme': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Guid"), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["UserRootPowerKey", "ActivePolicyGuid"]),
        #
        'PowerSetActiveScheme': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["UserRootPowerKey", "SchemeGuid"]),
        #
        'PowerSettingRegisterNotification': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="POWER_SETTING_REGISTER_NOTIFICATION_FLAGS"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["SettingGuid", "Flags", "Recipient", "RegistrationHandle"]),
        #
        'PowerSettingUnregisterNotification': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RegistrationHandle"]),
        #
        'PowerRegisterForEffectivePowerModeNotifications': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="EFFECTIVE_POWER_MODE"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeBottom(label="Void"), arg_names=["Mode", "Context"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["Version", "Callback", "Context", "RegistrationHandle"]),
        #
        'PowerUnregisterFromEffectivePowerModeNotifications': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["RegistrationHandle"]),
        #
        'GetPwrDiskSpindownRange': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeChar(label="Byte"), arg_names=["puiMax", "puiMin"]),
        #
        'EnumPwrSchemes': SimTypeFunction([SimTypePointer(SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"user": SimStruct({"Revision": SimTypeInt(signed=False, label="UInt32"), "IdleAc": SimStruct({"Action": SimTypeInt(signed=False, label="POWER_ACTION"), "Flags": SimTypeInt(signed=False, label="UInt32"), "EventCode": SimTypeInt(signed=False, label="POWER_ACTION_POLICY_EVENT_CODE")}, name="POWER_ACTION_POLICY", pack=False, align=None), "IdleDc": SimStruct({"Action": SimTypeInt(signed=False, label="POWER_ACTION"), "Flags": SimTypeInt(signed=False, label="UInt32"), "EventCode": SimTypeInt(signed=False, label="POWER_ACTION_POLICY_EVENT_CODE")}, name="POWER_ACTION_POLICY", pack=False, align=None), "IdleTimeoutAc": SimTypeInt(signed=False, label="UInt32"), "IdleTimeoutDc": SimTypeInt(signed=False, label="UInt32"), "IdleSensitivityAc": SimTypeChar(label="Byte"), "IdleSensitivityDc": SimTypeChar(label="Byte"), "ThrottlePolicyAc": SimTypeChar(label="Byte"), "ThrottlePolicyDc": SimTypeChar(label="Byte"), "MaxSleepAc": SimTypeInt(signed=False, label="SYSTEM_POWER_STATE"), "MaxSleepDc": SimTypeInt(signed=False, label="SYSTEM_POWER_STATE"), "Reserved": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 2), "VideoTimeoutAc": SimTypeInt(signed=False, label="UInt32"), "VideoTimeoutDc": SimTypeInt(signed=False, label="UInt32"), "SpindownTimeoutAc": SimTypeInt(signed=False, label="UInt32"), "SpindownTimeoutDc": SimTypeInt(signed=False, label="UInt32"), "OptimizeForPowerAc": SimTypeChar(label="Byte"), "OptimizeForPowerDc": SimTypeChar(label="Byte"), "FanThrottleToleranceAc": SimTypeChar(label="Byte"), "FanThrottleToleranceDc": SimTypeChar(label="Byte"), "ForcedThrottleAc": SimTypeChar(label="Byte"), "ForcedThrottleDc": SimTypeChar(label="Byte")}, name="USER_POWER_POLICY", pack=False, align=None), "mach": SimStruct({"Revision": SimTypeInt(signed=False, label="UInt32"), "MinSleepAc": SimTypeInt(signed=False, label="SYSTEM_POWER_STATE"), "MinSleepDc": SimTypeInt(signed=False, label="SYSTEM_POWER_STATE"), "ReducedLatencySleepAc": SimTypeInt(signed=False, label="SYSTEM_POWER_STATE"), "ReducedLatencySleepDc": SimTypeInt(signed=False, label="SYSTEM_POWER_STATE"), "DozeTimeoutAc": SimTypeInt(signed=False, label="UInt32"), "DozeTimeoutDc": SimTypeInt(signed=False, label="UInt32"), "DozeS4TimeoutAc": SimTypeInt(signed=False, label="UInt32"), "DozeS4TimeoutDc": SimTypeInt(signed=False, label="UInt32"), "MinThrottleAc": SimTypeChar(label="Byte"), "MinThrottleDc": SimTypeChar(label="Byte"), "pad1": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "OverThrottledAc": SimStruct({"Action": SimTypeInt(signed=False, label="POWER_ACTION"), "Flags": SimTypeInt(signed=False, label="UInt32"), "EventCode": SimTypeInt(signed=False, label="POWER_ACTION_POLICY_EVENT_CODE")}, name="POWER_ACTION_POLICY", pack=False, align=None), "OverThrottledDc": SimStruct({"Action": SimTypeInt(signed=False, label="POWER_ACTION"), "Flags": SimTypeInt(signed=False, label="UInt32"), "EventCode": SimTypeInt(signed=False, label="POWER_ACTION_POLICY_EVENT_CODE")}, name="POWER_ACTION_POLICY", pack=False, align=None)}, name="MACHINE_POWER_POLICY", pack=False, align=None)}, name="POWER_POLICY", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeChar(label="Byte"), arg_names=["Index", "NameSize", "Name", "DescriptionSize", "Description", "Policy", "Context"]), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeChar(label="Byte"), arg_names=["lpfn", "lParam"]),
        #
        'ReadGlobalPwrPolicy': SimTypeFunction([SimTypePointer(SimStruct({"user": SimStruct({"Revision": SimTypeInt(signed=False, label="UInt32"), "PowerButtonAc": SimStruct({"Action": SimTypeInt(signed=False, label="POWER_ACTION"), "Flags": SimTypeInt(signed=False, label="UInt32"), "EventCode": SimTypeInt(signed=False, label="POWER_ACTION_POLICY_EVENT_CODE")}, name="POWER_ACTION_POLICY", pack=False, align=None), "PowerButtonDc": SimStruct({"Action": SimTypeInt(signed=False, label="POWER_ACTION"), "Flags": SimTypeInt(signed=False, label="UInt32"), "EventCode": SimTypeInt(signed=False, label="POWER_ACTION_POLICY_EVENT_CODE")}, name="POWER_ACTION_POLICY", pack=False, align=None), "SleepButtonAc": SimStruct({"Action": SimTypeInt(signed=False, label="POWER_ACTION"), "Flags": SimTypeInt(signed=False, label="UInt32"), "EventCode": SimTypeInt(signed=False, label="POWER_ACTION_POLICY_EVENT_CODE")}, name="POWER_ACTION_POLICY", pack=False, align=None), "SleepButtonDc": SimStruct({"Action": SimTypeInt(signed=False, label="POWER_ACTION"), "Flags": SimTypeInt(signed=False, label="UInt32"), "EventCode": SimTypeInt(signed=False, label="POWER_ACTION_POLICY_EVENT_CODE")}, name="POWER_ACTION_POLICY", pack=False, align=None), "LidCloseAc": SimStruct({"Action": SimTypeInt(signed=False, label="POWER_ACTION"), "Flags": SimTypeInt(signed=False, label="UInt32"), "EventCode": SimTypeInt(signed=False, label="POWER_ACTION_POLICY_EVENT_CODE")}, name="POWER_ACTION_POLICY", pack=False, align=None), "LidCloseDc": SimStruct({"Action": SimTypeInt(signed=False, label="POWER_ACTION"), "Flags": SimTypeInt(signed=False, label="UInt32"), "EventCode": SimTypeInt(signed=False, label="POWER_ACTION_POLICY_EVENT_CODE")}, name="POWER_ACTION_POLICY", pack=False, align=None), "DischargePolicy": SimTypeFixedSizeArray(SimStruct({"Enable": SimTypeChar(label="Byte"), "Spare": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "BatteryLevel": SimTypeInt(signed=False, label="UInt32"), "PowerPolicy": SimStruct({"Action": SimTypeInt(signed=False, label="POWER_ACTION"), "Flags": SimTypeInt(signed=False, label="UInt32"), "EventCode": SimTypeInt(signed=False, label="POWER_ACTION_POLICY_EVENT_CODE")}, name="POWER_ACTION_POLICY", pack=False, align=None), "MinSystemState": SimTypeInt(signed=False, label="SYSTEM_POWER_STATE")}, name="SYSTEM_POWER_LEVEL", pack=False, align=None), 4), "GlobalFlags": SimTypeInt(signed=False, label="UInt32")}, name="GLOBAL_USER_POWER_POLICY", pack=False, align=None), "mach": SimStruct({"Revision": SimTypeInt(signed=False, label="UInt32"), "LidOpenWakeAc": SimTypeInt(signed=False, label="SYSTEM_POWER_STATE"), "LidOpenWakeDc": SimTypeInt(signed=False, label="SYSTEM_POWER_STATE"), "BroadcastCapacityResolution": SimTypeInt(signed=False, label="UInt32")}, name="GLOBAL_MACHINE_POWER_POLICY", pack=False, align=None)}, name="GLOBAL_POWER_POLICY", pack=False, align=None), offset=0)], SimTypeChar(label="Byte"), arg_names=["pGlobalPowerPolicy"]),
        #
        'ReadPwrScheme': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"user": SimStruct({"Revision": SimTypeInt(signed=False, label="UInt32"), "IdleAc": SimStruct({"Action": SimTypeInt(signed=False, label="POWER_ACTION"), "Flags": SimTypeInt(signed=False, label="UInt32"), "EventCode": SimTypeInt(signed=False, label="POWER_ACTION_POLICY_EVENT_CODE")}, name="POWER_ACTION_POLICY", pack=False, align=None), "IdleDc": SimStruct({"Action": SimTypeInt(signed=False, label="POWER_ACTION"), "Flags": SimTypeInt(signed=False, label="UInt32"), "EventCode": SimTypeInt(signed=False, label="POWER_ACTION_POLICY_EVENT_CODE")}, name="POWER_ACTION_POLICY", pack=False, align=None), "IdleTimeoutAc": SimTypeInt(signed=False, label="UInt32"), "IdleTimeoutDc": SimTypeInt(signed=False, label="UInt32"), "IdleSensitivityAc": SimTypeChar(label="Byte"), "IdleSensitivityDc": SimTypeChar(label="Byte"), "ThrottlePolicyAc": SimTypeChar(label="Byte"), "ThrottlePolicyDc": SimTypeChar(label="Byte"), "MaxSleepAc": SimTypeInt(signed=False, label="SYSTEM_POWER_STATE"), "MaxSleepDc": SimTypeInt(signed=False, label="SYSTEM_POWER_STATE"), "Reserved": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 2), "VideoTimeoutAc": SimTypeInt(signed=False, label="UInt32"), "VideoTimeoutDc": SimTypeInt(signed=False, label="UInt32"), "SpindownTimeoutAc": SimTypeInt(signed=False, label="UInt32"), "SpindownTimeoutDc": SimTypeInt(signed=False, label="UInt32"), "OptimizeForPowerAc": SimTypeChar(label="Byte"), "OptimizeForPowerDc": SimTypeChar(label="Byte"), "FanThrottleToleranceAc": SimTypeChar(label="Byte"), "FanThrottleToleranceDc": SimTypeChar(label="Byte"), "ForcedThrottleAc": SimTypeChar(label="Byte"), "ForcedThrottleDc": SimTypeChar(label="Byte")}, name="USER_POWER_POLICY", pack=False, align=None), "mach": SimStruct({"Revision": SimTypeInt(signed=False, label="UInt32"), "MinSleepAc": SimTypeInt(signed=False, label="SYSTEM_POWER_STATE"), "MinSleepDc": SimTypeInt(signed=False, label="SYSTEM_POWER_STATE"), "ReducedLatencySleepAc": SimTypeInt(signed=False, label="SYSTEM_POWER_STATE"), "ReducedLatencySleepDc": SimTypeInt(signed=False, label="SYSTEM_POWER_STATE"), "DozeTimeoutAc": SimTypeInt(signed=False, label="UInt32"), "DozeTimeoutDc": SimTypeInt(signed=False, label="UInt32"), "DozeS4TimeoutAc": SimTypeInt(signed=False, label="UInt32"), "DozeS4TimeoutDc": SimTypeInt(signed=False, label="UInt32"), "MinThrottleAc": SimTypeChar(label="Byte"), "MinThrottleDc": SimTypeChar(label="Byte"), "pad1": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "OverThrottledAc": SimStruct({"Action": SimTypeInt(signed=False, label="POWER_ACTION"), "Flags": SimTypeInt(signed=False, label="UInt32"), "EventCode": SimTypeInt(signed=False, label="POWER_ACTION_POLICY_EVENT_CODE")}, name="POWER_ACTION_POLICY", pack=False, align=None), "OverThrottledDc": SimStruct({"Action": SimTypeInt(signed=False, label="POWER_ACTION"), "Flags": SimTypeInt(signed=False, label="UInt32"), "EventCode": SimTypeInt(signed=False, label="POWER_ACTION_POLICY_EVENT_CODE")}, name="POWER_ACTION_POLICY", pack=False, align=None)}, name="MACHINE_POWER_POLICY", pack=False, align=None)}, name="POWER_POLICY", pack=False, align=None), offset=0)], SimTypeChar(label="Byte"), arg_names=["uiID", "pPowerPolicy"]),
        #
        'WritePwrScheme': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"user": SimStruct({"Revision": SimTypeInt(signed=False, label="UInt32"), "IdleAc": SimStruct({"Action": SimTypeInt(signed=False, label="POWER_ACTION"), "Flags": SimTypeInt(signed=False, label="UInt32"), "EventCode": SimTypeInt(signed=False, label="POWER_ACTION_POLICY_EVENT_CODE")}, name="POWER_ACTION_POLICY", pack=False, align=None), "IdleDc": SimStruct({"Action": SimTypeInt(signed=False, label="POWER_ACTION"), "Flags": SimTypeInt(signed=False, label="UInt32"), "EventCode": SimTypeInt(signed=False, label="POWER_ACTION_POLICY_EVENT_CODE")}, name="POWER_ACTION_POLICY", pack=False, align=None), "IdleTimeoutAc": SimTypeInt(signed=False, label="UInt32"), "IdleTimeoutDc": SimTypeInt(signed=False, label="UInt32"), "IdleSensitivityAc": SimTypeChar(label="Byte"), "IdleSensitivityDc": SimTypeChar(label="Byte"), "ThrottlePolicyAc": SimTypeChar(label="Byte"), "ThrottlePolicyDc": SimTypeChar(label="Byte"), "MaxSleepAc": SimTypeInt(signed=False, label="SYSTEM_POWER_STATE"), "MaxSleepDc": SimTypeInt(signed=False, label="SYSTEM_POWER_STATE"), "Reserved": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 2), "VideoTimeoutAc": SimTypeInt(signed=False, label="UInt32"), "VideoTimeoutDc": SimTypeInt(signed=False, label="UInt32"), "SpindownTimeoutAc": SimTypeInt(signed=False, label="UInt32"), "SpindownTimeoutDc": SimTypeInt(signed=False, label="UInt32"), "OptimizeForPowerAc": SimTypeChar(label="Byte"), "OptimizeForPowerDc": SimTypeChar(label="Byte"), "FanThrottleToleranceAc": SimTypeChar(label="Byte"), "FanThrottleToleranceDc": SimTypeChar(label="Byte"), "ForcedThrottleAc": SimTypeChar(label="Byte"), "ForcedThrottleDc": SimTypeChar(label="Byte")}, name="USER_POWER_POLICY", pack=False, align=None), "mach": SimStruct({"Revision": SimTypeInt(signed=False, label="UInt32"), "MinSleepAc": SimTypeInt(signed=False, label="SYSTEM_POWER_STATE"), "MinSleepDc": SimTypeInt(signed=False, label="SYSTEM_POWER_STATE"), "ReducedLatencySleepAc": SimTypeInt(signed=False, label="SYSTEM_POWER_STATE"), "ReducedLatencySleepDc": SimTypeInt(signed=False, label="SYSTEM_POWER_STATE"), "DozeTimeoutAc": SimTypeInt(signed=False, label="UInt32"), "DozeTimeoutDc": SimTypeInt(signed=False, label="UInt32"), "DozeS4TimeoutAc": SimTypeInt(signed=False, label="UInt32"), "DozeS4TimeoutDc": SimTypeInt(signed=False, label="UInt32"), "MinThrottleAc": SimTypeChar(label="Byte"), "MinThrottleDc": SimTypeChar(label="Byte"), "pad1": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "OverThrottledAc": SimStruct({"Action": SimTypeInt(signed=False, label="POWER_ACTION"), "Flags": SimTypeInt(signed=False, label="UInt32"), "EventCode": SimTypeInt(signed=False, label="POWER_ACTION_POLICY_EVENT_CODE")}, name="POWER_ACTION_POLICY", pack=False, align=None), "OverThrottledDc": SimStruct({"Action": SimTypeInt(signed=False, label="POWER_ACTION"), "Flags": SimTypeInt(signed=False, label="UInt32"), "EventCode": SimTypeInt(signed=False, label="POWER_ACTION_POLICY_EVENT_CODE")}, name="POWER_ACTION_POLICY", pack=False, align=None)}, name="MACHINE_POWER_POLICY", pack=False, align=None)}, name="POWER_POLICY", pack=False, align=None), offset=0)], SimTypeChar(label="Byte"), arg_names=["puiID", "lpszSchemeName", "lpszDescription", "lpScheme"]),
        #
        'WriteGlobalPwrPolicy': SimTypeFunction([SimTypePointer(SimStruct({"user": SimStruct({"Revision": SimTypeInt(signed=False, label="UInt32"), "PowerButtonAc": SimStruct({"Action": SimTypeInt(signed=False, label="POWER_ACTION"), "Flags": SimTypeInt(signed=False, label="UInt32"), "EventCode": SimTypeInt(signed=False, label="POWER_ACTION_POLICY_EVENT_CODE")}, name="POWER_ACTION_POLICY", pack=False, align=None), "PowerButtonDc": SimStruct({"Action": SimTypeInt(signed=False, label="POWER_ACTION"), "Flags": SimTypeInt(signed=False, label="UInt32"), "EventCode": SimTypeInt(signed=False, label="POWER_ACTION_POLICY_EVENT_CODE")}, name="POWER_ACTION_POLICY", pack=False, align=None), "SleepButtonAc": SimStruct({"Action": SimTypeInt(signed=False, label="POWER_ACTION"), "Flags": SimTypeInt(signed=False, label="UInt32"), "EventCode": SimTypeInt(signed=False, label="POWER_ACTION_POLICY_EVENT_CODE")}, name="POWER_ACTION_POLICY", pack=False, align=None), "SleepButtonDc": SimStruct({"Action": SimTypeInt(signed=False, label="POWER_ACTION"), "Flags": SimTypeInt(signed=False, label="UInt32"), "EventCode": SimTypeInt(signed=False, label="POWER_ACTION_POLICY_EVENT_CODE")}, name="POWER_ACTION_POLICY", pack=False, align=None), "LidCloseAc": SimStruct({"Action": SimTypeInt(signed=False, label="POWER_ACTION"), "Flags": SimTypeInt(signed=False, label="UInt32"), "EventCode": SimTypeInt(signed=False, label="POWER_ACTION_POLICY_EVENT_CODE")}, name="POWER_ACTION_POLICY", pack=False, align=None), "LidCloseDc": SimStruct({"Action": SimTypeInt(signed=False, label="POWER_ACTION"), "Flags": SimTypeInt(signed=False, label="UInt32"), "EventCode": SimTypeInt(signed=False, label="POWER_ACTION_POLICY_EVENT_CODE")}, name="POWER_ACTION_POLICY", pack=False, align=None), "DischargePolicy": SimTypeFixedSizeArray(SimStruct({"Enable": SimTypeChar(label="Byte"), "Spare": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "BatteryLevel": SimTypeInt(signed=False, label="UInt32"), "PowerPolicy": SimStruct({"Action": SimTypeInt(signed=False, label="POWER_ACTION"), "Flags": SimTypeInt(signed=False, label="UInt32"), "EventCode": SimTypeInt(signed=False, label="POWER_ACTION_POLICY_EVENT_CODE")}, name="POWER_ACTION_POLICY", pack=False, align=None), "MinSystemState": SimTypeInt(signed=False, label="SYSTEM_POWER_STATE")}, name="SYSTEM_POWER_LEVEL", pack=False, align=None), 4), "GlobalFlags": SimTypeInt(signed=False, label="UInt32")}, name="GLOBAL_USER_POWER_POLICY", pack=False, align=None), "mach": SimStruct({"Revision": SimTypeInt(signed=False, label="UInt32"), "LidOpenWakeAc": SimTypeInt(signed=False, label="SYSTEM_POWER_STATE"), "LidOpenWakeDc": SimTypeInt(signed=False, label="SYSTEM_POWER_STATE"), "BroadcastCapacityResolution": SimTypeInt(signed=False, label="UInt32")}, name="GLOBAL_MACHINE_POWER_POLICY", pack=False, align=None)}, name="GLOBAL_POWER_POLICY", pack=False, align=None), offset=0)], SimTypeChar(label="Byte"), arg_names=["pGlobalPowerPolicy"]),
        #
        'DeletePwrScheme': SimTypeFunction([SimTypeInt(signed=False, label="UInt32")], SimTypeChar(label="Byte"), arg_names=["uiID"]),
        #
        'GetActivePwrScheme': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeChar(label="Byte"), arg_names=["puiID"]),
        #
        'SetActivePwrScheme': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"user": SimStruct({"Revision": SimTypeInt(signed=False, label="UInt32"), "PowerButtonAc": SimStruct({"Action": SimTypeInt(signed=False, label="POWER_ACTION"), "Flags": SimTypeInt(signed=False, label="UInt32"), "EventCode": SimTypeInt(signed=False, label="POWER_ACTION_POLICY_EVENT_CODE")}, name="POWER_ACTION_POLICY", pack=False, align=None), "PowerButtonDc": SimStruct({"Action": SimTypeInt(signed=False, label="POWER_ACTION"), "Flags": SimTypeInt(signed=False, label="UInt32"), "EventCode": SimTypeInt(signed=False, label="POWER_ACTION_POLICY_EVENT_CODE")}, name="POWER_ACTION_POLICY", pack=False, align=None), "SleepButtonAc": SimStruct({"Action": SimTypeInt(signed=False, label="POWER_ACTION"), "Flags": SimTypeInt(signed=False, label="UInt32"), "EventCode": SimTypeInt(signed=False, label="POWER_ACTION_POLICY_EVENT_CODE")}, name="POWER_ACTION_POLICY", pack=False, align=None), "SleepButtonDc": SimStruct({"Action": SimTypeInt(signed=False, label="POWER_ACTION"), "Flags": SimTypeInt(signed=False, label="UInt32"), "EventCode": SimTypeInt(signed=False, label="POWER_ACTION_POLICY_EVENT_CODE")}, name="POWER_ACTION_POLICY", pack=False, align=None), "LidCloseAc": SimStruct({"Action": SimTypeInt(signed=False, label="POWER_ACTION"), "Flags": SimTypeInt(signed=False, label="UInt32"), "EventCode": SimTypeInt(signed=False, label="POWER_ACTION_POLICY_EVENT_CODE")}, name="POWER_ACTION_POLICY", pack=False, align=None), "LidCloseDc": SimStruct({"Action": SimTypeInt(signed=False, label="POWER_ACTION"), "Flags": SimTypeInt(signed=False, label="UInt32"), "EventCode": SimTypeInt(signed=False, label="POWER_ACTION_POLICY_EVENT_CODE")}, name="POWER_ACTION_POLICY", pack=False, align=None), "DischargePolicy": SimTypeFixedSizeArray(SimStruct({"Enable": SimTypeChar(label="Byte"), "Spare": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "BatteryLevel": SimTypeInt(signed=False, label="UInt32"), "PowerPolicy": SimStruct({"Action": SimTypeInt(signed=False, label="POWER_ACTION"), "Flags": SimTypeInt(signed=False, label="UInt32"), "EventCode": SimTypeInt(signed=False, label="POWER_ACTION_POLICY_EVENT_CODE")}, name="POWER_ACTION_POLICY", pack=False, align=None), "MinSystemState": SimTypeInt(signed=False, label="SYSTEM_POWER_STATE")}, name="SYSTEM_POWER_LEVEL", pack=False, align=None), 4), "GlobalFlags": SimTypeInt(signed=False, label="UInt32")}, name="GLOBAL_USER_POWER_POLICY", pack=False, align=None), "mach": SimStruct({"Revision": SimTypeInt(signed=False, label="UInt32"), "LidOpenWakeAc": SimTypeInt(signed=False, label="SYSTEM_POWER_STATE"), "LidOpenWakeDc": SimTypeInt(signed=False, label="SYSTEM_POWER_STATE"), "BroadcastCapacityResolution": SimTypeInt(signed=False, label="UInt32")}, name="GLOBAL_MACHINE_POWER_POLICY", pack=False, align=None)}, name="GLOBAL_POWER_POLICY", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"user": SimStruct({"Revision": SimTypeInt(signed=False, label="UInt32"), "IdleAc": SimStruct({"Action": SimTypeInt(signed=False, label="POWER_ACTION"), "Flags": SimTypeInt(signed=False, label="UInt32"), "EventCode": SimTypeInt(signed=False, label="POWER_ACTION_POLICY_EVENT_CODE")}, name="POWER_ACTION_POLICY", pack=False, align=None), "IdleDc": SimStruct({"Action": SimTypeInt(signed=False, label="POWER_ACTION"), "Flags": SimTypeInt(signed=False, label="UInt32"), "EventCode": SimTypeInt(signed=False, label="POWER_ACTION_POLICY_EVENT_CODE")}, name="POWER_ACTION_POLICY", pack=False, align=None), "IdleTimeoutAc": SimTypeInt(signed=False, label="UInt32"), "IdleTimeoutDc": SimTypeInt(signed=False, label="UInt32"), "IdleSensitivityAc": SimTypeChar(label="Byte"), "IdleSensitivityDc": SimTypeChar(label="Byte"), "ThrottlePolicyAc": SimTypeChar(label="Byte"), "ThrottlePolicyDc": SimTypeChar(label="Byte"), "MaxSleepAc": SimTypeInt(signed=False, label="SYSTEM_POWER_STATE"), "MaxSleepDc": SimTypeInt(signed=False, label="SYSTEM_POWER_STATE"), "Reserved": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 2), "VideoTimeoutAc": SimTypeInt(signed=False, label="UInt32"), "VideoTimeoutDc": SimTypeInt(signed=False, label="UInt32"), "SpindownTimeoutAc": SimTypeInt(signed=False, label="UInt32"), "SpindownTimeoutDc": SimTypeInt(signed=False, label="UInt32"), "OptimizeForPowerAc": SimTypeChar(label="Byte"), "OptimizeForPowerDc": SimTypeChar(label="Byte"), "FanThrottleToleranceAc": SimTypeChar(label="Byte"), "FanThrottleToleranceDc": SimTypeChar(label="Byte"), "ForcedThrottleAc": SimTypeChar(label="Byte"), "ForcedThrottleDc": SimTypeChar(label="Byte")}, name="USER_POWER_POLICY", pack=False, align=None), "mach": SimStruct({"Revision": SimTypeInt(signed=False, label="UInt32"), "MinSleepAc": SimTypeInt(signed=False, label="SYSTEM_POWER_STATE"), "MinSleepDc": SimTypeInt(signed=False, label="SYSTEM_POWER_STATE"), "ReducedLatencySleepAc": SimTypeInt(signed=False, label="SYSTEM_POWER_STATE"), "ReducedLatencySleepDc": SimTypeInt(signed=False, label="SYSTEM_POWER_STATE"), "DozeTimeoutAc": SimTypeInt(signed=False, label="UInt32"), "DozeTimeoutDc": SimTypeInt(signed=False, label="UInt32"), "DozeS4TimeoutAc": SimTypeInt(signed=False, label="UInt32"), "DozeS4TimeoutDc": SimTypeInt(signed=False, label="UInt32"), "MinThrottleAc": SimTypeChar(label="Byte"), "MinThrottleDc": SimTypeChar(label="Byte"), "pad1": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "OverThrottledAc": SimStruct({"Action": SimTypeInt(signed=False, label="POWER_ACTION"), "Flags": SimTypeInt(signed=False, label="UInt32"), "EventCode": SimTypeInt(signed=False, label="POWER_ACTION_POLICY_EVENT_CODE")}, name="POWER_ACTION_POLICY", pack=False, align=None), "OverThrottledDc": SimStruct({"Action": SimTypeInt(signed=False, label="POWER_ACTION"), "Flags": SimTypeInt(signed=False, label="UInt32"), "EventCode": SimTypeInt(signed=False, label="POWER_ACTION_POLICY_EVENT_CODE")}, name="POWER_ACTION_POLICY", pack=False, align=None)}, name="MACHINE_POWER_POLICY", pack=False, align=None)}, name="POWER_POLICY", pack=False, align=None), offset=0)], SimTypeChar(label="Byte"), arg_names=["uiID", "pGlobalPowerPolicy", "pPowerPolicy"]),
        #
        'IsPwrSuspendAllowed': SimTypeFunction([], SimTypeChar(label="Byte")),
        #
        'IsPwrHibernateAllowed': SimTypeFunction([], SimTypeChar(label="Byte")),
        #
        'IsPwrShutdownAllowed': SimTypeFunction([], SimTypeChar(label="Byte")),
        #
        'IsAdminOverrideActive': SimTypeFunction([SimTypePointer(SimStruct({"MinSleep": SimTypeInt(signed=False, label="SYSTEM_POWER_STATE"), "MaxSleep": SimTypeInt(signed=False, label="SYSTEM_POWER_STATE"), "MinVideoTimeout": SimTypeInt(signed=False, label="UInt32"), "MaxVideoTimeout": SimTypeInt(signed=False, label="UInt32"), "MinSpindownTimeout": SimTypeInt(signed=False, label="UInt32"), "MaxSpindownTimeout": SimTypeInt(signed=False, label="UInt32")}, name="ADMINISTRATOR_POWER_POLICY", pack=False, align=None), offset=0)], SimTypeChar(label="Byte"), arg_names=["papp"]),
        #
        'SetSuspendState': SimTypeFunction([SimTypeChar(label="Byte"), SimTypeChar(label="Byte"), SimTypeChar(label="Byte")], SimTypeChar(label="Byte"), arg_names=["bHibernate", "bForce", "bWakeupEventsDisabled"]),
        #
        'GetCurrentPowerPolicies': SimTypeFunction([SimTypePointer(SimStruct({"user": SimStruct({"Revision": SimTypeInt(signed=False, label="UInt32"), "PowerButtonAc": SimStruct({"Action": SimTypeInt(signed=False, label="POWER_ACTION"), "Flags": SimTypeInt(signed=False, label="UInt32"), "EventCode": SimTypeInt(signed=False, label="POWER_ACTION_POLICY_EVENT_CODE")}, name="POWER_ACTION_POLICY", pack=False, align=None), "PowerButtonDc": SimStruct({"Action": SimTypeInt(signed=False, label="POWER_ACTION"), "Flags": SimTypeInt(signed=False, label="UInt32"), "EventCode": SimTypeInt(signed=False, label="POWER_ACTION_POLICY_EVENT_CODE")}, name="POWER_ACTION_POLICY", pack=False, align=None), "SleepButtonAc": SimStruct({"Action": SimTypeInt(signed=False, label="POWER_ACTION"), "Flags": SimTypeInt(signed=False, label="UInt32"), "EventCode": SimTypeInt(signed=False, label="POWER_ACTION_POLICY_EVENT_CODE")}, name="POWER_ACTION_POLICY", pack=False, align=None), "SleepButtonDc": SimStruct({"Action": SimTypeInt(signed=False, label="POWER_ACTION"), "Flags": SimTypeInt(signed=False, label="UInt32"), "EventCode": SimTypeInt(signed=False, label="POWER_ACTION_POLICY_EVENT_CODE")}, name="POWER_ACTION_POLICY", pack=False, align=None), "LidCloseAc": SimStruct({"Action": SimTypeInt(signed=False, label="POWER_ACTION"), "Flags": SimTypeInt(signed=False, label="UInt32"), "EventCode": SimTypeInt(signed=False, label="POWER_ACTION_POLICY_EVENT_CODE")}, name="POWER_ACTION_POLICY", pack=False, align=None), "LidCloseDc": SimStruct({"Action": SimTypeInt(signed=False, label="POWER_ACTION"), "Flags": SimTypeInt(signed=False, label="UInt32"), "EventCode": SimTypeInt(signed=False, label="POWER_ACTION_POLICY_EVENT_CODE")}, name="POWER_ACTION_POLICY", pack=False, align=None), "DischargePolicy": SimTypeFixedSizeArray(SimStruct({"Enable": SimTypeChar(label="Byte"), "Spare": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "BatteryLevel": SimTypeInt(signed=False, label="UInt32"), "PowerPolicy": SimStruct({"Action": SimTypeInt(signed=False, label="POWER_ACTION"), "Flags": SimTypeInt(signed=False, label="UInt32"), "EventCode": SimTypeInt(signed=False, label="POWER_ACTION_POLICY_EVENT_CODE")}, name="POWER_ACTION_POLICY", pack=False, align=None), "MinSystemState": SimTypeInt(signed=False, label="SYSTEM_POWER_STATE")}, name="SYSTEM_POWER_LEVEL", pack=False, align=None), 4), "GlobalFlags": SimTypeInt(signed=False, label="UInt32")}, name="GLOBAL_USER_POWER_POLICY", pack=False, align=None), "mach": SimStruct({"Revision": SimTypeInt(signed=False, label="UInt32"), "LidOpenWakeAc": SimTypeInt(signed=False, label="SYSTEM_POWER_STATE"), "LidOpenWakeDc": SimTypeInt(signed=False, label="SYSTEM_POWER_STATE"), "BroadcastCapacityResolution": SimTypeInt(signed=False, label="UInt32")}, name="GLOBAL_MACHINE_POWER_POLICY", pack=False, align=None)}, name="GLOBAL_POWER_POLICY", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"user": SimStruct({"Revision": SimTypeInt(signed=False, label="UInt32"), "IdleAc": SimStruct({"Action": SimTypeInt(signed=False, label="POWER_ACTION"), "Flags": SimTypeInt(signed=False, label="UInt32"), "EventCode": SimTypeInt(signed=False, label="POWER_ACTION_POLICY_EVENT_CODE")}, name="POWER_ACTION_POLICY", pack=False, align=None), "IdleDc": SimStruct({"Action": SimTypeInt(signed=False, label="POWER_ACTION"), "Flags": SimTypeInt(signed=False, label="UInt32"), "EventCode": SimTypeInt(signed=False, label="POWER_ACTION_POLICY_EVENT_CODE")}, name="POWER_ACTION_POLICY", pack=False, align=None), "IdleTimeoutAc": SimTypeInt(signed=False, label="UInt32"), "IdleTimeoutDc": SimTypeInt(signed=False, label="UInt32"), "IdleSensitivityAc": SimTypeChar(label="Byte"), "IdleSensitivityDc": SimTypeChar(label="Byte"), "ThrottlePolicyAc": SimTypeChar(label="Byte"), "ThrottlePolicyDc": SimTypeChar(label="Byte"), "MaxSleepAc": SimTypeInt(signed=False, label="SYSTEM_POWER_STATE"), "MaxSleepDc": SimTypeInt(signed=False, label="SYSTEM_POWER_STATE"), "Reserved": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 2), "VideoTimeoutAc": SimTypeInt(signed=False, label="UInt32"), "VideoTimeoutDc": SimTypeInt(signed=False, label="UInt32"), "SpindownTimeoutAc": SimTypeInt(signed=False, label="UInt32"), "SpindownTimeoutDc": SimTypeInt(signed=False, label="UInt32"), "OptimizeForPowerAc": SimTypeChar(label="Byte"), "OptimizeForPowerDc": SimTypeChar(label="Byte"), "FanThrottleToleranceAc": SimTypeChar(label="Byte"), "FanThrottleToleranceDc": SimTypeChar(label="Byte"), "ForcedThrottleAc": SimTypeChar(label="Byte"), "ForcedThrottleDc": SimTypeChar(label="Byte")}, name="USER_POWER_POLICY", pack=False, align=None), "mach": SimStruct({"Revision": SimTypeInt(signed=False, label="UInt32"), "MinSleepAc": SimTypeInt(signed=False, label="SYSTEM_POWER_STATE"), "MinSleepDc": SimTypeInt(signed=False, label="SYSTEM_POWER_STATE"), "ReducedLatencySleepAc": SimTypeInt(signed=False, label="SYSTEM_POWER_STATE"), "ReducedLatencySleepDc": SimTypeInt(signed=False, label="SYSTEM_POWER_STATE"), "DozeTimeoutAc": SimTypeInt(signed=False, label="UInt32"), "DozeTimeoutDc": SimTypeInt(signed=False, label="UInt32"), "DozeS4TimeoutAc": SimTypeInt(signed=False, label="UInt32"), "DozeS4TimeoutDc": SimTypeInt(signed=False, label="UInt32"), "MinThrottleAc": SimTypeChar(label="Byte"), "MinThrottleDc": SimTypeChar(label="Byte"), "pad1": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "OverThrottledAc": SimStruct({"Action": SimTypeInt(signed=False, label="POWER_ACTION"), "Flags": SimTypeInt(signed=False, label="UInt32"), "EventCode": SimTypeInt(signed=False, label="POWER_ACTION_POLICY_EVENT_CODE")}, name="POWER_ACTION_POLICY", pack=False, align=None), "OverThrottledDc": SimStruct({"Action": SimTypeInt(signed=False, label="POWER_ACTION"), "Flags": SimTypeInt(signed=False, label="UInt32"), "EventCode": SimTypeInt(signed=False, label="POWER_ACTION_POLICY_EVENT_CODE")}, name="POWER_ACTION_POLICY", pack=False, align=None)}, name="MACHINE_POWER_POLICY", pack=False, align=None)}, name="POWER_POLICY", pack=False, align=None), offset=0)], SimTypeChar(label="Byte"), arg_names=["pGlobalPowerPolicy", "pPowerPolicy"]),
        #
        'CanUserWritePwrScheme': SimTypeFunction([], SimTypeChar(label="Byte")),
        #
        'ReadProcessorPwrScheme': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Revision": SimTypeInt(signed=False, label="UInt32"), "ProcessorPolicyAc": SimStruct({"Revision": SimTypeInt(signed=False, label="UInt32"), "DynamicThrottle": SimTypeChar(label="Byte"), "Spare": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "_bitfield": SimTypeInt(signed=False, label="UInt32"), "PolicyCount": SimTypeInt(signed=False, label="UInt32"), "Policy": SimTypeFixedSizeArray(SimStruct({"TimeCheck": SimTypeInt(signed=False, label="UInt32"), "DemoteLimit": SimTypeInt(signed=False, label="UInt32"), "PromoteLimit": SimTypeInt(signed=False, label="UInt32"), "DemotePercent": SimTypeChar(label="Byte"), "PromotePercent": SimTypeChar(label="Byte"), "Spare": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="PROCESSOR_POWER_POLICY_INFO", pack=False, align=None), 3)}, name="PROCESSOR_POWER_POLICY", pack=False, align=None), "ProcessorPolicyDc": SimStruct({"Revision": SimTypeInt(signed=False, label="UInt32"), "DynamicThrottle": SimTypeChar(label="Byte"), "Spare": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "_bitfield": SimTypeInt(signed=False, label="UInt32"), "PolicyCount": SimTypeInt(signed=False, label="UInt32"), "Policy": SimTypeFixedSizeArray(SimStruct({"TimeCheck": SimTypeInt(signed=False, label="UInt32"), "DemoteLimit": SimTypeInt(signed=False, label="UInt32"), "PromoteLimit": SimTypeInt(signed=False, label="UInt32"), "DemotePercent": SimTypeChar(label="Byte"), "PromotePercent": SimTypeChar(label="Byte"), "Spare": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="PROCESSOR_POWER_POLICY_INFO", pack=False, align=None), 3)}, name="PROCESSOR_POWER_POLICY", pack=False, align=None)}, name="MACHINE_PROCESSOR_POWER_POLICY", pack=False, align=None), offset=0)], SimTypeChar(label="Byte"), arg_names=["uiID", "pMachineProcessorPowerPolicy"]),
        #
        'WriteProcessorPwrScheme': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Revision": SimTypeInt(signed=False, label="UInt32"), "ProcessorPolicyAc": SimStruct({"Revision": SimTypeInt(signed=False, label="UInt32"), "DynamicThrottle": SimTypeChar(label="Byte"), "Spare": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "_bitfield": SimTypeInt(signed=False, label="UInt32"), "PolicyCount": SimTypeInt(signed=False, label="UInt32"), "Policy": SimTypeFixedSizeArray(SimStruct({"TimeCheck": SimTypeInt(signed=False, label="UInt32"), "DemoteLimit": SimTypeInt(signed=False, label="UInt32"), "PromoteLimit": SimTypeInt(signed=False, label="UInt32"), "DemotePercent": SimTypeChar(label="Byte"), "PromotePercent": SimTypeChar(label="Byte"), "Spare": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="PROCESSOR_POWER_POLICY_INFO", pack=False, align=None), 3)}, name="PROCESSOR_POWER_POLICY", pack=False, align=None), "ProcessorPolicyDc": SimStruct({"Revision": SimTypeInt(signed=False, label="UInt32"), "DynamicThrottle": SimTypeChar(label="Byte"), "Spare": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "_bitfield": SimTypeInt(signed=False, label="UInt32"), "PolicyCount": SimTypeInt(signed=False, label="UInt32"), "Policy": SimTypeFixedSizeArray(SimStruct({"TimeCheck": SimTypeInt(signed=False, label="UInt32"), "DemoteLimit": SimTypeInt(signed=False, label="UInt32"), "PromoteLimit": SimTypeInt(signed=False, label="UInt32"), "DemotePercent": SimTypeChar(label="Byte"), "PromotePercent": SimTypeChar(label="Byte"), "Spare": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="PROCESSOR_POWER_POLICY_INFO", pack=False, align=None), 3)}, name="PROCESSOR_POWER_POLICY", pack=False, align=None)}, name="MACHINE_PROCESSOR_POWER_POLICY", pack=False, align=None), offset=0)], SimTypeChar(label="Byte"), arg_names=["uiID", "pMachineProcessorPowerPolicy"]),
        #
        'ValidatePowerPolicies': SimTypeFunction([SimTypePointer(SimStruct({"user": SimStruct({"Revision": SimTypeInt(signed=False, label="UInt32"), "PowerButtonAc": SimStruct({"Action": SimTypeInt(signed=False, label="POWER_ACTION"), "Flags": SimTypeInt(signed=False, label="UInt32"), "EventCode": SimTypeInt(signed=False, label="POWER_ACTION_POLICY_EVENT_CODE")}, name="POWER_ACTION_POLICY", pack=False, align=None), "PowerButtonDc": SimStruct({"Action": SimTypeInt(signed=False, label="POWER_ACTION"), "Flags": SimTypeInt(signed=False, label="UInt32"), "EventCode": SimTypeInt(signed=False, label="POWER_ACTION_POLICY_EVENT_CODE")}, name="POWER_ACTION_POLICY", pack=False, align=None), "SleepButtonAc": SimStruct({"Action": SimTypeInt(signed=False, label="POWER_ACTION"), "Flags": SimTypeInt(signed=False, label="UInt32"), "EventCode": SimTypeInt(signed=False, label="POWER_ACTION_POLICY_EVENT_CODE")}, name="POWER_ACTION_POLICY", pack=False, align=None), "SleepButtonDc": SimStruct({"Action": SimTypeInt(signed=False, label="POWER_ACTION"), "Flags": SimTypeInt(signed=False, label="UInt32"), "EventCode": SimTypeInt(signed=False, label="POWER_ACTION_POLICY_EVENT_CODE")}, name="POWER_ACTION_POLICY", pack=False, align=None), "LidCloseAc": SimStruct({"Action": SimTypeInt(signed=False, label="POWER_ACTION"), "Flags": SimTypeInt(signed=False, label="UInt32"), "EventCode": SimTypeInt(signed=False, label="POWER_ACTION_POLICY_EVENT_CODE")}, name="POWER_ACTION_POLICY", pack=False, align=None), "LidCloseDc": SimStruct({"Action": SimTypeInt(signed=False, label="POWER_ACTION"), "Flags": SimTypeInt(signed=False, label="UInt32"), "EventCode": SimTypeInt(signed=False, label="POWER_ACTION_POLICY_EVENT_CODE")}, name="POWER_ACTION_POLICY", pack=False, align=None), "DischargePolicy": SimTypeFixedSizeArray(SimStruct({"Enable": SimTypeChar(label="Byte"), "Spare": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "BatteryLevel": SimTypeInt(signed=False, label="UInt32"), "PowerPolicy": SimStruct({"Action": SimTypeInt(signed=False, label="POWER_ACTION"), "Flags": SimTypeInt(signed=False, label="UInt32"), "EventCode": SimTypeInt(signed=False, label="POWER_ACTION_POLICY_EVENT_CODE")}, name="POWER_ACTION_POLICY", pack=False, align=None), "MinSystemState": SimTypeInt(signed=False, label="SYSTEM_POWER_STATE")}, name="SYSTEM_POWER_LEVEL", pack=False, align=None), 4), "GlobalFlags": SimTypeInt(signed=False, label="UInt32")}, name="GLOBAL_USER_POWER_POLICY", pack=False, align=None), "mach": SimStruct({"Revision": SimTypeInt(signed=False, label="UInt32"), "LidOpenWakeAc": SimTypeInt(signed=False, label="SYSTEM_POWER_STATE"), "LidOpenWakeDc": SimTypeInt(signed=False, label="SYSTEM_POWER_STATE"), "BroadcastCapacityResolution": SimTypeInt(signed=False, label="UInt32")}, name="GLOBAL_MACHINE_POWER_POLICY", pack=False, align=None)}, name="GLOBAL_POWER_POLICY", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"user": SimStruct({"Revision": SimTypeInt(signed=False, label="UInt32"), "IdleAc": SimStruct({"Action": SimTypeInt(signed=False, label="POWER_ACTION"), "Flags": SimTypeInt(signed=False, label="UInt32"), "EventCode": SimTypeInt(signed=False, label="POWER_ACTION_POLICY_EVENT_CODE")}, name="POWER_ACTION_POLICY", pack=False, align=None), "IdleDc": SimStruct({"Action": SimTypeInt(signed=False, label="POWER_ACTION"), "Flags": SimTypeInt(signed=False, label="UInt32"), "EventCode": SimTypeInt(signed=False, label="POWER_ACTION_POLICY_EVENT_CODE")}, name="POWER_ACTION_POLICY", pack=False, align=None), "IdleTimeoutAc": SimTypeInt(signed=False, label="UInt32"), "IdleTimeoutDc": SimTypeInt(signed=False, label="UInt32"), "IdleSensitivityAc": SimTypeChar(label="Byte"), "IdleSensitivityDc": SimTypeChar(label="Byte"), "ThrottlePolicyAc": SimTypeChar(label="Byte"), "ThrottlePolicyDc": SimTypeChar(label="Byte"), "MaxSleepAc": SimTypeInt(signed=False, label="SYSTEM_POWER_STATE"), "MaxSleepDc": SimTypeInt(signed=False, label="SYSTEM_POWER_STATE"), "Reserved": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 2), "VideoTimeoutAc": SimTypeInt(signed=False, label="UInt32"), "VideoTimeoutDc": SimTypeInt(signed=False, label="UInt32"), "SpindownTimeoutAc": SimTypeInt(signed=False, label="UInt32"), "SpindownTimeoutDc": SimTypeInt(signed=False, label="UInt32"), "OptimizeForPowerAc": SimTypeChar(label="Byte"), "OptimizeForPowerDc": SimTypeChar(label="Byte"), "FanThrottleToleranceAc": SimTypeChar(label="Byte"), "FanThrottleToleranceDc": SimTypeChar(label="Byte"), "ForcedThrottleAc": SimTypeChar(label="Byte"), "ForcedThrottleDc": SimTypeChar(label="Byte")}, name="USER_POWER_POLICY", pack=False, align=None), "mach": SimStruct({"Revision": SimTypeInt(signed=False, label="UInt32"), "MinSleepAc": SimTypeInt(signed=False, label="SYSTEM_POWER_STATE"), "MinSleepDc": SimTypeInt(signed=False, label="SYSTEM_POWER_STATE"), "ReducedLatencySleepAc": SimTypeInt(signed=False, label="SYSTEM_POWER_STATE"), "ReducedLatencySleepDc": SimTypeInt(signed=False, label="SYSTEM_POWER_STATE"), "DozeTimeoutAc": SimTypeInt(signed=False, label="UInt32"), "DozeTimeoutDc": SimTypeInt(signed=False, label="UInt32"), "DozeS4TimeoutAc": SimTypeInt(signed=False, label="UInt32"), "DozeS4TimeoutDc": SimTypeInt(signed=False, label="UInt32"), "MinThrottleAc": SimTypeChar(label="Byte"), "MinThrottleDc": SimTypeChar(label="Byte"), "pad1": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 2), "OverThrottledAc": SimStruct({"Action": SimTypeInt(signed=False, label="POWER_ACTION"), "Flags": SimTypeInt(signed=False, label="UInt32"), "EventCode": SimTypeInt(signed=False, label="POWER_ACTION_POLICY_EVENT_CODE")}, name="POWER_ACTION_POLICY", pack=False, align=None), "OverThrottledDc": SimStruct({"Action": SimTypeInt(signed=False, label="POWER_ACTION"), "Flags": SimTypeInt(signed=False, label="UInt32"), "EventCode": SimTypeInt(signed=False, label="POWER_ACTION_POLICY_EVENT_CODE")}, name="POWER_ACTION_POLICY", pack=False, align=None)}, name="MACHINE_POWER_POLICY", pack=False, align=None)}, name="POWER_POLICY", pack=False, align=None), offset=0)], SimTypeChar(label="Byte"), arg_names=["pGlobalPowerPolicy", "pPowerPolicy"]),
        #
        'PowerIsSettingRangeDefined': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0)], SimTypeChar(label="Byte"), arg_names=["SubKeyGuid", "SettingGuid"]),
        #
        'PowerSettingAccessCheckEx': SimTypeFunction([SimTypeInt(signed=False, label="POWER_DATA_ACCESSOR"), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="REG_SAM_FLAGS")], SimTypeInt(signed=False, label="UInt32"), arg_names=["AccessFlags", "PowerGuid", "AccessType"]),
        #
        'PowerSettingAccessCheck': SimTypeFunction([SimTypeInt(signed=False, label="POWER_DATA_ACCESSOR"), SimTypePointer(SimTypeBottom(label="Guid"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["AccessFlags", "PowerGuid"]),
        #
        'PowerReadACValueIndex': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RootPowerKey", "SchemeGuid", "SubGroupOfPowerSettingsGuid", "PowerSettingGuid", "AcValueIndex"]),
        #
        'PowerReadDCValueIndex': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RootPowerKey", "SchemeGuid", "SubGroupOfPowerSettingsGuid", "PowerSettingGuid", "DcValueIndex"]),
        #
        'PowerReadFriendlyName': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RootPowerKey", "SchemeGuid", "SubGroupOfPowerSettingsGuid", "PowerSettingGuid", "Buffer", "BufferSize"]),
        #
        'PowerReadDescription': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RootPowerKey", "SchemeGuid", "SubGroupOfPowerSettingsGuid", "PowerSettingGuid", "Buffer", "BufferSize"]),
        #
        'PowerReadPossibleValue': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RootPowerKey", "SubGroupOfPowerSettingsGuid", "PowerSettingGuid", "Type", "PossibleSettingIndex", "Buffer", "BufferSize"]),
        #
        'PowerReadPossibleFriendlyName': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RootPowerKey", "SubGroupOfPowerSettingsGuid", "PowerSettingGuid", "PossibleSettingIndex", "Buffer", "BufferSize"]),
        #
        'PowerReadPossibleDescription': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RootPowerKey", "SubGroupOfPowerSettingsGuid", "PowerSettingGuid", "PossibleSettingIndex", "Buffer", "BufferSize"]),
        #
        'PowerReadValueMin': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RootPowerKey", "SubGroupOfPowerSettingsGuid", "PowerSettingGuid", "ValueMinimum"]),
        #
        'PowerReadValueMax': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RootPowerKey", "SubGroupOfPowerSettingsGuid", "PowerSettingGuid", "ValueMaximum"]),
        #
        'PowerReadValueIncrement': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RootPowerKey", "SubGroupOfPowerSettingsGuid", "PowerSettingGuid", "ValueIncrement"]),
        #
        'PowerReadValueUnitsSpecifier': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RootPowerKey", "SubGroupOfPowerSettingsGuid", "PowerSettingGuid", "Buffer", "BufferSize"]),
        #
        'PowerReadACDefaultIndex': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RootPowerKey", "SchemePersonalityGuid", "SubGroupOfPowerSettingsGuid", "PowerSettingGuid", "AcDefaultIndex"]),
        #
        'PowerReadDCDefaultIndex': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RootPowerKey", "SchemePersonalityGuid", "SubGroupOfPowerSettingsGuid", "PowerSettingGuid", "DcDefaultIndex"]),
        #
        'PowerReadIconResourceSpecifier': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RootPowerKey", "SchemeGuid", "SubGroupOfPowerSettingsGuid", "PowerSettingGuid", "Buffer", "BufferSize"]),
        #
        'PowerReadSettingAttributes': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["SubGroupGuid", "PowerSettingGuid"]),
        #
        'PowerWriteFriendlyName': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["RootPowerKey", "SchemeGuid", "SubGroupOfPowerSettingsGuid", "PowerSettingGuid", "Buffer", "BufferSize"]),
        #
        'PowerWriteDescription': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["RootPowerKey", "SchemeGuid", "SubGroupOfPowerSettingsGuid", "PowerSettingGuid", "Buffer", "BufferSize"]),
        #
        'PowerWritePossibleValue': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["RootPowerKey", "SubGroupOfPowerSettingsGuid", "PowerSettingGuid", "Type", "PossibleSettingIndex", "Buffer", "BufferSize"]),
        #
        'PowerWritePossibleFriendlyName': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["RootPowerKey", "SubGroupOfPowerSettingsGuid", "PowerSettingGuid", "PossibleSettingIndex", "Buffer", "BufferSize"]),
        #
        'PowerWritePossibleDescription': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["RootPowerKey", "SubGroupOfPowerSettingsGuid", "PowerSettingGuid", "PossibleSettingIndex", "Buffer", "BufferSize"]),
        #
        'PowerWriteValueMin': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["RootPowerKey", "SubGroupOfPowerSettingsGuid", "PowerSettingGuid", "ValueMinimum"]),
        #
        'PowerWriteValueMax': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["RootPowerKey", "SubGroupOfPowerSettingsGuid", "PowerSettingGuid", "ValueMaximum"]),
        #
        'PowerWriteValueIncrement': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["RootPowerKey", "SubGroupOfPowerSettingsGuid", "PowerSettingGuid", "ValueIncrement"]),
        #
        'PowerWriteValueUnitsSpecifier': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["RootPowerKey", "SubGroupOfPowerSettingsGuid", "PowerSettingGuid", "Buffer", "BufferSize"]),
        #
        'PowerWriteACDefaultIndex': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["RootSystemPowerKey", "SchemePersonalityGuid", "SubGroupOfPowerSettingsGuid", "PowerSettingGuid", "DefaultAcIndex"]),
        #
        'PowerWriteDCDefaultIndex': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["RootSystemPowerKey", "SchemePersonalityGuid", "SubGroupOfPowerSettingsGuid", "PowerSettingGuid", "DefaultDcIndex"]),
        #
        'PowerWriteIconResourceSpecifier': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["RootPowerKey", "SchemeGuid", "SubGroupOfPowerSettingsGuid", "PowerSettingGuid", "Buffer", "BufferSize"]),
        #
        'PowerWriteSettingAttributes': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["SubGroupGuid", "PowerSettingGuid", "Attributes"]),
        #
        'PowerDuplicateScheme': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Guid"), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RootPowerKey", "SourceSchemeGuid", "DestinationSchemeGuid"]),
        #
        'PowerImportPowerScheme': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Guid"), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RootPowerKey", "ImportFileNamePath", "DestinationSchemeGuid"]),
        #
        'PowerDeleteScheme': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RootPowerKey", "SchemeGuid"]),
        #
        'PowerRemovePowerSetting': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["PowerSettingSubKeyGuid", "PowerSettingGuid"]),
        #
        'PowerCreateSetting': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RootSystemPowerKey", "SubGroupOfPowerSettingsGuid", "PowerSettingGuid"]),
        #
        'PowerCreatePossibleSetting': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["RootSystemPowerKey", "SubGroupOfPowerSettingsGuid", "PowerSettingGuid", "PossibleSettingIndex"]),
        #
        'PowerEnumerate': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="POWER_DATA_ACCESSOR"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["RootPowerKey", "SchemeGuid", "SubGroupOfPowerSettingsGuid", "AccessFlags", "Index", "Buffer", "BufferSize"]),
        #
        'PowerOpenUserPowerKey': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["phUserPowerKey", "Access", "OpenExisting"]),
        #
        'PowerOpenSystemPowerKey': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=True, label="Int32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["phSystemPowerKey", "Access", "OpenExisting"]),
        #
        'PowerCanRestoreIndividualDefaultPowerScheme': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["SchemeGuid"]),
        #
        'PowerRestoreIndividualDefaultPowerScheme': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["SchemeGuid"]),
        #
        'PowerRestoreDefaultPowerSchemes': SimTypeFunction([], SimTypeInt(signed=False, label="UInt32")),
        #
        'PowerReplaceDefaultPowerSchemes': SimTypeFunction([], SimTypeInt(signed=False, label="UInt32")),
        #
        'PowerDeterminePlatformRole': SimTypeFunction([], SimTypeInt(signed=False, label="POWER_PLATFORM_ROLE")),
        #
        'DevicePowerEnumDevices': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeChar(label="Byte"), arg_names=["QueryIndex", "QueryInterpretationFlags", "QueryFlags", "pReturnBuffer", "pBufferSize"]),
        #
        'DevicePowerSetDeviceState': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["DeviceDescription", "SetFlags", "SetData"]),
        #
        'DevicePowerOpen': SimTypeFunction([SimTypeInt(signed=False, label="UInt32")], SimTypeChar(label="Byte"), arg_names=["DebugMask"]),
        #
        'DevicePowerClose': SimTypeFunction([], SimTypeChar(label="Byte")),
        #
        'PowerReportThermalEvent': SimTypeFunction([SimTypePointer(SimStruct({"Version": SimTypeInt(signed=False, label="UInt32"), "Size": SimTypeInt(signed=False, label="UInt32"), "Type": SimTypeInt(signed=False, label="UInt32"), "Temperature": SimTypeInt(signed=False, label="UInt32"), "TripPointTemperature": SimTypeInt(signed=False, label="UInt32"), "Initiator": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="THERMAL_EVENT", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["Event"]),
    }

lib.set_prototypes(prototypes)
