/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.tuple;

import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

public final class ImmutablePair<L, R>
extends Pair<L, R> {
    public static final ImmutablePair<?, ?>[] EMPTY_ARRAY = new ImmutablePair[0];
    private static final ImmutablePair NULL = ImmutablePair.of(null, null);
    private static final long serialVersionUID = 4954918890077093841L;
    public final L left;
    public final R right;

    public static <L, R> ImmutablePair<L, R>[] emptyArray() {
        return EMPTY_ARRAY;
    }

    public static <L, R> Pair<L, R> left(L left2) {
        return ImmutablePair.of(left2, null);
    }

    public static <L, R> ImmutablePair<L, R> nullPair() {
        return NULL;
    }

    public static <L, R> ImmutablePair<L, R> of(L left2, R right) {
        return new ImmutablePair<L, R>(left2, right);
    }

    public static <L, R> ImmutablePair<L, R> of(Map.Entry<L, R> pair) {
        R right;
        L left2;
        if (pair != null) {
            left2 = pair.getKey();
            right = pair.getValue();
        } else {
            left2 = null;
            right = null;
        }
        return new ImmutablePair<Object, Object>(left2, right);
    }

    public static <L, R> Pair<L, R> right(R right) {
        return ImmutablePair.of(null, right);
    }

    public ImmutablePair(L left2, R right) {
        this.left = left2;
        this.right = right;
    }

    @Override
    public L getLeft() {
        return this.left;
    }

    @Override
    public R getRight() {
        return this.right;
    }

    @Override
    public R setValue(R value2) {
        throw new UnsupportedOperationException();
    }
}

