/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import java.util.concurrent.CompletableFuture;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.InvocationCallback;
import org.infinispan.interceptors.InvocationExceptionFunction;
import org.infinispan.interceptors.InvocationFinallyAction;
import org.infinispan.interceptors.InvocationFinallyFunction;
import org.infinispan.interceptors.InvocationSuccessAction;
import org.infinispan.interceptors.InvocationSuccessFunction;
import org.infinispan.interceptors.SyncInvocationStage;

public abstract class InvocationStage {
    public abstract Object get() throws Throwable;

    public abstract boolean isDone();

    public abstract CompletableFuture<Object> toCompletableFuture();

    public <C extends VisitableCommand> Object thenApply(InvocationContext ctx, C command, InvocationSuccessFunction<C> function) {
        return this.addCallback(ctx, command, function);
    }

    public <C extends VisitableCommand> Object thenAccept(InvocationContext ctx, C command, InvocationSuccessAction<C> action) {
        return this.addCallback(ctx, command, action);
    }

    public <C extends VisitableCommand> Object andExceptionally(InvocationContext ctx, C command, InvocationExceptionFunction<C> function) {
        return this.addCallback(ctx, command, function);
    }

    public <C extends VisitableCommand> Object andFinally(InvocationContext ctx, C command, InvocationFinallyAction<C> action) {
        return this.addCallback(ctx, command, action);
    }

    public <C extends VisitableCommand> Object andHandle(InvocationContext ctx, C command, InvocationFinallyFunction<C> function) {
        return this.addCallback(ctx, command, function);
    }

    public abstract <C extends VisitableCommand> Object addCallback(InvocationContext var1, C var2, InvocationCallback<C> var3);

    public <C extends VisitableCommand> InvocationStage thenApplyMakeStage(InvocationContext ctx, C command, InvocationSuccessFunction<C> function) {
        return InvocationStage.makeStage(this.thenApply(ctx, command, function));
    }

    public <C extends VisitableCommand> InvocationStage thenAcceptMakeStage(InvocationContext ctx, C command, InvocationSuccessAction<C> action) {
        return InvocationStage.makeStage(this.thenAccept(ctx, command, action));
    }

    public <C extends VisitableCommand> InvocationStage andExceptionallyMakeStage(InvocationContext ctx, C command, InvocationExceptionFunction<C> function) {
        return InvocationStage.makeStage(this.andExceptionally(ctx, command, function));
    }

    public <C extends VisitableCommand> InvocationStage andFinallyMakeStage(InvocationContext ctx, C command, InvocationFinallyAction<C> action) {
        return InvocationStage.makeStage(this.andFinally(ctx, command, action));
    }

    public <C extends VisitableCommand> InvocationStage andHandleMakeStage(InvocationContext ctx, C command, InvocationFinallyFunction<C> function) {
        return InvocationStage.makeStage(this.andHandle(ctx, command, function));
    }

    public static InvocationStage makeStage(Object maybeStage) {
        if (maybeStage instanceof InvocationStage) {
            return (InvocationStage)maybeStage;
        }
        return new SyncInvocationStage(maybeStage);
    }

    public static InvocationStage completedNullStage() {
        return SyncInvocationStage.COMPLETED_NULL_STAGE;
    }

    public static InvocationStage completedTrueStage() {
        return SyncInvocationStage.COMPLETED_TRUE_STAGE;
    }

    public static InvocationStage completedFalseStage() {
        return SyncInvocationStage.COMPLETED_FALSE_STAGE;
    }

    public Object thenReturn(InvocationContext ctx, VisitableCommand command, Object returnValue) {
        return this.thenApply(ctx, command, (rCtx, rCommand, rv) -> returnValue);
    }
}

