/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.connections.internal;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.dialect.Database;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.SimpleDatabaseVersion;
import org.hibernate.engine.jdbc.connections.internal.ConnectionCreator;
import org.hibernate.engine.jdbc.connections.internal.ConnectionCreatorFactory;
import org.hibernate.engine.jdbc.connections.internal.ConnectionCreatorFactoryImpl;
import org.hibernate.engine.jdbc.connections.internal.ConnectionProviderInitiator;
import org.hibernate.engine.jdbc.connections.internal.ConnectionValidator;
import org.hibernate.engine.jdbc.connections.internal.DatabaseConnectionInfoImpl;
import org.hibernate.engine.jdbc.connections.internal.PoolState;
import org.hibernate.engine.jdbc.connections.internal.PooledConnections;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProviderConfigurationException;
import org.hibernate.engine.jdbc.connections.spi.DatabaseConnectionInfo;
import org.hibernate.exception.JDBCConnectionException;
import org.hibernate.internal.log.ConnectionInfoLogger;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.UnknownUnwrapTypeException;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.ServiceException;
import org.hibernate.service.spi.ServiceRegistryAwareService;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.service.spi.Stoppable;

public class DriverManagerConnectionProviderImpl
implements ConnectionProvider,
Configurable,
Stoppable,
ServiceRegistryAwareService,
ConnectionValidator {
    public static final String MIN_SIZE = "hibernate.connection.min_pool_size";
    public static final String INITIAL_SIZE = "hibernate.connection.initial_pool_size";
    public static final String VALIDATION_INTERVAL = "hibernate.connection.pool_validation_interval";
    public static final String INIT_SQL = "hibernate.connection.init_sql";
    public static final String CONNECTION_CREATOR_FACTORY = "hibernate.connection.creator_factory_class";
    private volatile PoolState state;
    private static DatabaseConnectionInfo dbInfo;
    private volatile ServiceRegistry serviceRegistry;

    @Override
    public void injectServices(ServiceRegistryImplementor serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    @Override
    public void configure(Map<String, Object> configurationValues) {
        ConnectionInfoLogger.INSTANCE.usingHibernateBuiltInConnectionPool();
        PooledConnections pool = this.buildPool(configurationValues, this.serviceRegistry);
        long validationInterval = ConfigurationHelper.getLong(VALIDATION_INTERVAL, configurationValues, 30);
        this.state = new PoolState(pool, validationInterval);
    }

    private PooledConnections buildPool(Map<String, Object> configuration, ServiceRegistry serviceRegistry) {
        String url = DriverManagerConnectionProviderImpl.jdbcUrl(configuration);
        String driverClassName = ConfigurationHelper.getString("hibernate.connection.driver_class", configuration);
        Properties connectionProps = ConnectionProviderInitiator.getConnectionProperties(configuration);
        boolean autoCommit = ConfigurationHelper.getBoolean("hibernate.connection.autocommit", configuration);
        Integer isolation = ConnectionProviderInitiator.extractIsolation(configuration);
        String initSql = ConfigurationHelper.getString(INIT_SQL, configuration);
        int minSize = ConfigurationHelper.getInt(MIN_SIZE, configuration, 1);
        int maxSize = ConfigurationHelper.getInt("hibernate.connection.pool_size", configuration, 20);
        int initialSize = ConfigurationHelper.getInt(INITIAL_SIZE, configuration, minSize);
        Driver driver = DriverManagerConnectionProviderImpl.loadDriver(driverClassName, serviceRegistry, url);
        if (driver == null) {
            DriverManagerConnectionProviderImpl.logAvailableDrivers();
        }
        ConnectionCreator connectionCreator = DriverManagerConnectionProviderImpl.getConnectionCreatorFactory(configuration, serviceRegistry).create(driver, serviceRegistry, url, connectionProps, autoCommit, isolation, initSql, configuration);
        try (Connection connection = connectionCreator.createConnection();){
            dbInfo = new DatabaseConnectionInfoImpl(DriverManagerConnectionProviderImpl.class, url, DatabaseConnectionInfoImpl.getDriverName(connection), null, SimpleDatabaseVersion.ZERO_VERSION, DatabaseConnectionInfoImpl.hasSchema(connection), DatabaseConnectionInfoImpl.hasCatalog(connection), DatabaseConnectionInfoImpl.getSchema(connection), DatabaseConnectionInfoImpl.getCatalog(connection), Boolean.toString(autoCommit), isolation != null ? ConnectionProviderInitiator.toIsolationNiceName(isolation) : ConnectionProviderInitiator.toIsolationNiceName(DatabaseConnectionInfoImpl.getIsolation(connection)), minSize, maxSize, DatabaseConnectionInfoImpl.getFetchSize(connection));
            if (!connection.getAutoCommit()) {
                connection.rollback();
            }
        }
        catch (SQLException e) {
            throw new JDBCConnectionException("Could not create connection", e);
        }
        return new PooledConnections.Builder(connectionCreator).autoCommit(autoCommit).initialSize(initialSize).minSize(minSize).maxSize(maxSize).validator(this).build();
    }

    private static Driver loadDriver(String driverClassName, ServiceRegistry serviceRegistry, String url) {
        if (driverClassName != null) {
            return DriverManagerConnectionProviderImpl.loadDriverIfPossible(driverClassName, serviceRegistry);
        }
        for (Database database : Database.values()) {
            String databaseDriverClassName;
            if (!database.matchesUrl(url) || (databaseDriverClassName = database.getDriverClassName(url)) == null) continue;
            try {
                return DriverManagerConnectionProviderImpl.loadDriverIfPossible(databaseDriverClassName, serviceRegistry);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static void logAvailableDrivers() {
        ConnectionInfoLogger.INSTANCE.jdbcDriverNotSpecified();
        StringBuilder list = new StringBuilder();
        DriverManager.drivers().forEach(driver -> {
            if (!list.isEmpty()) {
                list.append(", ");
            }
            list.append(driver.getClass().getName());
        });
        ConnectionInfoLogger.INSTANCE.availableJdbcDrivers(list.toString());
    }

    private static String jdbcUrl(Map<String, Object> configuration) {
        String url = (String)configuration.get("hibernate.connection.url");
        if (url == null) {
            throw new ConnectionProviderConfigurationException("No JDBC URL specified by property 'jakarta.persistence.jdbc.url'");
        }
        return url;
    }

    private static ConnectionCreatorFactory getConnectionCreatorFactory(Map<String, Object> configuration, ServiceRegistry serviceRegistry) {
        ConnectionCreatorFactory instance;
        Object connectionCreatorFactory = configuration.get(CONNECTION_CREATOR_FACTORY);
        ConnectionCreatorFactory factory = connectionCreatorFactory instanceof ConnectionCreatorFactory ? (instance = (ConnectionCreatorFactory)connectionCreatorFactory) : (connectionCreatorFactory != null ? DriverManagerConnectionProviderImpl.loadConnectionCreatorFactory(connectionCreatorFactory.toString(), serviceRegistry) : null);
        return factory == null ? ConnectionCreatorFactoryImpl.INSTANCE : factory;
    }

    private static Driver loadDriverIfPossible(String driverClassName, ServiceRegistry serviceRegistry) {
        if (driverClassName == null) {
            ConnectionInfoLogger.INSTANCE.debug("No driver class specified");
            return null;
        }
        if (serviceRegistry != null) {
            Class driverClass = serviceRegistry.requireService(ClassLoaderService.class).classForName(driverClassName);
            try {
                return (Driver)driverClass.newInstance();
            }
            catch (Exception e) {
                throw new ServiceException("Specified JDBC Driver " + driverClassName + " could not be loaded", e);
            }
        }
        try {
            return (Driver)Class.forName(driverClassName).newInstance();
        }
        catch (Exception e1) {
            throw new ServiceException("Specified JDBC Driver " + driverClassName + " could not be loaded", e1);
        }
    }

    private static ConnectionCreatorFactory loadConnectionCreatorFactory(String connectionCreatorFactoryClassName, ServiceRegistry serviceRegistry) {
        if (connectionCreatorFactoryClassName == null) {
            ConnectionInfoLogger.INSTANCE.debug("No connection creator factory class specified");
            return null;
        }
        if (serviceRegistry != null) {
            Class factoryClass = serviceRegistry.requireService(ClassLoaderService.class).classForName(connectionCreatorFactoryClassName);
            try {
                return (ConnectionCreatorFactory)factoryClass.newInstance();
            }
            catch (Exception e) {
                throw new ServiceException("Specified ConnectionCreatorFactory " + connectionCreatorFactoryClassName + " could not be loaded", e);
            }
        }
        try {
            return (ConnectionCreatorFactory)Class.forName(connectionCreatorFactoryClassName).newInstance();
        }
        catch (Exception e1) {
            throw new ServiceException("Specified ConnectionCreatorFactory " + connectionCreatorFactoryClassName + " could not be loaded", e1);
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.state == null) {
            throw new IllegalStateException("Cannot get a connection as the driver manager is not properly initialized");
        }
        return this.state.getConnection();
    }

    @Override
    public void closeConnection(Connection connection) throws SQLException {
        if (this.state == null) {
            throw new IllegalStateException("Cannot close a connection as the driver manager is not properly initialized");
        }
        this.state.closeConnection(connection);
    }

    @Override
    public boolean supportsAggressiveRelease() {
        return false;
    }

    @Override
    public DatabaseConnectionInfo getDatabaseConnectionInfo(Dialect dialect) {
        return new DatabaseConnectionInfoImpl(DriverManagerConnectionProviderImpl.class, dbInfo.getJdbcUrl(), dbInfo.getJdbcDriver(), dialect.getClass(), dialect.getVersion(), dbInfo.hasSchema(), dbInfo.hasCatalog(), dbInfo.getSchema(), dbInfo.getCatalog(), dbInfo.getAutoCommitMode(), dbInfo.getIsolationLevel(), dbInfo.getPoolMinSize(), dbInfo.getPoolMaxSize(), dbInfo.getJdbcFetchSize());
    }

    @Override
    public boolean isUnwrappableAs(Class<?> unwrapType) {
        return ConnectionProvider.class.equals(unwrapType) || DriverManagerConnectionProviderImpl.class.isAssignableFrom(unwrapType);
    }

    @Override
    public <T> T unwrap(Class<T> unwrapType) {
        if (ConnectionProvider.class.equals(unwrapType) || DriverManagerConnectionProviderImpl.class.isAssignableFrom(unwrapType)) {
            return (T)this;
        }
        throw new UnknownUnwrapTypeException(unwrapType);
    }

    protected int getOpenConnections() {
        return this.state.getPool().getOpenConnectionCount();
    }

    protected void validateConnectionsReturned() {
        int allocationCount = this.getOpenConnections();
        if (allocationCount != 0) {
            ConnectionInfoLogger.INSTANCE.error("Connection leak detected: there are " + allocationCount + " unclosed connections");
        }
    }

    protected void validateConnections(ConnectionValidator validator) {
        this.state.validateConnections(validator);
    }

    @Override
    public void stop() {
        if (this.state != null) {
            this.state.stop();
            this.validateConnectionsReturned();
        }
    }

    protected void finalize() throws Throwable {
        if (this.state != null) {
            this.state.stop();
        }
        super.finalize();
    }

    @Override
    public boolean isValid(Connection connection) throws SQLException {
        return true;
    }
}

