/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal.util.collections;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public final class CollectionHelper {
    public static final int DEFAULT_LIST_CAPACITY = 10;
    public static final int MINIMUM_INITIAL_CAPACITY = 16;
    public static final float LOAD_FACTOR = 0.75f;

    private CollectionHelper() {
    }

    public static <K, V> HashMap<K, V> mapOfSize(int size) {
        return new HashMap(CollectionHelper.determineProperSizing(size), 0.75f);
    }

    public static <K, V> LinkedHashMap<K, V> linkedMapOfSize(int size) {
        return new LinkedHashMap(CollectionHelper.determineProperSizing(size), 0.75f);
    }

    public static <K, V> HashMap<K, V> map() {
        return new HashMap();
    }

    public static <K, V> LinkedHashMap<K, V> linkedMap() {
        return new LinkedHashMap();
    }

    public static <K> HashSet<K> setOfSize(int size) {
        return new HashSet(CollectionHelper.determineProperSizing(size), 0.75f);
    }

    public static <K> HashSet<K> set() {
        return new HashSet();
    }

    public static <K> LinkedHashSet<K> linkedSetOfSize(int size) {
        return new LinkedHashSet(CollectionHelper.determineProperSizing(size), 0.75f);
    }

    public static <K> LinkedHashSet<K> linkedSet() {
        return new LinkedHashSet();
    }

    public static int determineProperSizing(Map<?, ?> original) {
        return CollectionHelper.determineProperSizing(original.size());
    }

    public static <X, Y> Map<X, Y> makeCopy(Map<X, Y> map) {
        HashMap<X, Y> copy = CollectionHelper.mapOfSize(map.size() + 1);
        copy.putAll(map);
        return copy;
    }

    public static <K, V> HashMap<K, V> makeCopy(Map<K, V> original, Function<K, K> keyTransformer, Function<V, V> valueTransformer) {
        if (original == null) {
            return null;
        }
        HashMap copy = new HashMap(CollectionHelper.determineProperSizing(original));
        original.forEach((key, value) -> copy.put(keyTransformer.apply(key), valueTransformer.apply(value)));
        return copy;
    }

    public static <K, V> Map<K, V> makeMap(Collection<V> collection, Function<V, K> keyProducer) {
        return CollectionHelper.makeMap(collection, keyProducer, v -> v);
    }

    public static <K, V, E> Map<K, V> makeMap(Collection<E> collection, Function<E, K> keyProducer, Function<E, V> valueProducer) {
        if (CollectionHelper.isEmpty(collection)) {
            return Collections.emptyMap();
        }
        HashMap<K, V> map = new HashMap<K, V>(CollectionHelper.determineProperSizing(collection.size()));
        for (E element : collection) {
            map.put(keyProducer.apply(element), valueProducer.apply(element));
        }
        return map;
    }

    public static int determineProperSizing(Set<?> original) {
        return CollectionHelper.determineProperSizing(original.size());
    }

    public static int determineProperSizing(int numberOfElements) {
        return Math.max((int)((float)numberOfElements / 0.75f) + 1, 16);
    }

    public static <K, V> ConcurrentHashMap<K, V> concurrentMap(int expectedNumberOfElements) {
        return CollectionHelper.concurrentMap(expectedNumberOfElements, 0.75f);
    }

    public static <K, V> ConcurrentHashMap<K, V> concurrentMap(int expectedNumberOfElements, float loadFactor) {
        return new ConcurrentHashMap(expectedNumberOfElements, loadFactor);
    }

    public static <T> ArrayList<T> arrayList(int expectedNumberOfElements) {
        return new ArrayList(Math.max(expectedNumberOfElements + 1, 10));
    }

    public static <T> ArrayList<T> populatedArrayList(int expectedNumberOfElements, T value) {
        ArrayList<T> list = new ArrayList<T>(Math.max(expectedNumberOfElements + 1, 10));
        for (int i = 0; i < expectedNumberOfElements; ++i) {
            list.add(value);
        }
        return list;
    }

    public static <T> Set<T> makeCopy(Set<T> source) {
        if (source == null) {
            return null;
        }
        HashSet copy = CollectionHelper.setOfSize(source.size() + 1);
        copy.addAll(source);
        return copy;
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isNotEmpty(Collection<?> collection) {
        return !CollectionHelper.isEmpty(collection);
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return !CollectionHelper.isEmpty(map);
    }

    public static boolean isEmpty(Object[] objects) {
        return objects == null || objects.length == 0;
    }

    public static boolean isNotEmpty(Object[] objects) {
        return objects != null && objects.length > 0;
    }

    public static <T> List<T> listOf(T value1) {
        ArrayList<T> list = new ArrayList<T>(1);
        list.add(value1);
        return list;
    }

    public static <T> List<T> listOf(T ... values) {
        ArrayList list = new ArrayList(values.length);
        Collections.addAll(list, values);
        return list;
    }

    public static <T> Set<T> setOf(T ... values) {
        HashSet set = new HashSet(CollectionHelper.determineProperSizing(values.length));
        Collections.addAll(set, values);
        return set;
    }

    public static <T> Set<T> setOf(Collection<T> values) {
        return CollectionHelper.isEmpty(values) ? Collections.emptySet() : new HashSet<T>(values);
    }

    public static Properties asProperties(Map<?, ?> map) {
        if (map instanceof Properties) {
            Properties properties = (Properties)map;
            return properties;
        }
        Properties properties = new Properties();
        if (CollectionHelper.isNotEmpty(map)) {
            properties.putAll(map);
        }
        return properties;
    }

    public static <T> Set<T> toSmallSet(Set<T> set) {
        return switch (set.size()) {
            case 0 -> Collections.emptySet();
            case 1 -> Collections.singleton(set.iterator().next());
            default -> set;
        };
    }

    public static <K, V> Map<K, V> toSmallMap(Map<K, V> map) {
        if (map == null) {
            return Collections.emptyMap();
        }
        return switch (map.size()) {
            case 0 -> Collections.emptyMap();
            case 1 -> {
                Map.Entry<K, V> entry = map.entrySet().iterator().next();
                yield Collections.singletonMap(entry.getKey(), entry.getValue());
            }
            default -> map;
        };
    }

    public static <V> List<V> toSmallList(ArrayList<V> arrayList) {
        if (arrayList == null) {
            return Collections.emptyList();
        }
        return switch (arrayList.size()) {
            case 0 -> Collections.emptyList();
            case 1 -> Collections.singletonList(arrayList.get(0));
            default -> {
                arrayList.trimToSize();
                yield arrayList;
            }
        };
    }

    public static <O> List<O> combine(List<O> list1, List<O> list2) {
        ArrayList combined = CollectionHelper.arrayList(list1.size() + list2.size());
        combined.addAll(list1);
        combined.addAll(list2);
        return combined;
    }

    public static List combineUntyped(List list1, List list2) {
        ArrayList combined = CollectionHelper.arrayList(list1.size() + list2.size());
        combined.addAll(list1);
        combined.addAll(list2);
        return combined;
    }

    @SafeVarargs
    public static <O> List<O> combine(List<O> ... lists) {
        ArrayList<O> combined = new ArrayList<O>();
        for (List<O> list : lists) {
            combined.addAll(list);
        }
        return combined;
    }

    public static int size(List<?> values) {
        return values == null ? 0 : values.size();
    }

    public static int size(Collection<?> values) {
        return values == null ? 0 : values.size();
    }

    public static int size(Map<?, ?> values) {
        return values == null ? 0 : values.size();
    }

    @SafeVarargs
    public static <X> Set<X> toSet(X ... values) {
        HashSet<X> result = new HashSet<X>();
        if (CollectionHelper.isNotEmpty(values)) {
            result.addAll(Arrays.asList(values));
        }
        return result;
    }

    public static <E> List<E> mutableJoin(Collection<E> first, Collection<E> second) {
        int totalCount = (first == null ? 0 : first.size()) + (second == null ? 0 : second.size());
        if (totalCount == 0) {
            return new ArrayList();
        }
        ArrayList<E> joined = new ArrayList<E>(totalCount);
        if (first != null) {
            joined.addAll(first);
        }
        if (second != null) {
            joined.addAll(second);
        }
        return joined;
    }

    @SafeVarargs
    public static <E> List<E> mutableJoin(Collection<E> first, Collection<E> ... others) {
        assert (first != null);
        if (CollectionHelper.isEmpty(others)) {
            ArrayList<E> list = new ArrayList<E>(first.size());
            list.addAll(first);
            return list;
        }
        ArrayList joined = CollectionHelper.arrayList(first.size() + (CollectionHelper.isEmpty(others) ? 0 : others.length * 8));
        joined.addAll(first);
        for (Collection<E> other : others) {
            joined.addAll(other);
        }
        return joined;
    }
}

