/*
 * Decompiled with CFR 0.152.
 */
package de.escape.quincunx.dxf.reader;

import de.escape.quincunx.dxf.reader.Dxf14Converter;
import de.escape.quincunx.dxf.reader.DxfEntity;
import de.escape.quincunx.dxf.reader.DxfFile;
import de.escape.quincunx.trafo.Point3D;

public class DxfLWPOLYLINE
extends DxfEntity {
    public static final int CLOSED = 1;
    public static final int CONT_LTYPE = 128;
    protected int type;
    protected float constantWidth;
    protected LwVertex[] vertices;
    protected int vertexNr = -1;
    protected boolean hasWidth;

    public boolean setGroup(short grpNr, float fval) {
        switch (grpNr) {
            case 10: {
                ++this.vertexNr;
                if (this.vertices == null) {
                    this.vertices = new LwVertex[1];
                } else if (this.vertexNr == this.vertices.length) {
                    LwVertex[] lwv = new LwVertex[this.vertexNr + 1];
                    System.arraycopy(this.vertices, 0, lwv, 0, this.vertices.length);
                    this.vertices = lwv;
                }
                this.vertices[this.vertexNr] = new LwVertex(this.constantWidth);
                this.vertices[this.vertexNr].setX(fval);
                return true;
            }
            case 20: {
                this.vertices[this.vertexNr].setY(fval);
                return true;
            }
            case 40: {
                this.vertices[this.vertexNr].setStartWidth(fval);
                if ((double)fval > 0.0) {
                    this.hasWidth = true;
                }
                return true;
            }
            case 41: {
                this.vertices[this.vertexNr].setEndWidth(fval);
                if ((double)fval > 0.0) {
                    this.hasWidth = true;
                }
                return true;
            }
            case 42: {
                this.vertices[this.vertexNr].setBulge(fval);
                return true;
            }
            case 43: {
                this.constantWidth = fval;
                if ((double)fval > 0.0) {
                    this.hasWidth = true;
                }
                return true;
            }
        }
        return super.setGroup(grpNr, fval);
    }

    public boolean setGroup(short grpNr, int ival) {
        switch (grpNr) {
            case 70: {
                this.type = ival;
                return true;
            }
            case 90: {
                if (this.vertices == null && ival > 0) {
                    this.vertices = new LwVertex[ival];
                }
                return true;
            }
        }
        return super.setGroup(grpNr, ival);
    }

    public boolean finishRead(DxfFile file) {
        if (this.vertexNr + 1 != this.vertices.length) {
            LwVertex[] lwv = new LwVertex[this.vertexNr + 1];
            System.arraycopy(this.vertices, 0, lwv, 0, lwv.length);
            this.vertices = lwv;
        }
        return super.finishRead(file);
    }

    public void convert(Dxf14Converter converter, DxfFile dxf, Object collector) {
        converter.convert(this, dxf, collector);
    }

    public boolean hasLineWidth() {
        return this.hasWidth;
    }

    public final int getType() {
        return this.type;
    }

    public final float getConstantWidth() {
        return this.constantWidth;
    }

    public final LwVertex[] getVertices() {
        return this.vertices;
    }

    public static class LwVertex {
        private float x;
        private float y;
        private float startWidth;
        private float endWidth;
        private float bulge;

        LwVertex(float width) {
            this.startWidth = this.endWidth = width;
        }

        public float getX() {
            return this.x;
        }

        void setX(float x) {
            this.x = x;
        }

        public float getY() {
            return this.y;
        }

        void setY(float y) {
            this.y = y;
        }

        public Point3D getPosition() {
            return new Point3D(this.x, this.y, 0.0f);
        }

        public float getStartWidth() {
            return this.startWidth;
        }

        void setStartWidth(float width) {
            this.startWidth = width;
        }

        public float getEndWidth() {
            return this.endWidth;
        }

        void setEndWidth(float width) {
            this.endWidth = width;
        }

        public float getBulge() {
            return this.bulge;
        }

        void setBulge(float bulge) {
            this.bulge = bulge;
        }
    }
}

