/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlets;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.servlet.AsyncContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.HttpOutput;

public class DataRateLimitedServlet
extends HttpServlet {
    private static final long serialVersionUID = -4771757707068097025L;
    private int buffersize = 8192;
    private long pauseNS = TimeUnit.MILLISECONDS.toNanos(100L);
    ScheduledThreadPoolExecutor scheduler;
    private final ConcurrentHashMap<String, ByteBuffer> cache = new ConcurrentHashMap();

    public void init() throws ServletException {
        String tmp = this.getInitParameter("buffersize");
        if (tmp != null) {
            this.buffersize = Integer.parseInt(tmp);
        }
        if ((tmp = this.getInitParameter("pause")) != null) {
            this.pauseNS = TimeUnit.MILLISECONDS.toNanos(Integer.parseInt(tmp));
        }
        int pool = (tmp = this.getInitParameter("pool")) == null ? Runtime.getRuntime().availableProcessors() : Integer.parseInt(tmp);
        this.scheduler = new ScheduledThreadPoolExecutor(pool);
    }

    public void destroy() {
        this.scheduler.shutdown();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        File file;
        String info = request.getPathInfo();
        if (info.endsWith("/")) {
            response.sendError(503, "directories not supported");
            return;
        }
        String content_type = this.getServletContext().getMimeType(info);
        response.setContentType(content_type == null ? "application/x-data" : content_type);
        String path = request.getPathTranslated();
        ServletOutputStream out = response.getOutputStream();
        if (path != null && out instanceof HttpOutput && (file = new File(path)).exists() && file.canRead()) {
            response.setContentLengthLong(file.length());
            ByteBuffer mapped = this.cache.get(path);
            if (mapped == null) {
                try (RandomAccessFile raf = new RandomAccessFile(file, "r");){
                    MappedByteBuffer buf = raf.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, raf.length());
                    mapped = this.cache.putIfAbsent(path, buf);
                    if (mapped == null) {
                        mapped = buf;
                    }
                }
            }
            AsyncContext async = request.startAsync();
            out.setWriteListener((WriteListener)new JettyDataStream(mapped, async, out));
            return;
        }
        InputStream content = this.getServletContext().getResourceAsStream(info);
        if (content == null) {
            response.sendError(404);
            return;
        }
        out.setWriteListener((WriteListener)new StandardDataStream(content, request.startAsync(), out));
    }

    private final class JettyDataStream
    implements WriteListener,
    Runnable {
        private final ByteBuffer content;
        private final int limit;
        private final AsyncContext async;
        private final HttpOutput out;

        private JettyDataStream(ByteBuffer content, AsyncContext async, ServletOutputStream out) {
            this.content = content.asReadOnlyBuffer();
            this.limit = this.content.limit();
            this.async = async;
            this.out = (HttpOutput)out;
        }

        public void onWritePossible() throws IOException {
            if (this.out.isReady()) {
                int l = this.content.position() + DataRateLimitedServlet.this.buffersize;
                if (l > this.limit) {
                    l = this.limit;
                }
                this.content.limit(l);
                if (!this.content.hasRemaining()) {
                    this.async.complete();
                    return;
                }
                this.out.write(this.content);
                DataRateLimitedServlet.this.scheduler.schedule(this, DataRateLimitedServlet.this.pauseNS, TimeUnit.NANOSECONDS);
            }
        }

        @Override
        public void run() {
            try {
                this.onWritePossible();
            }
            catch (Exception e) {
                this.onError(e);
            }
        }

        public void onError(Throwable t) {
            DataRateLimitedServlet.this.getServletContext().log("Async Error", t);
            this.async.complete();
        }
    }

    private final class StandardDataStream
    implements WriteListener,
    Runnable {
        private final InputStream content;
        private final AsyncContext async;
        private final ServletOutputStream out;

        private StandardDataStream(InputStream content, AsyncContext async, ServletOutputStream out) {
            this.content = content;
            this.async = async;
            this.out = out;
        }

        public void onWritePossible() throws IOException {
            if (this.out.isReady()) {
                byte[] buffer = new byte[DataRateLimitedServlet.this.buffersize];
                int len = this.content.read(buffer);
                if (len < 0) {
                    this.async.complete();
                    return;
                }
                this.out.write(buffer, 0, len);
                DataRateLimitedServlet.this.scheduler.schedule(this, DataRateLimitedServlet.this.pauseNS, TimeUnit.NANOSECONDS);
            }
        }

        @Override
        public void run() {
            try {
                this.onWritePossible();
            }
            catch (Exception e) {
                this.onError(e);
            }
        }

        public void onError(Throwable t) {
            DataRateLimitedServlet.this.getServletContext().log("Async Error", t);
            this.async.complete();
        }
    }
}

