/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.codearea;

import jadx.core.utils.StringUtils;
import jadx.gui.utils.NLS;
import jadx.gui.utils.TextStandardActions;
import jadx.gui.utils.UiUtils;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.text.BadLocationException;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.SearchContext;
import org.fife.ui.rtextarea.SearchEngine;
import org.fife.ui.rtextarea.SearchResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SearchBar
extends JToolBar {
    private static final long serialVersionUID = 1836871286618633003L;
    private static final Logger LOG = LoggerFactory.getLogger(SearchBar.class);
    private static final Icon ICON_MARK = UiUtils.openSvgIcon("search/mark");
    private static final Icon ICON_MARK_SELECTED = UiUtils.openSvgIcon("search/previewSelected");
    private static final Icon ICON_REGEX = UiUtils.openSvgIcon("search/regexHovered");
    private static final Icon ICON_REGEX_SELECTED = UiUtils.openSvgIcon("search/regexSelected");
    private static final Icon ICON_WORDS = UiUtils.openSvgIcon("search/wordsHovered");
    private static final Icon ICON_WORDS_SELECTED = UiUtils.openSvgIcon("search/wordsSelected");
    private static final Icon ICON_MATCH = UiUtils.openSvgIcon("search/matchCaseHovered");
    private static final Icon ICON_MATCH_SELECTED = UiUtils.openSvgIcon("search/matchCaseSelected");
    private static final Icon ICON_UP = UiUtils.openSvgIcon("ui/top");
    private static final Icon ICON_DOWN = UiUtils.openSvgIcon("ui/bottom");
    private static final Icon ICON_CLOSE = UiUtils.openSvgIcon("ui/close");
    private RSyntaxTextArea rTextArea;
    private final JTextField searchField;
    private final JToggleButton markAllCB;
    private final JToggleButton regexCB;
    private final JToggleButton wholeWordCB;
    private final JToggleButton matchCaseCB;
    private boolean notFound;

    public SearchBar(RSyntaxTextArea textArea) {
        this.rTextArea = textArea;
        JLabel findLabel = new JLabel(NLS.str("search.find") + ':');
        this.add(findLabel);
        this.searchField = new JTextField(30);
        this.searchField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 10: {
                        break;
                    }
                    case 27: {
                        SearchBar.this.toggle();
                        break;
                    }
                    default: {
                        SearchBar.this.search(0);
                    }
                }
            }
        });
        this.searchField.addActionListener(e -> this.search(1));
        new TextStandardActions(this.searchField);
        this.add(this.searchField);
        ActionListener forwardListener = e -> this.search(1);
        this.matchCaseCB = new JToggleButton();
        this.matchCaseCB.setIcon(ICON_MATCH);
        this.matchCaseCB.setSelectedIcon(ICON_MATCH_SELECTED);
        this.matchCaseCB.setToolTipText(NLS.str("search.match_case"));
        this.matchCaseCB.addActionListener(forwardListener);
        this.add(this.matchCaseCB);
        this.wholeWordCB = new JToggleButton();
        this.wholeWordCB.setIcon(ICON_WORDS);
        this.wholeWordCB.setSelectedIcon(ICON_WORDS_SELECTED);
        this.wholeWordCB.setToolTipText(NLS.str("search.whole_word"));
        this.wholeWordCB.addActionListener(forwardListener);
        this.add(this.wholeWordCB);
        this.regexCB = new JToggleButton();
        this.regexCB.setIcon(ICON_REGEX);
        this.regexCB.setSelectedIcon(ICON_REGEX_SELECTED);
        this.regexCB.setToolTipText(NLS.str("search.regex"));
        this.regexCB.addActionListener(forwardListener);
        this.add(this.regexCB);
        JButton prevButton = new JButton();
        prevButton.setIcon(ICON_UP);
        prevButton.setToolTipText(NLS.str("search.previous"));
        prevButton.addActionListener(e -> this.search(-1));
        prevButton.setBorderPainted(false);
        this.add(prevButton);
        JButton nextButton = new JButton();
        nextButton.setIcon(ICON_DOWN);
        nextButton.setToolTipText(NLS.str("search.next"));
        nextButton.addActionListener(e -> this.search(1));
        nextButton.setBorderPainted(false);
        this.add(nextButton);
        this.markAllCB = new JToggleButton();
        this.markAllCB.setIcon(ICON_MARK);
        this.markAllCB.setSelectedIcon(ICON_MARK_SELECTED);
        this.markAllCB.setToolTipText(NLS.str("search.mark_all"));
        this.markAllCB.addActionListener(forwardListener);
        this.add(this.markAllCB);
        JButton closeButton = new JButton();
        closeButton.setIcon(ICON_CLOSE);
        closeButton.addActionListener(e -> this.toggle());
        closeButton.setBorderPainted(false);
        this.add(closeButton);
        this.setFloatable(false);
        this.setVisible(false);
    }

    public void toggle() {
        boolean visible = !this.isVisible();
        this.setVisible(visible);
        if (visible) {
            String preferText = this.rTextArea.getSelectedText();
            if (!StringUtils.isEmpty((String)preferText)) {
                this.searchField.setText(preferText);
            }
            this.searchField.requestFocus();
            this.searchField.selectAll();
        } else {
            this.rTextArea.requestFocus();
        }
    }

    private void search(int direction) {
        SearchResult result;
        String searchText = this.searchField.getText();
        if (searchText == null || searchText.length() == 0 || this.rTextArea.getText() == null) {
            return;
        }
        boolean forward = direction >= 0;
        boolean matchCase = this.matchCaseCB.isSelected();
        boolean regex = this.regexCB.isSelected();
        boolean wholeWord = this.wholeWordCB.isSelected();
        SearchContext context = new SearchContext();
        context.setSearchFor(searchText);
        context.setMatchCase(matchCase);
        context.setRegularExpression(regex);
        context.setSearchForward(forward);
        context.setWholeWord(wholeWord);
        context.setMarkAll(this.markAllCB.isSelected());
        if (direction == 0 && !this.notFound) {
            try {
                int caretPos = this.rTextArea.getCaretPosition();
                int lineNum = this.rTextArea.getLineOfOffset(caretPos) - 1;
                if (lineNum > 1) {
                    this.rTextArea.setCaretPosition(this.rTextArea.getLineStartOffset(lineNum));
                }
            }
            catch (BadLocationException e) {
                LOG.error("Caret move error", (Throwable)e);
            }
        }
        boolean bl = this.notFound = !(result = SearchEngine.find((JTextArea)this.rTextArea, (SearchContext)context)).wasFound();
        if (this.notFound) {
            int pos = SearchEngine.getNextMatchPos((String)searchText, (String)this.rTextArea.getText(), (boolean)forward, (boolean)matchCase, (boolean)wholeWord);
            if (pos != -1) {
                this.rTextArea.setCaretPosition(forward ? 0 : this.rTextArea.getDocument().getLength() - 1);
                this.search(direction);
                this.searchField.putClientProperty("JComponent.outline", "warning");
            } else {
                this.searchField.putClientProperty("JComponent.outline", "error");
            }
        } else {
            this.searchField.putClientProperty("JComponent.outline", "");
        }
        this.searchField.repaint();
    }
}

