/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.changes.sessions;

import java.util.Collection;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.common.util.Time;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.session.UserSessionPersisterProvider;
import org.keycloak.models.sessions.infinispan.changes.sessions.AbstractLastSessionRefreshStore;
import org.keycloak.models.sessions.infinispan.changes.sessions.SessionData;
import org.keycloak.models.utils.KeycloakModelUtils;

public class PersisterLastSessionRefreshStore
extends AbstractLastSessionRefreshStore {
    protected static final Logger logger = Logger.getLogger(PersisterLastSessionRefreshStore.class);
    private final boolean offline;

    protected PersisterLastSessionRefreshStore(int maxIntervalBetweenMessagesSeconds, int maxCount, boolean offline) {
        super(maxIntervalBetweenMessagesSeconds, maxCount);
        this.offline = offline;
    }

    @Override
    protected void sendMessage(KeycloakSession kcSession, Map<String, SessionData> refreshesToSend) {
        Map sessionIdsByRealm = refreshesToSend.entrySet().stream().collect(Collectors.groupingBy(entry -> ((SessionData)entry.getValue()).realmId(), Collectors.mapping(Map.Entry::getKey, Collectors.toSet())));
        int lastSessionRefresh = Time.currentTime() - 60;
        if (logger.isDebugEnabled()) {
            logger.debugf("Updating %d userSessions with lastSessionRefresh: %d", refreshesToSend.size(), lastSessionRefresh);
        }
        for (Map.Entry entry2 : sessionIdsByRealm.entrySet()) {
            KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)kcSession.getKeycloakSessionFactory(), kcSession2 -> {
                UserSessionPersisterProvider persister = (UserSessionPersisterProvider)kcSession2.getProvider(UserSessionPersisterProvider.class);
                RealmModel realm = kcSession2.realms().getRealm((String)entry2.getKey());
                if (realm != null) {
                    TreeSet userSessionIds = new TreeSet((Collection)entry2.getValue());
                    persister.updateLastSessionRefreshes(realm, lastSessionRefresh, userSessionIds, this.offline);
                }
            });
        }
    }
}

