/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.otlp;

import io.opentelemetry.context.internal.shaded.WeakConcurrentMap;
import io.opentelemetry.exporter.internal.marshal.Marshaler;
import io.opentelemetry.exporter.internal.marshal.MarshalerUtil;
import io.opentelemetry.exporter.internal.marshal.MarshalerWithSize;
import io.opentelemetry.exporter.internal.marshal.ProtoFieldInfo;
import io.opentelemetry.exporter.internal.marshal.Serializer;
import io.opentelemetry.exporter.internal.otlp.KeyValueMarshaler;
import io.opentelemetry.sdk.resources.Resource;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;

public final class ResourceMarshaler
extends MarshalerWithSize {
    private static final WeakConcurrentMap<Resource, ResourceMarshaler> RESOURCE_MARSHALER_CACHE = new WeakConcurrentMap.WithInlinedExpunction();
    private final byte[] serializedBinary;
    private final String serializedJson;

    public static ResourceMarshaler create(Resource resource) {
        ResourceMarshaler cached = (ResourceMarshaler)((Object)RESOURCE_MARSHALER_CACHE.get((Object)resource));
        if (cached == null) {
            RealResourceMarshaler realMarshaler = new RealResourceMarshaler(KeyValueMarshaler.createForAttributes(resource.getAttributes()));
            ByteArrayOutputStream binaryBos = new ByteArrayOutputStream(realMarshaler.getBinarySerializedSize());
            try {
                realMarshaler.writeBinaryTo(binaryBos);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Serialization error, this is likely a bug in OpenTelemetry.", e);
            }
            String json = MarshalerUtil.preserializeJsonFields((Marshaler)realMarshaler);
            cached = new ResourceMarshaler(binaryBos.toByteArray(), json);
            RESOURCE_MARSHALER_CACHE.put((Object)resource, (Object)cached);
        }
        return cached;
    }

    private ResourceMarshaler(byte[] binary, String json) {
        super(binary.length);
        this.serializedBinary = binary;
        this.serializedJson = json;
    }

    public void writeTo(Serializer output) throws IOException {
        output.writeSerializedMessage(this.serializedBinary, this.serializedJson);
    }

    private static final class RealResourceMarshaler
    extends MarshalerWithSize {
        private final KeyValueMarshaler[] attributes;

        private RealResourceMarshaler(KeyValueMarshaler[] attributes) {
            super(RealResourceMarshaler.calculateSize(attributes));
            this.attributes = attributes;
        }

        protected void writeTo(Serializer output) throws IOException {
            output.serializeRepeatedMessage(io.opentelemetry.proto.resource.v1.internal.Resource.ATTRIBUTES, (Marshaler[])this.attributes);
        }

        private static int calculateSize(KeyValueMarshaler[] attributeMarshalers) {
            return MarshalerUtil.sizeRepeatedMessage((ProtoFieldInfo)io.opentelemetry.proto.resource.v1.internal.Resource.ATTRIBUTES, (Marshaler[])attributeMarshalers);
        }
    }
}

