/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.jdbc;

import com.mysql.cj.Messages;
import com.mysql.cj.MysqlType;
import com.mysql.cj.ServerVersion;
import com.mysql.cj.conf.PropertyDefinitions;
import com.mysql.cj.exceptions.CJException;
import com.mysql.cj.jdbc.DatabaseMetaData;
import com.mysql.cj.jdbc.JdbcConnection;
import com.mysql.cj.jdbc.exceptions.SQLError;
import com.mysql.cj.jdbc.exceptions.SQLExceptionsMapping;
import com.mysql.cj.jdbc.result.ResultSetFactory;
import com.mysql.cj.jdbc.result.ResultSetInternalMethods;
import com.mysql.cj.util.LRUCache;
import com.mysql.cj.util.StringUtils;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;

public class DatabaseMetaDataInformationSchema
extends DatabaseMetaData {
    static final Lock INFORMATION_SCHEMA_COLLATION_CACHE_LOCK = new ReentrantLock();
    static Map<ServerVersion, String> informationSchemaCollationCache = Collections.synchronizedMap(new LRUCache(10));

    protected DatabaseMetaDataInformationSchema(JdbcConnection connToSet, String databaseToSet, ResultSetFactory resultSetFactory) {
        super(connToSet, databaseToSet, resultSetFactory);
    }

    private ResultSet executeMetadataQuery(PreparedStatement pStmt) throws SQLException {
        ResultSet rs = pStmt.executeQuery();
        ((ResultSetInternalMethods)rs).setOwningStatement(null);
        return rs;
    }

    private StringBuilder appendOptionalRefContraintsJoin(StringBuilder query) {
        query.append(" JOIN INFORMATION_SCHEMA.REFERENTIAL_CONSTRAINTS R ON (R.CONSTRAINT_NAME = B.CONSTRAINT_NAME");
        query.append(" AND R.TABLE_NAME = B.TABLE_NAME AND R.CONSTRAINT_SCHEMA = B.TABLE_SCHEMA)");
        return query;
    }

    private StringBuilder appendUpdateRuleClause(StringBuilder query) {
        query.append(" CASE WHEN R.UPDATE_RULE = 'CASCADE' THEN ").append(0);
        query.append(" WHEN R.UPDATE_RULE = 'SET NULL' THEN ").append(2);
        query.append(" WHEN R.UPDATE_RULE = 'SET DEFAULT' THEN ").append(4);
        query.append(" WHEN R.UPDATE_RULE = 'RESTRICT' THEN ").append(1);
        query.append(" WHEN R.UPDATE_RULE = 'NO ACTION' THEN ").append(1);
        query.append(" ELSE ").append(1).append(" END");
        return query;
    }

    private StringBuilder appendDeleteRuleClause(StringBuilder query) {
        query.append(" CASE WHEN R.DELETE_RULE = 'CASCADE' THEN ").append(0);
        query.append(" WHEN R.DELETE_RULE = 'SET NULL' THEN ").append(2);
        query.append(" WHEN R.DELETE_RULE = 'SET DEFAULT' THEN ").append(4);
        query.append(" WHEN R.DELETE_RULE = 'RESTRICT' THEN ").append(1);
        query.append(" WHEN R.DELETE_RULE = 'NO ACTION' THEN ").append(1);
        query.append(" ELSE ").append(1).append(" END");
        return query;
    }

    private StringBuilder appendDataTypeClause(StringBuilder query, String fullMysqlTypeColumn) {
        query.append(" CASE");
        block4: for (MysqlType mysqlType : MysqlType.values()) {
            query.append(" WHEN UPPER(DATA_TYPE) = '").append(mysqlType.getName()).append("' THEN");
            switch (mysqlType) {
                case TINYINT: 
                case TINYINT_UNSIGNED: {
                    if (this.tinyInt1IsBitValue().booleanValue()) {
                        query.append(" IF(LOCATE('ZEROFILL', UPPER(").append(fullMysqlTypeColumn).append(")) = 0");
                        query.append(" AND LOCATE('UNSIGNED', UPPER(").append(fullMysqlTypeColumn).append(")) = 0");
                        query.append(" AND LOCATE('(1)', ").append(fullMysqlTypeColumn).append(") != 0,");
                        query.append(" ").append(this.transformedBitIsBooleanValue() != false ? "16" : "-7").append(", -6)");
                        continue block4;
                    }
                    query.append(" ").append(mysqlType.getJdbcType());
                    continue block4;
                }
                case YEAR: {
                    query.append(" ").append(this.yearIsDateTypeValue() != false ? mysqlType.getJdbcType() : 5);
                    continue block4;
                }
                default: {
                    query.append(" ").append(mysqlType.getJdbcType());
                }
            }
        }
        query.append(" WHEN UPPER(DATA_TYPE) = 'POINT' THEN -2");
        query.append(" WHEN UPPER(DATA_TYPE) = 'LINESTRING' THEN -2");
        query.append(" WHEN UPPER(DATA_TYPE) = 'POLYGON' THEN -2");
        query.append(" WHEN UPPER(DATA_TYPE) = 'MULTIPOINT' THEN -2");
        query.append(" WHEN UPPER(DATA_TYPE) = 'MULTILINESTRING' THEN -2");
        query.append(" WHEN UPPER(DATA_TYPE) = 'MULTIPOLYGON' THEN -2");
        query.append(" WHEN UPPER(DATA_TYPE) = 'GEOMETRYCOLLECTION' THEN -2");
        query.append(" WHEN UPPER(DATA_TYPE) = 'GEOMCOLLECTION' THEN -2");
        query.append(" ELSE 1111 END");
        return query;
    }

    private StringBuilder appendTypeNameClause(StringBuilder query, String fullMysqlTypeColumn) {
        query.append(" UPPER(CASE");
        if (this.tinyInt1IsBitValue().booleanValue()) {
            query.append(" WHEN UPPER(DATA_TYPE) = 'TINYINT' THEN CASE");
            query.append(" WHEN LOCATE('ZEROFILL', UPPER(").append(fullMysqlTypeColumn).append(")) = 0");
            query.append(" AND LOCATE('UNSIGNED', UPPER(").append(fullMysqlTypeColumn).append(")) = 0");
            query.append(" AND LOCATE('(1)', ").append(fullMysqlTypeColumn).append(") != 0");
            query.append(" THEN ").append(this.transformedBitIsBooleanValue() != false ? "'BOOLEAN'" : "'BIT'");
            query.append(" WHEN LOCATE('UNSIGNED', UPPER(").append(fullMysqlTypeColumn).append(")) != 0");
            query.append(" AND LOCATE('UNSIGNED', UPPER(DATA_TYPE)) = 0 THEN 'TINYINT UNSIGNED'");
            query.append(" ELSE DATA_TYPE END");
        }
        query.append(" WHEN LOCATE('UNSIGNED', UPPER(").append(fullMysqlTypeColumn).append(")) != 0 AND LOCATE('UNSIGNED', UPPER(DATA_TYPE)) = 0");
        query.append(" AND LOCATE('SET', UPPER(DATA_TYPE)) <> 1 AND LOCATE('ENUM', UPPER(DATA_TYPE)) <> 1 THEN CONCAT(DATA_TYPE, ' UNSIGNED')");
        query.append(" WHEN UPPER(DATA_TYPE) = 'POINT' THEN 'GEOMETRY'");
        query.append(" WHEN UPPER(DATA_TYPE) = 'LINESTRING' THEN 'GEOMETRY'");
        query.append(" WHEN UPPER(DATA_TYPE) = 'POLYGON' THEN 'GEOMETRY'");
        query.append(" WHEN UPPER(DATA_TYPE) = 'MULTIPOINT' THEN 'GEOMETRY'");
        query.append(" WHEN UPPER(DATA_TYPE) = 'MULTILINESTRING' THEN 'GEOMETRY'");
        query.append(" WHEN UPPER(DATA_TYPE) = 'MULTIPOLYGON' THEN 'GEOMETRY'");
        query.append(" WHEN UPPER(DATA_TYPE) = 'GEOMETRYCOLLECTION' THEN 'GEOMETRY'");
        query.append(" WHEN UPPER(DATA_TYPE) = 'GEOMCOLLECTION' THEN 'GEOMETRY'");
        query.append(" ELSE UPPER(DATA_TYPE) END)");
        return query;
    }

    private StringBuilder appendColumnSizeClause(StringBuilder query) {
        boolean supportsFractSeconds = this.getJdbcConnection().getServerVersion().meetsMinimum(ServerVersion.parseVersion("5.6.4"));
        query.append(" UPPER(CASE");
        query.append(" WHEN UPPER(DATA_TYPE) = 'YEAR' THEN 4");
        query.append(" WHEN UPPER(DATA_TYPE) = 'DATE' THEN 10");
        if (supportsFractSeconds) {
            query.append(" WHEN UPPER(DATA_TYPE) = 'DATETIME'");
            query.append(" OR UPPER(DATA_TYPE) = 'TIMESTAMP'");
            query.append(" THEN 19 + IF(DATETIME_PRECISION > 0, DATETIME_PRECISION + 1, DATETIME_PRECISION)");
            query.append(" WHEN UPPER(DATA_TYPE) = 'TIME'");
            query.append(" THEN 8 + IF(DATETIME_PRECISION > 0, DATETIME_PRECISION + 1, DATETIME_PRECISION)");
        } else {
            query.append(" WHEN UPPER(DATA_TYPE) = 'DATETIME' OR");
            query.append(" UPPER(DATA_TYPE) = 'TIMESTAMP'");
            query.append(" THEN 19");
            query.append(" WHEN UPPER(DATA_TYPE) = 'TIME' THEN 8");
        }
        if (this.tinyInt1IsBitValue().booleanValue() && !this.transformedBitIsBooleanValue().booleanValue()) {
            query.append(" WHEN UPPER(DATA_TYPE) = 'TINYINT' AND LOCATE('ZEROFILL', UPPER(COLUMN_TYPE)) = 0");
            query.append(" AND LOCATE('UNSIGNED', UPPER(COLUMN_TYPE)) = 0 AND LOCATE('(1)', COLUMN_TYPE) != 0 THEN 1");
        }
        query.append(" WHEN UPPER(DATA_TYPE) = 'MEDIUMINT' AND LOCATE('UNSIGNED', UPPER(COLUMN_TYPE)) != 0 THEN 8");
        query.append(" WHEN UPPER(DATA_TYPE) = 'JSON' THEN 1073741824");
        query.append(" WHEN UPPER(DATA_TYPE) = 'GEOMETRY' THEN 65535");
        query.append(" WHEN UPPER(DATA_TYPE) = 'POINT' THEN 65535");
        query.append(" WHEN UPPER(DATA_TYPE) = 'LINESTRING' THEN 65535");
        query.append(" WHEN UPPER(DATA_TYPE) = 'POLYGON' THEN 65535");
        query.append(" WHEN UPPER(DATA_TYPE) = 'MULTIPOINT' THEN 65535");
        query.append(" WHEN UPPER(DATA_TYPE) = 'MULTILINESTRING' THEN 65535");
        query.append(" WHEN UPPER(DATA_TYPE) = 'MULTIPOLYGON' THEN 65535");
        query.append(" WHEN UPPER(DATA_TYPE) = 'GEOMETRYCOLLECTION' THEN 65535");
        query.append(" WHEN UPPER(DATA_TYPE) = 'GEOMCOLLECTION' THEN 65535");
        query.append(" WHEN CHARACTER_MAXIMUM_LENGTH IS NULL THEN NUMERIC_PRECISION");
        query.append(" WHEN CHARACTER_MAXIMUM_LENGTH > ").append(Integer.MAX_VALUE).append(" THEN ").append(Integer.MAX_VALUE);
        query.append(" ELSE CHARACTER_MAXIMUM_LENGTH END)");
        return query;
    }

    private StringBuilder appendPrecisionClause(StringBuilder query) {
        boolean supportsFractSeconds = this.getJdbcConnection().getServerVersion().meetsMinimum(ServerVersion.parseVersion("5.6.4"));
        query.append(" CASE WHEN LCASE(DATA_TYPE) = 'date' THEN 0");
        if (supportsFractSeconds) {
            query.append(" WHEN LCASE(DATA_TYPE) = 'time' OR LCASE(DATA_TYPE) = 'datetime' OR LCASE(DATA_TYPE) = 'timestamp' THEN DATETIME_PRECISION");
        } else {
            query.append(" WHEN LCASE(DATA_TYPE) = 'time' OR LCASE(DATA_TYPE) = 'datetime' OR LCASE(DATA_TYPE) = 'timestamp' THEN 0");
        }
        if (this.tinyInt1IsBitValue().booleanValue() && !this.transformedBitIsBooleanValue().booleanValue()) {
            query.append(" WHEN UPPER(DATA_TYPE) = 'TINYINT' AND LOCATE('ZEROFILL', UPPER(DTD_IDENTIFIER)) = 0");
            query.append(" AND LOCATE('UNSIGNED', UPPER(DTD_IDENTIFIER)) = 0 AND LOCATE('(1)', DTD_IDENTIFIER) != 0 THEN 1");
        }
        query.append(" WHEN UPPER(DATA_TYPE) = 'MEDIUMINT' AND LOCATE('UNSIGNED', UPPER(DTD_IDENTIFIER)) != 0 THEN 8");
        query.append(" WHEN UPPER(DATA_TYPE) = 'JSON' THEN 1073741824");
        query.append(" ELSE NUMERIC_PRECISION END");
        return query;
    }

    private StringBuilder appendLengthClause(StringBuilder query) {
        boolean supportsFractSeconds = this.getJdbcConnection().getServerVersion().meetsMinimum(ServerVersion.parseVersion("5.6.4"));
        query.append(" CASE WHEN LCASE(DATA_TYPE) = 'date' THEN 10");
        if (supportsFractSeconds) {
            query.append(" WHEN LCASE(DATA_TYPE) = 'time' THEN 8 + IF(DATETIME_PRECISION > 0, DATETIME_PRECISION + 1, DATETIME_PRECISION)");
            query.append(" WHEN LCASE(DATA_TYPE) = 'datetime' OR LCASE(DATA_TYPE) = 'timestamp' THEN");
            query.append(" 19 + IF(DATETIME_PRECISION > 0, DATETIME_PRECISION + 1, DATETIME_PRECISION)");
        } else {
            query.append(" WHEN LCASE(DATA_TYPE) = 'time' THEN 8");
            query.append(" WHEN LCASE(DATA_TYPE) = 'datetime' OR LCASE(DATA_TYPE) = 'timestamp' THEN 19");
        }
        if (this.tinyInt1IsBitValue().booleanValue() && !this.transformedBitIsBooleanValue().booleanValue()) {
            query.append(" WHEN (UPPER(DATA_TYPE) = 'TINYINT' OR UPPER(DATA_TYPE) = 'TINYINT UNSIGNED')");
            query.append(" AND LOCATE('ZEROFILL', UPPER(DTD_IDENTIFIER)) = 0 AND LOCATE('UNSIGNED', UPPER(DTD_IDENTIFIER)) = 0");
            query.append(" AND LOCATE('(1)', DTD_IDENTIFIER) != 0 THEN 1");
        }
        query.append(" WHEN UPPER(DATA_TYPE) = 'MEDIUMINT' AND LOCATE('UNSIGNED', UPPER(DTD_IDENTIFIER)) != 0 THEN 8");
        query.append(" WHEN UPPER(DATA_TYPE) = 'JSON' THEN 1073741824");
        query.append(" WHEN CHARACTER_MAXIMUM_LENGTH IS NULL THEN NUMERIC_PRECISION");
        query.append(" WHEN CHARACTER_MAXIMUM_LENGTH > ").append(Integer.MAX_VALUE).append(" THEN ").append(Integer.MAX_VALUE);
        query.append(" ELSE CHARACTER_MAXIMUM_LENGTH END");
        return query;
    }

    private StringBuilder appendDecimalDigitsClause(StringBuilder query) {
        query.append(" UPPER(CASE");
        query.append(" WHEN UPPER(DATA_TYPE) = 'DECIMAL' THEN NUMERIC_SCALE");
        query.append(" WHEN UPPER(DATA_TYPE) = 'FLOAT' OR UPPER(DATA_TYPE) = 'DOUBLE' THEN IF(NUMERIC_SCALE IS NULL, 0, NUMERIC_SCALE)");
        query.append(" ELSE NULL END)");
        return query;
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        try {
            if (table == null) {
                throw SQLError.createSQLException(Messages.getString("DatabaseMetaData.2"), "S1009", this.getExceptionInterceptor());
            }
            String dbFilter = this.chooseDatabaseTerm(catalog, schema);
            String tableFilter = this.normalizeIdentifierQuoting(table);
            StringBuilder query = new StringBuilder("SELECT");
            query.append(" ").append(2).append(" AS SCOPE,");
            query.append(" COLUMN_NAME,");
            this.appendDataTypeClause(query, "COLUMN_TYPE").append(" AS DATA_TYPE,");
            this.appendTypeNameClause(query, "COLUMN_TYPE").append(" AS TYPE_NAME,");
            this.appendColumnSizeClause(query).append(" AS COLUMN_SIZE,");
            query.append(" ").append(MAX_BUFFER_SIZE).append(" AS BUFFER_LENGTH,");
            this.appendDecimalDigitsClause(query).append(" AS DECIMAL_DIGITS,");
            query.append(" ").append(1).append(" AS PSEUDO_COLUMN");
            query.append(" FROM INFORMATION_SCHEMA.COLUMNS");
            StringBuilder condition = new StringBuilder();
            if (dbFilter != null) {
                condition.append(" TABLE_SCHEMA = ?");
            }
            if (condition.length() > 0) {
                condition.append(" AND");
            }
            condition.append(" TABLE_NAME = ?");
            condition.append(" AND COLUMN_KEY = 'PRI'");
            query.append(" WHERE").append((CharSequence)condition);
            try (PreparedStatement pStmt = this.prepareMetaDataSafeStatement(query.toString());){
                int nextIdx = 1;
                if (dbFilter != null) {
                    pStmt.setString(nextIdx++, dbFilter);
                }
                pStmt.setString(nextIdx++, tableFilter);
                ResultSet rs = this.executeMetadataQuery(pStmt);
                ((ResultSetInternalMethods)rs).getColumnDefinition().setFields(this.createBestRowIdentifierFields());
                ResultSet resultSet = rs;
                return resultSet;
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        try {
            Statement stmt = this.getJdbcConnection().getMetaDataSafeStatement();
            StringBuilder query = new StringBuilder("SELECT SCHEMA_NAME AS TABLE_CAT FROM INFORMATION_SCHEMA.SCHEMATA");
            if (this.databaseTermValue() != PropertyDefinitions.DatabaseTerm.CATALOG) {
                query.append(" WHERE FALSE");
            }
            query.append(" ORDER BY TABLE_CAT");
            ResultSet rs = stmt.executeQuery(query.toString());
            ((ResultSetInternalMethods)rs).getColumnDefinition().setFields(this.createCatalogsFields());
            return rs;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        try {
            String dbFromTerm = this.chooseDatabaseTerm(catalog, schema);
            String dbFilter = this.normalizeIdentifierQuoting(dbFromTerm);
            String tableFilter = this.normalizeIdentifierQuoting(table);
            String columnNameFilter = this.normalizeIdentifierQuoting(columnNamePattern);
            StringBuilder query = new StringBuilder("SELECT");
            query.append(this.chooseBasedOnDatabaseTerm(() -> " TABLE_SCHEMA, NULL,", () -> " TABLE_CATALOG, TABLE_SCHEMA,"));
            query.append(" TABLE_NAME,");
            query.append(" COLUMN_NAME,");
            query.append(" NULL AS GRANTOR,");
            query.append(" GRANTEE,");
            query.append(" PRIVILEGE_TYPE AS PRIVILEGE,");
            query.append(" IS_GRANTABLE");
            query.append(" FROM INFORMATION_SCHEMA.COLUMN_PRIVILEGES WHERE");
            if (dbFilter != null) {
                query.append(" TABLE_SCHEMA = ? AND");
            }
            query.append(" TABLE_NAME = ?");
            if (columnNamePattern != null) {
                query.append(" AND COLUMN_NAME LIKE ?");
            }
            query.append(" ORDER BY COLUMN_NAME, PRIVILEGE_TYPE");
            try (PreparedStatement pStmt = this.prepareMetaDataSafeStatement(query.toString());){
                int nextIdx = 1;
                pStmt.setString(nextIdx++, dbFilter);
                pStmt.setString(nextIdx++, tableFilter);
                if (columnNameFilter != null) {
                    pStmt.setString(nextIdx, columnNameFilter);
                }
                ResultSet rs = this.executeMetadataQuery(pStmt);
                ((ResultSetInternalMethods)rs).getColumnDefinition().setFields(this.createColumnPrivilegesFields());
                ResultSet resultSet = rs;
                return resultSet;
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        try {
            String dbFilter = this.normalizeIdentifierQuoting(this.chooseDatabaseTerm(catalog, schemaPattern));
            String tableNameFilter = this.normalizeIdentifierQuoting(tableNamePattern);
            String columnNameFilter = this.normalizeIdentifierQuoting(columnNamePattern);
            String infScCollation = this.getInformationSchemaCollation();
            StringBuilder query = new StringBuilder("SELECT");
            query.append(this.chooseBasedOnDatabaseTerm(() -> " TABLE_SCHEMA, NULL,", () -> " TABLE_CATALOG, TABLE_SCHEMA,"));
            query.append(" TABLE_NAME,");
            query.append(" COLUMN_NAME,");
            this.appendDataTypeClause(query, "COLUMN_TYPE").append(" AS DATA_TYPE,");
            this.appendTypeNameClause(query, "COLUMN_TYPE").append(" AS TYPE_NAME,");
            this.appendColumnSizeClause(query).append(" AS COLUMN_SIZE,");
            query.append(" ").append(MAX_BUFFER_SIZE).append(" AS BUFFER_LENGTH,");
            this.appendDecimalDigitsClause(query).append(" AS DECIMAL_DIGITS,");
            query.append(" 10 AS NUM_PREC_RADIX,");
            query.append(" CASE WHEN IS_NULLABLE COLLATE " + infScCollation + "= 'NO' THEN ").append(0);
            query.append(" ELSE CASE WHEN IS_NULLABLE COLLATE " + infScCollation + "= 'YES' THEN ").append(1);
            query.append(" ELSE ").append(2).append(" END END AS NULLABLE,");
            query.append(" COLUMN_COMMENT AS REMARKS,");
            query.append(" COLUMN_DEFAULT AS COLUMN_DEF,");
            query.append(" 0 AS SQL_DATA_TYPE,");
            query.append(" 0 AS SQL_DATETIME_SUB,");
            query.append(" CASE WHEN CHARACTER_OCTET_LENGTH > ").append(Integer.MAX_VALUE).append(" THEN ").append(Integer.MAX_VALUE);
            query.append(" ELSE CHARACTER_OCTET_LENGTH END AS CHAR_OCTET_LENGTH,");
            query.append(" ORDINAL_POSITION,");
            query.append(" IS_NULLABLE,");
            query.append(" NULL AS SCOPE_CATALOG,");
            query.append(" NULL AS SCOPE_SCHEMA,");
            query.append(" NULL AS SCOPE_TABLE,");
            query.append(" NULL AS SOURCE_DATA_TYPE,");
            query.append(" IF (EXTRA COLLATE " + infScCollation + " LIKE '%auto_increment%','YES','NO') AS IS_AUTOINCREMENT,");
            query.append(" IF (EXTRA COLLATE " + infScCollation + " LIKE  '%GENERATED%','YES','NO') AS IS_GENERATEDCOLUMN");
            query.append(" FROM INFORMATION_SCHEMA.COLUMNS");
            StringBuilder condition = new StringBuilder();
            if (dbFilter != null) {
                condition.append(this.chooseBasedOnDatabaseTerm(() -> " TABLE_SCHEMA = ?", () -> StringUtils.hasWildcards(dbFilter) ? " TABLE_SCHEMA LIKE ?" : " TABLE_SCHEMA = ?"));
            }
            if (tableNameFilter != null) {
                if (condition.length() > 0) {
                    condition.append(" AND");
                }
                condition.append(StringUtils.hasWildcards(tableNameFilter) ? " TABLE_NAME LIKE ?" : " TABLE_NAME = ?");
            }
            if (columnNameFilter != null) {
                if (condition.length() > 0) {
                    condition.append(" AND");
                }
                condition.append(StringUtils.hasWildcards(columnNameFilter) ? " COLUMN_NAME LIKE ?" : " COLUMN_NAME = ?");
            }
            if (condition.length() > 0) {
                query.append(" WHERE");
                query.append((CharSequence)condition);
            }
            query.append(" ORDER BY TABLE_SCHEMA, TABLE_NAME, ORDINAL_POSITION");
            try (PreparedStatement pStmt = this.prepareMetaDataSafeStatement(query.toString());){
                int nextIdx = 1;
                if (dbFilter != null) {
                    pStmt.setString(nextIdx++, dbFilter);
                }
                if (tableNameFilter != null) {
                    pStmt.setString(nextIdx++, tableNameFilter);
                }
                if (columnNameFilter != null) {
                    pStmt.setString(nextIdx, columnNameFilter);
                }
                ResultSet rs = this.executeMetadataQuery(pStmt);
                ((ResultSetInternalMethods)rs).getColumnDefinition().setFields(this.createColumnsFields());
                ResultSet resultSet = rs;
                return resultSet;
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        try {
            if (parentTable == null || foreignTable == null) {
                throw SQLError.createSQLException(Messages.getString("DatabaseMetaData.2"), "S1009", this.getExceptionInterceptor());
            }
            String parentDbFromTerm = this.chooseDatabaseTerm(parentCatalog, parentSchema);
            String parentDbFilter = this.normalizeIdentifierQuoting(parentDbFromTerm);
            String parentTableFilter = this.normalizeIdentifierQuoting(parentTable);
            String foreignDbFilter = this.chooseDatabaseTerm(foreignCatalog, foreignSchema);
            String foreignTableFilter = this.normalizeIdentifierQuoting(foreignTable);
            StringBuilder query = new StringBuilder("SELECT DISTINCT");
            query.append(this.chooseBasedOnDatabaseTerm(() -> " A.REFERENCED_TABLE_SCHEMA AS PKTABLE_CAT, NULL AS PKTABLE_SCHEM,", () -> " A.CONSTRAINT_CATALOG AS PKTABLE_CAT, A.REFERENCED_TABLE_SCHEMA AS PKTABLE_SCHEM,"));
            query.append(" A.REFERENCED_TABLE_NAME AS PKTABLE_NAME,");
            query.append(" A.REFERENCED_COLUMN_NAME AS PKCOLUMN_NAME,");
            query.append(this.chooseBasedOnDatabaseTerm(() -> " A.TABLE_SCHEMA AS FKTABLE_CAT, NULL AS FKTABLE_SCHEM,", () -> " A.TABLE_CATALOG AS FKTABLE_CAT, A.TABLE_SCHEMA AS FKTABLE_SCHEM,"));
            query.append(" A.TABLE_NAME AS FKTABLE_NAME,");
            query.append(" A.COLUMN_NAME AS FKCOLUMN_NAME,");
            query.append(" A.ORDINAL_POSITION AS KEY_SEQ,");
            this.appendUpdateRuleClause(query).append(" AS UPDATE_RULE,");
            this.appendDeleteRuleClause(query).append(" AS DELETE_RULE,");
            query.append(" A.CONSTRAINT_NAME AS FK_NAME,");
            query.append(" TC.CONSTRAINT_NAME AS PK_NAME,");
            query.append(" ").append(7).append(" AS DEFERRABILITY");
            query.append(" FROM INFORMATION_SCHEMA.KEY_COLUMN_USAGE A JOIN INFORMATION_SCHEMA.TABLE_CONSTRAINTS B");
            query.append(" USING (TABLE_SCHEMA, TABLE_NAME, CONSTRAINT_NAME)");
            this.appendOptionalRefContraintsJoin(query);
            query.append(" LEFT JOIN INFORMATION_SCHEMA.TABLE_CONSTRAINTS TC ON (A.REFERENCED_TABLE_SCHEMA = TC.TABLE_SCHEMA");
            query.append(" AND A.REFERENCED_TABLE_NAME = TC.TABLE_NAME AND TC.CONSTRAINT_TYPE IN ('UNIQUE', 'PRIMARY KEY'))");
            query.append(" WHERE B.CONSTRAINT_TYPE = 'FOREIGN KEY'");
            if (parentDbFilter != null) {
                query.append(" AND A.REFERENCED_TABLE_SCHEMA = ?");
            }
            query.append(" AND A.REFERENCED_TABLE_NAME = ?");
            if (foreignDbFilter != null) {
                query.append(" AND A.TABLE_SCHEMA = ?");
            }
            query.append(" AND A.TABLE_NAME = ?");
            query.append(" ORDER BY FKTABLE_CAT, FKTABLE_SCHEM, FKTABLE_NAME, KEY_SEQ");
            try (PreparedStatement pStmt = this.prepareMetaDataSafeStatement(query.toString());){
                int nextIdx = 1;
                if (parentDbFilter != null) {
                    pStmt.setString(nextIdx++, parentDbFilter);
                }
                pStmt.setString(nextIdx++, parentTableFilter);
                if (foreignDbFilter != null) {
                    pStmt.setString(nextIdx++, foreignDbFilter);
                }
                pStmt.setString(nextIdx, foreignTableFilter);
                ResultSet rs = this.executeMetadataQuery(pStmt);
                ((ResultSetInternalMethods)rs).getColumnDefinition().setFields(this.createForeignKeysFields());
                ResultSet resultSet = rs;
                return resultSet;
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        try {
            if (table == null) {
                throw SQLError.createSQLException(Messages.getString("DatabaseMetaData.2"), "S1009", this.getExceptionInterceptor());
            }
            String dbFromTerm = this.chooseDatabaseTerm(catalog, schema);
            String dbFilter = this.normalizeIdentifierQuoting(dbFromTerm);
            String tableFilter = this.normalizeIdentifierQuoting(table);
            StringBuilder query = new StringBuilder("SELECT DISTINCT");
            query.append(this.chooseBasedOnDatabaseTerm(() -> " A.REFERENCED_TABLE_SCHEMA AS PKTABLE_CAT, NULL AS PKTABLE_SCHEM,", () -> " A.CONSTRAINT_CATALOG AS PKTABLE_CAT, A.REFERENCED_TABLE_SCHEMA AS PKTABLE_SCHEM,"));
            query.append(" A.REFERENCED_TABLE_NAME AS PKTABLE_NAME,");
            query.append(" A.REFERENCED_COLUMN_NAME AS PKCOLUMN_NAME,");
            query.append(this.chooseBasedOnDatabaseTerm(() -> " A.TABLE_SCHEMA AS FKTABLE_CAT, NULL AS FKTABLE_SCHEM,", () -> " A.TABLE_CATALOG AS FKTABLE_CAT, A.TABLE_SCHEMA AS FKTABLE_SCHEM,"));
            query.append(" A.TABLE_NAME AS FKTABLE_NAME,");
            query.append(" A.COLUMN_NAME AS FKCOLUMN_NAME,");
            query.append(" A.ORDINAL_POSITION AS KEY_SEQ,");
            this.appendUpdateRuleClause(query).append(" AS UPDATE_RULE,");
            this.appendDeleteRuleClause(query).append(" AS DELETE_RULE,");
            query.append(" A.CONSTRAINT_NAME AS FK_NAME,");
            query.append(" TC.CONSTRAINT_NAME AS PK_NAME,");
            query.append(" ").append(7).append(" AS DEFERRABILITY");
            query.append(" FROM INFORMATION_SCHEMA.KEY_COLUMN_USAGE A JOIN INFORMATION_SCHEMA.TABLE_CONSTRAINTS B");
            query.append(" USING (TABLE_SCHEMA, TABLE_NAME, CONSTRAINT_NAME)");
            this.appendOptionalRefContraintsJoin(query);
            query.append(" LEFT JOIN INFORMATION_SCHEMA.TABLE_CONSTRAINTS TC ON (A.REFERENCED_TABLE_SCHEMA = TC.TABLE_SCHEMA");
            query.append(" AND A.REFERENCED_TABLE_NAME = TC.TABLE_NAME AND TC.CONSTRAINT_TYPE IN ('UNIQUE', 'PRIMARY KEY'))");
            query.append(" WHERE B.CONSTRAINT_TYPE = 'FOREIGN KEY'");
            if (dbFilter != null) {
                query.append(" AND A.REFERENCED_TABLE_SCHEMA = ?");
            }
            query.append(" AND A.REFERENCED_TABLE_NAME = ?");
            query.append(" ORDER BY FKTABLE_CAT, FKTABLE_SCHEM, FKTABLE_NAME, KEY_SEQ");
            try (PreparedStatement pStmt = this.prepareMetaDataSafeStatement(query.toString());){
                int nextIdx = 1;
                if (dbFilter != null) {
                    pStmt.setString(nextIdx++, dbFilter);
                }
                pStmt.setString(nextIdx, tableFilter);
                ResultSet rs = this.executeMetadataQuery(pStmt);
                ((ResultSetInternalMethods)rs).getColumnDefinition().setFields(this.createForeignKeysFields());
                ResultSet resultSet = rs;
                return resultSet;
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        try {
            String dbFromTerm = this.chooseDatabaseTerm(catalog, schemaPattern);
            String dbFilter = this.normalizeIdentifierQuoting(dbFromTerm);
            String functionNameFilter = this.normalizeIdentifierQuoting(functionNamePattern);
            String columnNameFilter = this.normalizeIdentifierQuoting(columnNamePattern);
            StringBuilder query = new StringBuilder("SELECT");
            query.append(this.chooseBasedOnDatabaseTerm(() -> " SPECIFIC_SCHEMA AS FUNCTION_CAT, NULL AS FUNCTION_SCHEM,", () -> " SPECIFIC_CATALOG AS FUNCTION_CAT, SPECIFIC_SCHEMA AS FUNCTION_SCHEM,"));
            query.append(" SPECIFIC_NAME AS FUNCTION_NAME,");
            query.append(" IFNULL(PARAMETER_NAME, '') AS COLUMN_NAME,");
            query.append(" CASE WHEN PARAMETER_MODE = 'IN' THEN ").append(1);
            query.append(" WHEN PARAMETER_MODE = 'OUT' THEN ").append(3);
            query.append(" WHEN PARAMETER_MODE = 'INOUT' THEN ").append(2);
            query.append(" WHEN ORDINAL_POSITION = 0 THEN ").append(4);
            query.append(" ELSE ").append(0).append(" END AS COLUMN_TYPE,");
            this.appendDataTypeClause(query, "DTD_IDENTIFIER").append(" AS DATA_TYPE,");
            this.appendTypeNameClause(query, "DTD_IDENTIFIER").append(" AS TYPE_NAME,");
            this.appendPrecisionClause(query).append(" AS `PRECISION`,");
            this.appendLengthClause(query).append(" AS LENGTH,");
            query.append(" NUMERIC_SCALE AS SCALE,");
            query.append(" 10 AS RADIX,");
            query.append(" ").append(1).append(" AS NULLABLE,");
            query.append(" NULL AS REMARKS,");
            query.append(" CASE WHEN CHARACTER_OCTET_LENGTH > ").append(Integer.MAX_VALUE).append(" THEN ").append(Integer.MAX_VALUE);
            query.append(" ELSE CHARACTER_OCTET_LENGTH END AS CHAR_OCTET_LENGTH,");
            query.append(" ORDINAL_POSITION,");
            query.append(" 'YES' AS IS_NULLABLE,");
            query.append(" SPECIFIC_NAME");
            query.append(" FROM INFORMATION_SCHEMA.PARAMETERS WHERE");
            StringBuilder condition = new StringBuilder();
            if (dbFilter != null) {
                condition.append(this.chooseBasedOnDatabaseTerm(() -> " SPECIFIC_SCHEMA = ?", () -> " SPECIFIC_SCHEMA LIKE ?"));
            }
            if (functionNameFilter != null) {
                if (condition.length() > 0) {
                    condition.append(" AND");
                }
                condition.append(" SPECIFIC_NAME LIKE ?");
            }
            if (columnNameFilter != null) {
                if (condition.length() > 0) {
                    condition.append(" AND");
                }
                condition.append(" (PARAMETER_NAME LIKE ? OR PARAMETER_NAME IS NULL)");
            }
            if (condition.length() > 0) {
                condition.append(" AND");
            }
            condition.append(" ROUTINE_TYPE = 'FUNCTION'");
            query.append((CharSequence)condition);
            query.append(" ORDER BY SPECIFIC_SCHEMA, SPECIFIC_NAME, ORDINAL_POSITION");
            try (PreparedStatement pStmt = this.prepareMetaDataSafeStatement(query.toString());){
                int nextIdx = 1;
                if (dbFilter != null) {
                    pStmt.setString(nextIdx++, dbFilter);
                }
                if (functionNameFilter != null) {
                    pStmt.setString(nextIdx++, functionNameFilter);
                }
                if (columnNameFilter != null) {
                    pStmt.setString(nextIdx, columnNameFilter);
                }
                ResultSet rs = this.executeMetadataQuery(pStmt);
                ((ResultSetInternalMethods)rs).getColumnDefinition().setFields(this.createFunctionColumnsFields());
                ResultSet resultSet = rs;
                return resultSet;
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        try {
            String dbFromTerm = this.chooseDatabaseTerm(catalog, schemaPattern);
            String dbFilter = this.normalizeIdentifierQuoting(dbFromTerm);
            String functionNameFilter = this.normalizeIdentifierQuoting(functionNamePattern);
            StringBuilder query = new StringBuilder("SELECT");
            query.append(this.chooseBasedOnDatabaseTerm(() -> " ROUTINE_SCHEMA AS FUNCTION_CAT, NULL AS FUNCTION_SCHEM,", () -> " ROUTINE_CATALOG AS FUNCTION_CAT, ROUTINE_SCHEMA AS FUNCTION_SCHEM,"));
            query.append(" ROUTINE_NAME AS FUNCTION_NAME,");
            query.append(" ROUTINE_COMMENT AS REMARKS,");
            query.append(" ").append(1).append(" AS FUNCTION_TYPE,");
            query.append(" ROUTINE_NAME AS SPECIFIC_NAME");
            query.append(" FROM INFORMATION_SCHEMA.ROUTINES");
            query.append(" WHERE ROUTINE_TYPE LIKE 'FUNCTION'");
            if (dbFilter != null) {
                query.append(this.chooseBasedOnDatabaseTerm(() -> " AND ROUTINE_SCHEMA = ?", () -> " AND ROUTINE_SCHEMA LIKE ?"));
            }
            if (functionNameFilter != null) {
                query.append(" AND ROUTINE_NAME LIKE ?");
            }
            query.append(" ORDER BY FUNCTION_CAT, FUNCTION_SCHEM, FUNCTION_NAME, SPECIFIC_NAME");
            try (PreparedStatement pStmt = this.prepareMetaDataSafeStatement(query.toString());){
                int nextIdx = 1;
                if (dbFilter != null) {
                    pStmt.setString(nextIdx++, dbFilter);
                }
                if (functionNameFilter != null) {
                    pStmt.setString(nextIdx, functionNameFilter);
                }
                ResultSet rs = this.executeMetadataQuery(pStmt);
                ((ResultSetInternalMethods)rs).getColumnDefinition().setFields(this.createFunctionsFields());
                ResultSet resultSet = rs;
                return resultSet;
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        try {
            if (table == null) {
                throw SQLError.createSQLException(Messages.getString("DatabaseMetaData.2"), "S1009", this.getExceptionInterceptor());
            }
            String dbFromTerm = this.chooseDatabaseTerm(catalog, schema);
            String dbFilter = this.normalizeIdentifierQuoting(dbFromTerm);
            String tableFilter = this.normalizeIdentifierQuoting(table);
            StringBuilder query = new StringBuilder("SELECT DISTINCT");
            query.append(this.chooseBasedOnDatabaseTerm(() -> " A.REFERENCED_TABLE_SCHEMA AS PKTABLE_CAT, NULL AS PKTABLE_SCHEM,", () -> " A.CONSTRAINT_CATALOG AS PKTABLE_CAT, A.REFERENCED_TABLE_SCHEMA AS PKTABLE_SCHEM,"));
            query.append(" A.REFERENCED_TABLE_NAME AS PKTABLE_NAME,");
            query.append(" A.REFERENCED_COLUMN_NAME AS PKCOLUMN_NAME,");
            query.append(this.chooseBasedOnDatabaseTerm(() -> " A.TABLE_SCHEMA AS FKTABLE_CAT, NULL AS FKTABLE_SCHEM,", () -> " A.TABLE_CATALOG AS FKTABLE_CAT, A.TABLE_SCHEMA AS FKTABLE_SCHEM,"));
            query.append(" A.TABLE_NAME AS FKTABLE_NAME,");
            query.append(" A.COLUMN_NAME AS FKCOLUMN_NAME,");
            query.append(" A.ORDINAL_POSITION AS KEY_SEQ,");
            this.appendUpdateRuleClause(query).append(" AS UPDATE_RULE,");
            this.appendDeleteRuleClause(query).append(" AS DELETE_RULE,");
            query.append(" A.CONSTRAINT_NAME AS FK_NAME,");
            query.append(" R.UNIQUE_CONSTRAINT_NAME AS PK_NAME,");
            query.append(" ").append(7).append(" AS DEFERRABILITY");
            query.append(" FROM INFORMATION_SCHEMA.KEY_COLUMN_USAGE A");
            query.append(" JOIN INFORMATION_SCHEMA.TABLE_CONSTRAINTS B USING (CONSTRAINT_SCHEMA, CONSTRAINT_NAME, TABLE_NAME)");
            this.appendOptionalRefContraintsJoin(query);
            query.append("WHERE B.CONSTRAINT_TYPE = 'FOREIGN KEY'");
            if (dbFilter != null) {
                query.append(" AND A.TABLE_SCHEMA = ?");
            }
            query.append(" AND A.TABLE_NAME = ?");
            query.append(" AND A.REFERENCED_TABLE_SCHEMA IS NOT NULL");
            query.append(" ORDER BY A.REFERENCED_TABLE_SCHEMA, A.REFERENCED_TABLE_NAME, A.ORDINAL_POSITION");
            try (PreparedStatement pStmt = this.prepareMetaDataSafeStatement(query.toString());){
                int nextIdx = 1;
                if (dbFilter != null) {
                    pStmt.setString(nextIdx++, dbFilter);
                }
                pStmt.setString(nextIdx, tableFilter);
                ResultSet rs = this.executeMetadataQuery(pStmt);
                ((ResultSetInternalMethods)rs).getColumnDefinition().setFields(this.createForeignKeysFields());
                ResultSet resultSet = rs;
                return resultSet;
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        try {
            if (table == null) {
                throw SQLError.createSQLException(Messages.getString("DatabaseMetaData.2"), "S1009", this.getExceptionInterceptor());
            }
            String dbFromTerm = this.chooseDatabaseTerm(catalog, schema);
            String dbFilter = this.normalizeIdentifierQuoting(dbFromTerm);
            String tableFilter = this.normalizeIdentifierQuoting(table);
            StringBuilder query = new StringBuilder("SELECT");
            query.append(this.chooseBasedOnDatabaseTerm(() -> " TABLE_SCHEMA AS TABLE_CAT, NULL AS TABLE_SCHEM,", () -> " TABLE_CATALOG AS TABLE_CAT, TABLE_SCHEMA AS TABLE_SCHEM,"));
            query.append(" TABLE_NAME,");
            query.append(" NON_UNIQUE,");
            query.append(" NULL AS INDEX_QUALIFIER,");
            query.append(" INDEX_NAME,");
            query.append(" ").append(3).append(" AS TYPE,");
            query.append(" SEQ_IN_INDEX AS ORDINAL_POSITION,");
            query.append(" COLUMN_NAME,");
            query.append(" COLLATION AS ASC_OR_DESC,");
            query.append(" CARDINALITY,");
            query.append(" 0 AS PAGES,");
            query.append(" NULL AS FILTER_CONDITION");
            query.append(" FROM INFORMATION_SCHEMA.STATISTICS WHERE");
            if (dbFilter != null) {
                query.append(" TABLE_SCHEMA = ? AND");
            }
            query.append(" TABLE_NAME = ?");
            if (unique) {
                query.append(" AND NON_UNIQUE = 0");
            }
            query.append(" ORDER BY NON_UNIQUE, INDEX_NAME, SEQ_IN_INDEX");
            try (PreparedStatement pStmt = this.prepareMetaDataSafeStatement(query.toString());){
                int nextIdx = 1;
                if (dbFilter != null) {
                    pStmt.setString(nextIdx++, dbFilter);
                }
                pStmt.setString(nextIdx, tableFilter);
                ResultSet rs = this.executeMetadataQuery(pStmt);
                ((ResultSetInternalMethods)rs).getColumnDefinition().setFields(this.createIndexInfoFields());
                ResultSet resultSet = rs;
                return resultSet;
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        try {
            if (table == null) {
                throw SQLError.createSQLException(Messages.getString("DatabaseMetaData.2"), "S1009", this.getExceptionInterceptor());
            }
            String dbFromTerm = this.chooseDatabaseTerm(catalog, schema);
            String dbFilter = this.normalizeIdentifierQuoting(dbFromTerm);
            String tableFilter = this.normalizeIdentifierQuoting(table);
            StringBuilder query = new StringBuilder("SELECT");
            query.append(this.chooseBasedOnDatabaseTerm(() -> " TABLE_SCHEMA AS TABLE_CAT, NULL AS TABLE_SCHEM,", () -> " TABLE_CATALOG AS TABLE_CAT, TABLE_SCHEMA AS TABLE_SCHEM,"));
            query.append(" TABLE_NAME,");
            query.append(" COLUMN_NAME,");
            query.append(" SEQ_IN_INDEX AS KEY_SEQ,");
            query.append(" 'PRIMARY' AS PK_NAME");
            query.append(" FROM INFORMATION_SCHEMA.STATISTICS WHERE");
            if (dbFilter != null) {
                query.append(" TABLE_SCHEMA = ? AND");
            }
            query.append(" TABLE_NAME = ?");
            query.append(" AND INDEX_NAME = 'PRIMARY' ORDER BY TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME, SEQ_IN_INDEX");
            try (PreparedStatement pStmt = this.prepareMetaDataSafeStatement(query.toString());){
                int nextIdx = 1;
                if (dbFilter != null) {
                    pStmt.setString(nextIdx++, dbFilter);
                }
                pStmt.setString(nextIdx, tableFilter);
                ResultSet rs = this.executeMetadataQuery(pStmt);
                ((ResultSetInternalMethods)rs).getColumnDefinition().setFields(this.createPrimaryKeysFields());
                ResultSet resultSet = rs;
                return resultSet;
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        try {
            String dbFromTerm = this.chooseDatabaseTerm(catalog, schemaPattern);
            String dbFilter = this.normalizeIdentifierQuoting(dbFromTerm);
            String procedureNameFilter = this.normalizeIdentifierQuoting(procedureNamePattern);
            String columnNameFilter = this.normalizeIdentifierQuoting(columnNamePattern);
            StringBuilder query = new StringBuilder("SELECT");
            query.append(this.chooseBasedOnDatabaseTerm(() -> " SPECIFIC_SCHEMA AS PROCEDURE_CAT, NULL AS PROCEDURE_SCHEM,", () -> " SPECIFIC_CATALOG AS PROCEDURE_CAT, SPECIFIC_SCHEMA AS PROCEDURE_SCHEM,"));
            query.append(" SPECIFIC_NAME AS PROCEDURE_NAME,");
            query.append(" IFNULL(PARAMETER_NAME, '') AS COLUMN_NAME,");
            query.append(" CASE WHEN PARAMETER_MODE = 'IN' THEN ").append(1);
            query.append(" WHEN PARAMETER_MODE = 'OUT' THEN ").append(4);
            query.append(" WHEN PARAMETER_MODE = 'INOUT' THEN ").append(2);
            query.append(" WHEN ORDINAL_POSITION = 0 THEN ").append(5);
            query.append(" ELSE ").append(0).append(" END AS COLUMN_TYPE,");
            this.appendDataTypeClause(query, "DTD_IDENTIFIER").append(" AS DATA_TYPE,");
            this.appendTypeNameClause(query, "DTD_IDENTIFIER").append(" AS TYPE_NAME,");
            this.appendPrecisionClause(query).append(" AS `PRECISION`,");
            this.appendLengthClause(query).append(" AS LENGTH,");
            query.append(" NUMERIC_SCALE AS SCALE,");
            query.append(" 10 AS RADIX,");
            query.append(" ").append(1).append(" AS NULLABLE,");
            query.append(" NULL AS REMARKS,");
            query.append(" NULL AS COLUMN_DEF,");
            query.append(" NULL AS SQL_DATA_TYPE,");
            query.append(" NULL AS SQL_DATETIME_SUB,");
            query.append(" CASE WHEN CHARACTER_OCTET_LENGTH > ").append(Integer.MAX_VALUE).append(" THEN ").append(Integer.MAX_VALUE);
            query.append(" ELSE CHARACTER_OCTET_LENGTH END AS CHAR_OCTET_LENGTH,");
            query.append(" ORDINAL_POSITION,");
            query.append(" 'YES' AS IS_NULLABLE,");
            query.append(" SPECIFIC_NAME");
            query.append(" FROM INFORMATION_SCHEMA.PARAMETERS");
            StringBuilder condition = new StringBuilder();
            if (!this.getProceduresReturnsFunctionsValue().booleanValue()) {
                condition.append(" ROUTINE_TYPE = 'PROCEDURE'");
            }
            if (dbFilter != null) {
                if (condition.length() > 0) {
                    condition.append(" AND");
                }
                condition.append(this.chooseBasedOnDatabaseTerm(() -> " SPECIFIC_SCHEMA = ?", () -> " SPECIFIC_SCHEMA LIKE ?"));
            }
            if (procedureNameFilter != null) {
                if (condition.length() > 0) {
                    condition.append(" AND");
                }
                condition.append(" SPECIFIC_NAME LIKE ?");
            }
            if (columnNameFilter != null) {
                if (condition.length() > 0) {
                    condition.append(" AND");
                }
                condition.append(" (PARAMETER_NAME LIKE ? OR PARAMETER_NAME IS NULL)");
            }
            if (condition.length() > 0) {
                query.append(" WHERE");
                query.append((CharSequence)condition);
            }
            query.append(" ORDER BY SPECIFIC_SCHEMA, SPECIFIC_NAME, ROUTINE_TYPE, ORDINAL_POSITION");
            try (PreparedStatement pStmt = this.prepareMetaDataSafeStatement(query.toString());){
                int nextIdx = 1;
                if (dbFilter != null) {
                    pStmt.setString(nextIdx++, dbFilter);
                }
                if (procedureNameFilter != null) {
                    pStmt.setString(nextIdx++, procedureNameFilter);
                }
                if (columnNameFilter != null) {
                    pStmt.setString(nextIdx, columnNameFilter);
                }
                ResultSet rs = this.executeMetadataQuery(pStmt);
                ((ResultSetInternalMethods)rs).getColumnDefinition().setFields(this.createProcedureColumnsFields());
                ResultSet resultSet = rs;
                return resultSet;
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        try {
            String dbFromTerm = this.chooseDatabaseTerm(catalog, schemaPattern);
            String dbFilter = this.normalizeIdentifierQuoting(dbFromTerm);
            String procedureNameFilter = this.normalizeIdentifierQuoting(procedureNamePattern);
            StringBuilder query = new StringBuilder("SELECT");
            query.append(this.chooseBasedOnDatabaseTerm(() -> " ROUTINE_SCHEMA AS PROCEDURE_CAT, NULL AS PROCEDURE_SCHEM,", () -> " ROUTINE_CATALOG AS PROCEDURE_CAT, ROUTINE_SCHEMA AS PROCEDURE_SCHEM,"));
            query.append(" ROUTINE_NAME AS PROCEDURE_NAME,");
            query.append(" NULL AS RESERVED_1,");
            query.append(" NULL AS RESERVED_2,");
            query.append(" NULL AS RESERVED_3,");
            query.append(" ROUTINE_COMMENT AS REMARKS,");
            query.append(" CASE WHEN ROUTINE_TYPE = 'PROCEDURE' THEN ").append(1);
            query.append(" WHEN ROUTINE_TYPE = 'FUNCTION' THEN ").append(2);
            query.append(" ELSE ").append(0).append(" END AS PROCEDURE_TYPE,");
            query.append(" ROUTINE_NAME AS SPECIFIC_NAME");
            query.append(" FROM INFORMATION_SCHEMA.ROUTINES");
            StringBuilder condition = new StringBuilder();
            if (!this.getProceduresReturnsFunctionsValue().booleanValue()) {
                condition.append(" ROUTINE_TYPE = 'PROCEDURE'");
            }
            if (dbFilter != null) {
                if (condition.length() > 0) {
                    condition.append(" AND");
                }
                condition.append(this.chooseBasedOnDatabaseTerm(() -> " ROUTINE_SCHEMA = ?", () -> " ROUTINE_SCHEMA LIKE ?"));
            }
            if (procedureNameFilter != null) {
                if (condition.length() > 0) {
                    condition.append(" AND");
                }
                condition.append(" ROUTINE_NAME LIKE ?");
            }
            if (condition.length() > 0) {
                query.append(" WHERE");
                query.append((CharSequence)condition);
            }
            query.append(" ORDER BY ROUTINE_SCHEMA, ROUTINE_NAME, ROUTINE_TYPE");
            try (PreparedStatement pStmt = this.prepareMetaDataSafeStatement(query.toString());){
                int nextIdx = 1;
                if (dbFilter != null) {
                    pStmt.setString(nextIdx++, dbFilter);
                }
                if (procedureNameFilter != null) {
                    pStmt.setString(nextIdx, procedureNameFilter);
                }
                ResultSet rs = this.executeMetadataQuery(pStmt);
                ((ResultSetInternalMethods)rs).getColumnDefinition().setFields(this.createProceduresFields());
                ResultSet resultSet = rs;
                return resultSet;
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        try {
            String dbFromTerm = this.chooseDatabaseTerm(null, schemaPattern);
            String dbFilter = this.normalizeIdentifierQuoting(dbFromTerm);
            StringBuilder query = new StringBuilder("SELECT");
            query.append(" SCHEMA_NAME AS TABLE_SCHEM,");
            query.append(" CATALOG_NAME AS TABLE_CATALOG");
            query.append(" FROM INFORMATION_SCHEMA.SCHEMATA");
            query.append(this.chooseBasedOnDatabaseTerm(() -> " WHERE FALSE", () -> dbFilter == null ? "" : (StringUtils.hasWildcards(dbFilter) ? " WHERE SCHEMA_NAME LIKE ?" : " WHERE SCHEMA_NAME = ?")));
            query.append(" ORDER BY TABLE_CATALOG, TABLE_SCHEM");
            try (PreparedStatement pStmt = this.prepareMetaDataSafeStatement(query.toString());){
                if (dbFilter != null) {
                    pStmt.setString(1, dbFilter);
                }
                ResultSet rs = this.executeMetadataQuery(pStmt);
                ((ResultSetInternalMethods)rs).getColumnDefinition().setFields(this.createSchemasFields());
                ResultSet resultSet = rs;
                return resultSet;
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSQLKeywords() throws SQLException {
        try {
            if (!this.getJdbcConnection().getServerVersion().meetsMinimum(ServerVersion.parseVersion("8.0.11"))) {
                return super.getSQLKeywords();
            }
            String keywords = (String)keywordsCache.get(this.getJdbcConnection().getServerVersion());
            if (keywords != null) {
                return keywords;
            }
            KEYWORDS_CACHE_LOCK.lock();
            try {
                keywords = (String)keywordsCache.get(this.getJdbcConnection().getServerVersion());
                if (keywords != null) {
                    String string = keywords;
                    return string;
                }
                ArrayList<String> keywordsFromServer = new ArrayList<String>();
                Statement stmt = this.getJdbcConnection().getMetaDataSafeStatement();
                ResultSet rs = stmt.executeQuery("SELECT WORD FROM INFORMATION_SCHEMA.KEYWORDS WHERE RESERVED = 1 ORDER BY WORD");
                while (rs.next()) {
                    keywordsFromServer.add(rs.getString(1));
                }
                stmt.close();
                keywordsFromServer.removeAll(SQL2003_KEYWORDS);
                keywords = keywordsFromServer.stream().collect(Collectors.joining(","));
                keywordsCache.put(this.getJdbcConnection().getServerVersion(), keywords);
                String string = keywords;
                return string;
            }
            finally {
                KEYWORDS_CACHE_LOCK.unlock();
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        try {
            String dbFromTerm = this.chooseDatabaseTerm(catalog, schemaPattern);
            String dbFilter = this.normalizeIdentifierQuoting(dbFromTerm);
            String tableNameFilter = this.normalizeIdentifierQuoting(tableNamePattern);
            StringBuilder query = new StringBuilder("SELECT");
            query.append(this.chooseBasedOnDatabaseTerm(() -> " TABLE_SCHEMA AS TABLE_CAT, NULL AS TABLE_SCHEM,", () -> " TABLE_CATALOG AS TABLE_CAT, TABLE_SCHEMA AS TABLE_SCHEM,"));
            query.append(" TABLE_NAME,");
            query.append(" NULL AS GRANTOR,");
            query.append(" GRANTEE,");
            query.append(" PRIVILEGE_TYPE AS PRIVILEGE,");
            query.append(" IS_GRANTABLE");
            query.append(" FROM INFORMATION_SCHEMA.TABLE_PRIVILEGES");
            StringBuilder condition = new StringBuilder();
            if (dbFilter != null) {
                condition.append(this.chooseBasedOnDatabaseTerm(() -> " TABLE_SCHEMA = ?", () -> StringUtils.hasWildcards(dbFilter) ? " TABLE_SCHEMA LIKE ?" : " TABLE_SCHEMA = ?"));
            }
            if (tableNameFilter != null) {
                if (condition.length() > 0) {
                    condition.append(" AND");
                }
                condition.append(StringUtils.hasWildcards(tableNameFilter) ? " TABLE_NAME LIKE ?" : " TABLE_NAME = ?");
            }
            if (condition.length() > 0) {
                query.append(" WHERE");
                query.append((CharSequence)condition);
            }
            try (PreparedStatement pStmt = this.prepareMetaDataSafeStatement(query.toString());){
                int nextIdx = 1;
                if (dbFilter != null) {
                    pStmt.setString(nextIdx++, dbFilter);
                }
                if (tableNameFilter != null) {
                    pStmt.setString(nextIdx++, tableNameFilter);
                }
                ResultSet rs = this.executeMetadataQuery(pStmt);
                ((ResultSetInternalMethods)rs).getColumnDefinition().setFields(this.createTablePrivilegesFields());
                ResultSet resultSet = rs;
                return resultSet;
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        try {
            String dbFilter = this.normalizeIdentifierQuoting(this.chooseDatabaseTerm(catalog, schemaPattern));
            String tableNameFilter = this.normalizeIdentifierQuoting(tableNamePattern);
            StringBuilder query = new StringBuilder("SELECT");
            query.append(this.chooseBasedOnDatabaseTerm(() -> " TABLE_SCHEMA AS TABLE_CAT, NULL AS TABLE_SCHEM,", () -> " TABLE_CATALOG AS TABLE_CAT, TABLE_SCHEMA AS TABLE_SCHEM,"));
            query.append(" TABLE_NAME,");
            query.append(" CASE WHEN TABLE_TYPE = 'BASE TABLE' THEN");
            query.append(" CASE WHEN TABLE_SCHEMA = 'mysql' OR TABLE_SCHEMA = 'performance_schema' OR TABLE_SCHEMA = 'sys' THEN 'SYSTEM TABLE' ELSE 'TABLE' END");
            query.append(" WHEN TABLE_TYPE = 'TEMPORARY' THEN 'LOCAL_TEMPORARY' ELSE TABLE_TYPE END AS TABLE_TYPE,");
            query.append(" TABLE_COMMENT AS REMARKS,");
            query.append(" NULL AS TYPE_CAT,");
            query.append(" NULL AS TYPE_SCHEM,");
            query.append(" NULL AS TYPE_NAME,");
            query.append(" NULL AS SELF_REFERENCING_COL_NAME,");
            query.append(" NULL AS REF_GENERATION");
            query.append(" FROM INFORMATION_SCHEMA.TABLES");
            if (dbFilter != null || tableNameFilter != null) {
                query.append(" WHERE");
            }
            StringBuilder condition = new StringBuilder();
            if (dbFilter != null) {
                condition.append(this.chooseBasedOnDatabaseTerm(() -> " TABLE_SCHEMA = ?", () -> StringUtils.hasWildcards(dbFilter) ? " TABLE_SCHEMA LIKE ?" : " TABLE_SCHEMA = ?"));
            }
            if (tableNameFilter != null) {
                if (condition.length() > 0) {
                    condition.append(" AND");
                }
                condition.append(StringUtils.hasWildcards(tableNameFilter) ? " TABLE_NAME LIKE ?" : " TABLE_NAME = ?");
            }
            if (types != null && types.length > 0) {
                condition.append(" HAVING TABLE_TYPE IN (?,?,?,?,?)");
            }
            if (condition.length() > 0) {
                query.append((CharSequence)condition);
            }
            query.append(" ORDER BY TABLE_TYPE, TABLE_SCHEMA, TABLE_NAME");
            try (PreparedStatement pStmt = this.prepareMetaDataSafeStatement(query.toString());){
                int nextIdx = 1;
                if (dbFilter != null) {
                    pStmt.setString(nextIdx++, dbFilter != null ? dbFilter : "%");
                }
                if (tableNameFilter != null) {
                    pStmt.setString(nextIdx++, tableNameFilter);
                }
                if (types != null && types.length > 0) {
                    int i;
                    for (i = 0; i < 5; ++i) {
                        pStmt.setNull(nextIdx + i, MysqlType.VARCHAR.getJdbcType());
                    }
                    for (i = 0; i < types.length; ++i) {
                        DatabaseMetaData.TableType tableType = DatabaseMetaData.TableType.getTableTypeEqualTo(types[i]);
                        if (tableType == DatabaseMetaData.TableType.UNKNOWN) continue;
                        pStmt.setString(nextIdx++, tableType.getName());
                    }
                }
                ResultSet rs = this.executeMetadataQuery(pStmt);
                ((ResultSetInternalMethods)rs).setColumnDefinition(this.createTablesFields());
                ResultSet resultSet = rs;
                return resultSet;
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        try {
            if (table == null) {
                throw SQLError.createSQLException(Messages.getString("DatabaseMetaData.2"), "S1009", this.getExceptionInterceptor());
            }
            String dbFromTerm = this.chooseDatabaseTerm(catalog, schema);
            String dbFilter = this.normalizeIdentifierQuoting(dbFromTerm);
            String tableFilter = this.normalizeIdentifierQuoting(table);
            StringBuilder query = new StringBuilder("SELECT NULL AS SCOPE,");
            query.append(" COLUMN_NAME,");
            this.appendDataTypeClause(query, "COLUMN_TYPE").append(" AS DATA_TYPE,");
            this.appendTypeNameClause(query, "COLUMN_TYPE").append(" AS TYPE_NAME,");
            this.appendColumnSizeClause(query).append(" AS COLUMN_SIZE,");
            query.append(" ").append(MAX_BUFFER_SIZE).append(" AS BUFFER_LENGTH,");
            this.appendDecimalDigitsClause(query).append(" AS DECIMAL_DIGITS,");
            query.append(" ").append(1).append(" AS PSEUDO_COLUMN");
            query.append(" FROM INFORMATION_SCHEMA.COLUMNS WHERE");
            if (dbFilter != null) {
                query.append(" TABLE_SCHEMA = ? AND");
            }
            query.append(" TABLE_NAME = ?");
            query.append(" AND EXTRA LIKE '%on update CURRENT_TIMESTAMP%'");
            try (PreparedStatement pStmt = this.prepareMetaDataSafeStatement(query.toString());){
                int nextIdx = 1;
                if (dbFilter != null) {
                    pStmt.setString(nextIdx++, dbFilter);
                }
                pStmt.setString(nextIdx, tableFilter);
                ResultSet rs = this.executeMetadataQuery(pStmt);
                ((ResultSetInternalMethods)rs).getColumnDefinition().setFields(this.createVersionColumnsFields());
                ResultSet resultSet = rs;
                return resultSet;
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getInformationSchemaCollation() throws SQLException {
        String informationSchemaCollation = informationSchemaCollationCache.get(this.getJdbcConnection().getServerVersion());
        if (informationSchemaCollation != null) {
            return informationSchemaCollation;
        }
        INFORMATION_SCHEMA_COLLATION_CACHE_LOCK.lock();
        try {
            informationSchemaCollation = informationSchemaCollationCache.get(this.getJdbcConnection().getServerVersion());
            if (informationSchemaCollation != null) {
                String string = informationSchemaCollation;
                return string;
            }
            Statement stmt = this.getJdbcConnection().getMetaDataSafeStatement();
            ResultSet rs = stmt.executeQuery("SELECT DEFAULT_COLLATION_NAME FROM INFORMATION_SCHEMA.SCHEMATA WHERE SCHEMA_NAME = 'information_schema'");
            informationSchemaCollation = rs.next() ? rs.getString(1) : this.getSession().getServerSession().getServerVariable("collation_connection");
            stmt.close();
            informationSchemaCollationCache.put(this.getJdbcConnection().getServerVersion(), informationSchemaCollation);
            String string = informationSchemaCollation;
            return string;
        }
        finally {
            INFORMATION_SCHEMA_COLLATION_CACHE_LOCK.unlock();
        }
    }
}

