/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.internal;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Context;
import org.glassfish.hk2.api.Injectee;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.utilities.reflection.ReflectionHelper;
import org.jvnet.hk2.internal.Closeable;
import org.jvnet.hk2.internal.ServiceLocatorImpl;
import org.jvnet.hk2.internal.Utilities;

public class ServiceHandleImpl<T>
implements ServiceHandle<T> {
    private final ActiveDescriptor<T> root;
    private final ServiceLocatorImpl locator;
    private final LinkedList<Injectee> injectees = new LinkedList();
    private final ReentrantLock lock = new ReentrantLock();
    private boolean serviceDestroyed = false;
    private boolean serviceSet = false;
    private T service;
    private Object serviceData;
    private final LinkedList<ServiceHandleImpl<?>> subHandles = new LinkedList();

    ServiceHandleImpl(ServiceLocatorImpl locator, ActiveDescriptor<T> root, Injectee injectee) {
        this.root = root;
        this.locator = locator;
        if (injectee != null) {
            this.injectees.add(injectee);
        }
    }

    public T getService() {
        return this.getService(this);
    }

    private Injectee getLastInjectee() {
        this.lock.lock();
        try {
            Injectee injectee = this.injectees.isEmpty() ? null : this.injectees.getLast();
            return injectee;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    T getService(ServiceHandle<T> handle) {
        Closeable closeable;
        if (this.root instanceof Closeable && (closeable = (Closeable)this.root).isClosed()) {
            throw new IllegalStateException("This service has been unbound: " + this.root);
        }
        this.lock.lock();
        try {
            if (this.serviceDestroyed) {
                throw new IllegalStateException("Service has been disposed");
            }
            if (this.serviceSet) {
                closeable = this.service;
                return (T)closeable;
            }
            Injectee injectee = this.getLastInjectee();
            Class requiredClass = injectee == null ? null : ReflectionHelper.getRawClass((Type)injectee.getRequiredType());
            this.service = Utilities.createService(this.root, injectee, this.locator, handle, requiredClass);
            this.serviceSet = true;
            T t = this.service;
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    public ActiveDescriptor<T> getActiveDescriptor() {
        return this.root;
    }

    public boolean isActive() {
        if (this.serviceDestroyed) {
            return false;
        }
        if (this.serviceSet) {
            return true;
        }
        try {
            Context<?> context = this.locator.resolveContext(this.root.getScopeAnnotation());
            return context.containsKey(this.root);
        }
        catch (IllegalStateException ise) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ArrayList localSubHandles;
        boolean localServiceSet;
        boolean serviceActive;
        if (!this.root.isReified()) {
            return;
        }
        this.lock.lock();
        try {
            serviceActive = this.isActive();
            if (this.serviceDestroyed) {
                return;
            }
            this.serviceDestroyed = true;
            localServiceSet = this.serviceSet;
            localSubHandles = new ArrayList(this.subHandles);
            this.subHandles.clear();
        }
        finally {
            this.lock.unlock();
        }
        if (this.root.getScopeAnnotation().equals(PerLookup.class)) {
            if (localServiceSet) {
                this.root.dispose(this.service);
            }
        } else if (serviceActive) {
            Context<?> context;
            try {
                context = this.locator.resolveContext(this.root.getScopeAnnotation());
            }
            catch (Throwable throwable) {
                return;
            }
            context.destroyOne(this.root);
        }
        for (ServiceHandleImpl serviceHandleImpl : localSubHandles) {
            serviceHandleImpl.destroy();
        }
    }

    public void setServiceData(Object serviceData) {
        this.lock.lock();
        try {
            this.serviceData = serviceData;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Object getServiceData() {
        this.lock.lock();
        try {
            Object object = this.serviceData;
            return object;
        }
        finally {
            this.lock.unlock();
        }
    }

    public List<ServiceHandle<?>> getSubHandles() {
        this.lock.lock();
        try {
            ArrayList arrayList = new ArrayList(this.subHandles);
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void pushInjectee(Injectee push) {
        this.lock.lock();
        try {
            this.injectees.add(push);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void popInjectee() {
        this.lock.lock();
        try {
            this.injectees.removeLast();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addSubHandle(ServiceHandleImpl<?> subHandle) {
        this.lock.lock();
        try {
            this.subHandles.add(subHandle);
        }
        finally {
            this.lock.unlock();
        }
    }

    public Injectee getOriginalRequest() {
        Injectee injectee = this.getLastInjectee();
        return injectee;
    }

    public String toString() {
        return "ServiceHandle(" + this.root + "," + System.identityHashCode(this) + ")";
    }
}

