/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css3;

import java.util.ArrayList;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssCheckableValue;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssLayerList;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssValueList;

public class CssVoiceFamily
extends org.w3c.css.properties.css.CssVoiceFamily {
    public static final CssIdent[] genericVoices;
    public static final CssIdent[] age;
    public static final CssIdent preserve;

    static CssIdent getGenericVoiceName(CssIdent ident) {
        for (CssIdent id : genericVoices) {
            if (!id.equals(ident)) continue;
            return id;
        }
        return null;
    }

    static CssIdent getAge(CssIdent ident) {
        for (CssIdent id : age) {
            if (!id.equals(ident)) continue;
            return id;
        }
        return null;
    }

    public CssVoiceFamily() {
        this.value = initial;
    }

    public CssVoiceFamily(ApplContext ac, CssExpression expression, boolean check) throws InvalidParamException {
        ArrayList<CssValue> values = new ArrayList<CssValue>();
        while (!expression.end()) {
            char op = expression.getOperator();
            CssValue val = expression.getValue();
            switch (val.getType()) {
                case 0: 
                case 1: {
                    ArrayList<CssValue> cssValues = new ArrayList<CssValue>();
                    cssValues.add(val);
                    while (op == ' ' && expression.getRemainingCount() > 1) {
                        expression.next();
                        op = expression.getOperator();
                        val = expression.getValue();
                        int type = val.getType();
                        if (type == 0 || type == 1 || type == 5) {
                            cssValues.add(val);
                            continue;
                        }
                        throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                    }
                    this.checkExpression(ac, values, cssValues, check);
                    break;
                }
                default: {
                    throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                }
            }
            expression.next();
            if (expression.end() || op == ',') continue;
            throw new InvalidParamException("operator", Character.toString(op), ac);
        }
        this.value = values.size() > 1 ? new CssLayerList(values) : (CssValue)values.get(0);
        this.checkValues(ac, values);
    }

    public CssVoiceFamily(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    private void checkExpression(ApplContext ac, ArrayList<CssValue> curval, ArrayList<CssValue> values, boolean check) throws InvalidParamException {
        CssIdent ageVal = null;
        CssValue numVal = null;
        CssValue nameVal = null;
        ArrayList<CssValue> identl = null;
        for (CssValue val : values) {
            if (ageVal == null && nameVal == null && val.getType() == 0 && (ageVal = CssVoiceFamily.getAge(val.getIdent())) != null) continue;
            if (numVal == null) {
                switch (val.getType()) {
                    case 1: {
                        if (nameVal != null) {
                            throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                        }
                        nameVal = val;
                        break;
                    }
                    case 0: {
                        CssIdent id = val.getIdent();
                        if (CssIdent.isCssWide(id) || preserve.equals(id)) {
                            // empty if block
                        }
                        if (nameVal == null) {
                            nameVal = val;
                            identl = new ArrayList<CssValue>();
                        }
                        if (identl == null) {
                            throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                        }
                        identl.add(val);
                        break;
                    }
                    case 5: {
                        CssCheckableValue n = val.getCheckableValue();
                        n.checkStrictPositiveness(ac, this);
                        numVal = val;
                    }
                }
                continue;
            }
            throw new InvalidParamException("value", val, this.getPropertyName(), ac);
        }
        if (values.size() == 1) {
            if (nameVal == null) {
                throw new InvalidParamException("value", values.get(0), this.getPropertyName(), ac);
            }
            if (nameVal.getType() == 0) {
                this.hasGenericVoiceFamily = CssVoiceFamily.getGenericVoiceName(nameVal.getIdent()) != null;
            }
            curval.add(nameVal);
        } else {
            if (numVal != null || ageVal != null) {
                if (identl == null || identl.size() != 1) {
                    CssValueList v = new CssValueList(values);
                    throw new InvalidParamException("value", v, this.getPropertyName(), ac);
                }
                if (nameVal.getType() == 0 && CssVoiceFamily.getGenericVoiceName(nameVal.getIdent()) == null) {
                    throw new InvalidParamException("value", nameVal, this.getPropertyName(), ac);
                }
            } else if (identl != null) {
                if (identl.size() > 1) {
                    ac.getFrame().addWarning("with-space", 1);
                } else {
                    this.hasGenericVoiceFamily = CssVoiceFamily.getGenericVoiceName(((CssValue)identl.get(0)).getIdent()) != null;
                }
            }
            curval.add(new CssValueList(values));
        }
    }

    private void checkValues(ApplContext ac, ArrayList<CssValue> values) throws InvalidParamException {
        if (values.size() > 1) {
            for (CssValue val : values) {
                if (inherit != val && preserve != val) continue;
                throw new InvalidParamException("unrecognize", ac);
            }
        }
        if (inherit != this.value && preserve != this.value && !this.hasGenericVoiceFamily) {
            ac.getFrame().addWarning("no-generic-family", this.getPropertyName());
        }
    }

    static {
        preserve = CssIdent.getIdent("preserve");
        String[] _genericVoices = new String[]{"male", "female", "neutral"};
        genericVoices = new CssIdent[_genericVoices.length];
        int i = 0;
        for (String s : _genericVoices) {
            CssVoiceFamily.genericVoices[i++] = CssIdent.getIdent(s);
        }
        String[] _age = new String[]{"child", "young", "old"};
        age = new CssIdent[_age.length];
        i = 0;
        for (String s : _age) {
            CssVoiceFamily.age[i++] = CssIdent.getIdent(s);
        }
    }
}

