/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.quickconnect.utility;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleServerException;
import org.apache.guacamole.language.TranslatableGuacamoleClientException;
import org.apache.guacamole.protocol.GuacamoleConfiguration;

public class QCParser {
    private static final Pattern userinfoPattern = Pattern.compile("(^[^:]+):?(.*)");
    private static final int USERNAME_GROUP = 1;
    private static final int PASSWORD_GROUP = 2;
    private final Collection<String> allowedParams;
    private final Collection<String> deniedParams;

    public QCParser(Collection<String> allowedParams, Collection<String> deniedParams) {
        this.allowedParams = allowedParams;
        this.deniedParams = deniedParams;
    }

    public QCParser() {
        this.allowedParams = Collections.emptyList();
        this.deniedParams = Collections.emptyList();
    }

    public GuacamoleConfiguration getConfiguration(String uri) throws GuacamoleException {
        URI qcUri;
        try {
            qcUri = new URI(uri);
            if (!qcUri.isAbsolute()) {
                throw new TranslatableGuacamoleClientException("URI must be absolute.", "QUICKCONNECT.ERROR_NOT_ABSOLUTE_URI");
            }
        }
        catch (URISyntaxException e) {
            throw new TranslatableGuacamoleClientException("Invalid URI Syntax", "QUICKCONNECT.ERROR_INVALID_URI");
        }
        String protocol = qcUri.getScheme();
        String host = qcUri.getHost();
        int port = qcUri.getPort();
        String userInfo = qcUri.getUserInfo();
        String query = qcUri.getQuery();
        GuacamoleConfiguration qcConfig = new GuacamoleConfiguration();
        if (protocol == null || protocol.isEmpty()) {
            throw new TranslatableGuacamoleClientException("No protocol specified.", "QUICKCONNECT.ERROR_NO_PROTOCOL");
        }
        qcConfig.setProtocol(protocol);
        if (port > 0 && this.paramIsAllowed("port")) {
            qcConfig.setParameter("port", Integer.toString(port));
        }
        if (host == null || host.isEmpty() || !this.paramIsAllowed("hostname")) {
            throw new TranslatableGuacamoleClientException("No host specified.", "QUICKCONNECT.ERROR_NO_HOST");
        }
        qcConfig.setParameter("hostname", host);
        if (query != null && !query.isEmpty()) {
            this.parseQueryString(query, qcConfig);
        }
        if (userInfo != null && !userInfo.isEmpty()) {
            this.parseUserInfo(userInfo, qcConfig);
        }
        return qcConfig;
    }

    private void parseQueryString(String queryStr, GuacamoleConfiguration config) throws GuacamoleException {
        List<String> paramList = Arrays.asList(queryStr.split("&"));
        for (String param : paramList) {
            String[] paramArray = param.split("=", 2);
            try {
                String paramName = URLDecoder.decode(paramArray[0], "UTF-8");
                String paramValue = URLDecoder.decode(paramArray[1], "UTF-8");
                if (!this.paramIsAllowed(paramName)) continue;
                config.setParameter(paramName, paramValue);
            }
            catch (UnsupportedEncodingException e) {
                throw new GuacamoleServerException("Unexpected lack of UTF-8 encoding support.", (Throwable)e);
            }
        }
    }

    private void parseUserInfo(String userInfo, GuacamoleConfiguration config) throws GuacamoleException {
        Matcher userinfoMatcher = userinfoPattern.matcher(userInfo);
        if (userinfoMatcher.matches()) {
            String username = userinfoMatcher.group(1);
            String password = userinfoMatcher.group(2);
            if (username != null && !username.isEmpty() && this.paramIsAllowed("username")) {
                try {
                    config.setParameter("username", URLDecoder.decode(username, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new GuacamoleServerException("Unexpected lack of UTF-8 encoding support.", (Throwable)e);
                }
            }
            if (password != null && !password.isEmpty() && this.paramIsAllowed("password")) {
                try {
                    config.setParameter("password", URLDecoder.decode(password, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new GuacamoleServerException("Unexpected lack of UTF-8 encoding support.", (Throwable)e);
                }
            }
        }
    }

    public String getName(GuacamoleConfiguration config) throws GuacamoleException {
        if (config == null) {
            return null;
        }
        String protocol = config.getProtocol();
        String host = config.getParameter("hostname");
        String port = config.getParameter("port");
        String user = config.getParameter("username");
        StringBuilder name = new StringBuilder();
        if (protocol != null && !protocol.isEmpty()) {
            name.append(protocol).append("://");
        }
        if (user != null && !user.isEmpty()) {
            name.append(user).append("@");
        }
        if (host != null && !host.isEmpty()) {
            name.append(host);
        }
        if (port != null && !port.isEmpty()) {
            name.append(":").append(port);
        }
        name.append("/");
        return name.toString();
    }

    private boolean paramIsAllowed(String param) {
        if (this.allowedParams != null && !this.allowedParams.isEmpty() && !this.allowedParams.contains(param)) {
            return false;
        }
        return this.deniedParams == null || this.deniedParams.isEmpty() || !this.deniedParams.contains(param);
    }
}

